/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.socket.DuplexChannelConfig;
import io.netty.channel.unix.DomainSocketChannelConfig;
import io.netty.channel.unix.DomainSocketReadMode;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.util.Map;

public final class EpollDomainSocketChannelConfig
extends EpollChannelConfig
implements DuplexChannelConfig,
DomainSocketChannelConfig {
    private volatile DomainSocketReadMode mode = DomainSocketReadMode.BYTES;
    private volatile boolean allowHalfClosure;

    /*
     * WARNING - void declaration
     */
    EpollDomainSocketChannelConfig(AbstractEpollChannel channel) {
        super((Channel)var1_1);
        void var1_1;
    }

    @Override
    public final Map<ChannelOption<?>, Object> getOptions() {
        EpollDomainSocketChannelConfig epollDomainSocketChannelConfig = this;
        return epollDomainSocketChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{UnixChannelOption.DOMAIN_SOCKET_READ_MODE, ChannelOption.ALLOW_HALF_CLOSURE, ChannelOption.SO_SNDBUF, ChannelOption.SO_RCVBUF});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == UnixChannelOption.DOMAIN_SOCKET_READ_MODE) {
            return (T)this.getReadMode();
        }
        if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (option == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == UnixChannelOption.DOMAIN_SOCKET_READ_MODE) {
            this.setReadMode((DomainSocketReadMode)value);
        } else if (option == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)value);
        } else if (option == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final EpollDomainSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainSocketChannelConfig setAutoClose(boolean autoClose) {
        void var1_1;
        super.setAutoClose((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final EpollDomainSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        void var1_1;
        super.setWriteBufferLowWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final EpollDomainSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        void var1_1;
        super.setWriteBufferHighWaterMark((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainSocketChannelConfig setEpollMode(EpollMode mode) {
        void var1_1;
        super.setEpollMode((EpollMode)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainSocketChannelConfig setReadMode(DomainSocketReadMode mode) {
        void var1_1;
        this.mode = (DomainSocketReadMode)ObjectUtil.checkNotNull((Object)var1_1, (String)"mode");
        return this;
    }

    public final DomainSocketReadMode getReadMode() {
        return this.mode;
    }

    public final boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainSocketChannelConfig setAllowHalfClosure(boolean allowHalfClosure) {
        void var1_1;
        this.allowHalfClosure = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSendBufferSize() {
        try {
            return ((EpollDomainSocketChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainSocketChannelConfig setSendBufferSize(int sendBufferSize) {
        try {
            ((EpollDomainSocketChannel)this.channel).socket.setSendBufferSize(sendBufferSize);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getReceiveBufferSize() {
        try {
            return ((EpollDomainSocketChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            ((EpollDomainSocketChannel)this.channel).socket.setReceiveBufferSize(receiveBufferSize);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }
}

