/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollDomainDatagramChannel;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.unix.DomainDatagramChannelConfig;
import java.io.IOException;
import java.util.Map;

public final class EpollDomainDatagramChannelConfig
extends EpollChannelConfig
implements DomainDatagramChannelConfig {
    private boolean activeOnOpen;

    /*
     * WARNING - void declaration
     */
    EpollDomainDatagramChannelConfig(EpollDomainDatagramChannel channel) {
        super((Channel)var1_1, (RecvByteBufAllocator)new FixedRecvByteBufAllocator(2048));
        void var1_1;
    }

    @Override
    public final Map<ChannelOption<?>, Object> getOptions() {
        EpollDomainDatagramChannelConfig epollDomainDatagramChannelConfig = this;
        return epollDomainDatagramChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, ChannelOption.SO_SNDBUF});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getOption(ChannelOption<T> option) {
        void var1_1;
        if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            return (T)Boolean.valueOf(this.activeOnOpen);
        }
        if (option == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        return super.getOption(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            this.setActiveOnOpen((Boolean)value);
        } else if (option == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)value);
        } else {
            void var2_2;
            void var1_1;
            return super.setOption(var1_1, var2_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void setActiveOnOpen(boolean activeOnOpen) {
        void var1_1;
        if (this.channel.isRegistered()) {
            throw new IllegalStateException("Can only changed before channel was registered");
        }
        this.activeOnOpen = var1_1;
    }

    final boolean getActiveOnOpen() {
        return this.activeOnOpen;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setAllocator(ByteBufAllocator allocator) {
        void var1_1;
        super.setAllocator((ByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainDatagramChannelConfig setAutoClose(boolean autoClose) {
        void var1_1;
        super.setAutoClose((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setAutoRead(boolean autoRead) {
        void var1_1;
        super.setAutoRead((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        void var1_1;
        super.setConnectTimeoutMillis((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setEpollMode(EpollMode mode) {
        void var1_1;
        super.setEpollMode((EpollMode)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final EpollDomainDatagramChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        void var1_1;
        super.setMaxMessagesPerRead((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainDatagramChannelConfig setMaxMessagesPerWrite(int maxMessagesPerWrite) {
        void var1_1;
        super.setMaxMessagesPerWrite((int)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        void var1_1;
        super.setMessageSizeEstimator((MessageSizeEstimator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        void var1_1;
        super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final EpollDomainDatagramChannelConfig setSendBufferSize(int sendBufferSize) {
        try {
            ((EpollDomainDatagramChannel)this.channel).socket.setSendBufferSize(sendBufferSize);
            return this;
        }
        catch (IOException e) {
            void var1_2;
            throw new ChannelException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSendBufferSize() {
        try {
            return ((EpollDomainDatagramChannel)this.channel).socket.getSendBufferSize();
        }
        catch (IOException e) {
            void var1_1;
            throw new ChannelException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        void var1_1;
        super.setWriteBufferWaterMark((WriteBufferWaterMark)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EpollDomainDatagramChannelConfig setWriteSpinCount(int writeSpinCount) {
        void var1_1;
        super.setWriteSpinCount((int)var1_1);
        return this;
    }
}

