/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.SegmentedDatagramPacket;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

public final class EpollDatagramChannel
extends AbstractEpollChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final EpollDatagramChannelConfig config = new EpollDatagramChannelConfig(this);
    private volatile boolean connected;

    public static boolean isSegmentedDatagramPacketSupported() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_SENDMMSG && Native.IS_SUPPORTING_UDP_SEGMENT;
    }

    public EpollDatagramChannel() {
        this((InternetProtocolFamily)null);
    }

    /*
     * WARNING - void declaration
     */
    public EpollDatagramChannel(InternetProtocolFamily family) {
        this(LinuxSocket.newSocketDgram((InternetProtocolFamily)var1_1), false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EpollDatagramChannel(int fd) {
        this(new LinuxSocket((int)var1_1), true);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private EpollDatagramChannel(LinuxSocket fd, boolean active) {
        super(null, (LinuxSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || this.active);
    }

    public final boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            void var1_1;
            NetworkInterface iface = this.config().getNetworkInterface();
            if (iface == null) {
                iface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup((InetAddress)var1_1, iface, null, promise);
        }
        catch (IOException e) {
            void var2_2;
            void var3_4;
            promise.setFailure((Throwable)var3_4);
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.joinGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.joinGroup(var1_1.getAddress(), (NetworkInterface)var2_2, null, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.joinGroup((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        if (this.eventLoop().inEventLoop()) {
            this.joinGroup0(multicastAddress, networkInterface, source, promise);
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            this.eventLoop().execute(new Runnable(this, (InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, promise){
                final /* synthetic */ InetAddress val$multicastAddress;
                final /* synthetic */ NetworkInterface val$networkInterface;
                final /* synthetic */ InetAddress val$source;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ EpollDatagramChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$multicastAddress = inetAddress;
                    this.val$networkInterface = networkInterface;
                    this.val$source = inetAddress2;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    EpollDatagramChannel.access$000(this.this$0, this.val$multicastAddress, this.val$networkInterface, this.val$source, this.val$promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    private void joinGroup0(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        assert (this.eventLoop().inEventLoop());
        try {
            void var3_4;
            void var2_3;
            this.socket.joinGroup(multicastAddress, (NetworkInterface)var2_3, (InetAddress)var3_4);
            promise.setSuccess();
            return;
        }
        catch (IOException e) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress) {
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (IOException e) {
            void var2_3;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetSocketAddress)var1_1, (NetworkInterface)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.leaveGroup(var1_1.getAddress(), (NetworkInterface)var2_2, null, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.leaveGroup((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        if (this.eventLoop().inEventLoop()) {
            this.leaveGroup0(multicastAddress, networkInterface, source, promise);
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            this.eventLoop().execute(new Runnable(this, (InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, promise){
                final /* synthetic */ InetAddress val$multicastAddress;
                final /* synthetic */ NetworkInterface val$networkInterface;
                final /* synthetic */ InetAddress val$source;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ EpollDatagramChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$multicastAddress = inetAddress;
                    this.val$networkInterface = networkInterface;
                    this.val$source = inetAddress2;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    EpollDatagramChannel.access$100(this.this$0, this.val$multicastAddress, this.val$networkInterface, this.val$source, this.val$promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    private void leaveGroup0(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        assert (this.eventLoop().inEventLoop());
        try {
            void var3_4;
            void var2_3;
            this.socket.leaveGroup(multicastAddress, (NetworkInterface)var2_3, (InetAddress)var3_4);
            promise.setSuccess();
            return;
        }
        catch (IOException e) {
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.block((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise promise) {
        void var2_2;
        void var3_3;
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)var3_3, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)var2_2, (String)"networkInterface");
        promise.setFailure((Throwable)new UnsupportedOperationException("Multicast block not supported"));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        void var2_2;
        void var1_1;
        return this.block((InetAddress)var1_1, (InetAddress)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise promise) {
        try {
            void var2_3;
            return this.block(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), (InetAddress)var2_3, promise);
        }
        catch (Throwable e) {
            void var3_4;
            void var1_2;
            promise.setFailure((Throwable)var1_2);
            return var3_4;
        }
    }

    @Override
    protected final AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDatagramChannelUnsafe();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void doBind(SocketAddress localAddress) throws Exception {
        void var1_1;
        InetSocketAddress socketAddress;
        if (localAddress instanceof InetSocketAddress && (socketAddress = (InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && socketAddress.getAddress() instanceof Inet4Address && this.socket.family() == InternetProtocolFamily.IPv6) {
            void var2_2;
            localAddress = new InetSocketAddress(Native.INET6_ANY, var2_2.getPort());
        }
        super.doBind((SocketAddress)var1_1);
        this.active = true;
    }

    /*
     * WARNING - void declaration
     */
    protected final void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var1_1;
        Object msg;
        int maxMessagesPerWrite = this.maxMessagesPerWrite();
        while (maxMessagesPerWrite > 0 && (msg = in.current()) != null) {
            try {
                if (Native.IS_SUPPORTING_SENDMMSG && in.size() > 1 || in.current() instanceof SegmentedDatagramPacket) {
                    NativeDatagramPacketArray array = this.cleanDatagramPacketArray();
                    array.add(in, this.isConnected(), maxMessagesPerWrite);
                    int cnt = array.count();
                    if (cnt > 0) {
                        void var3_4;
                        NativeDatagramPacketArray.NativeDatagramPacket[] packets = array.packets();
                        int send = this.socket.sendmmsg(packets, 0, cnt);
                        if (send == 0) break;
                        for (int i = 0; i < send; ++i) {
                            in.remove();
                        }
                        maxMessagesPerWrite -= var3_4;
                        continue;
                    }
                }
                boolean done = false;
                for (int i = this.config().getWriteSpinCount(); i > 0; --i) {
                    void var3_3;
                    if (!this.doWriteMessage(var3_3)) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                in.remove();
                --maxMessagesPerWrite;
            }
            catch (IOException e) {
                --maxMessagesPerWrite;
                in.remove((Throwable)e);
            }
        }
        if (var1_1.isEmpty()) {
            this.clearFlag(Native.EPOLLOUT);
            return;
        }
        this.setFlag(Native.EPOLLOUT);
    }

    /*
     * WARNING - void declaration
     */
    private boolean doWriteMessage(Object msg) throws Exception {
        void var2_4;
        void var1_1;
        InetSocketAddress remoteAddress;
        ByteBuf data;
        if (msg instanceof AddressedEnvelope) {
            void var3_2;
            AddressedEnvelope envelope = (AddressedEnvelope)msg;
            data = (ByteBuf)envelope.content();
            remoteAddress = (InetSocketAddress)var3_2.recipient();
        } else {
            data = data;
            remoteAddress = null;
        }
        int n = data.readableBytes();
        if (n == 0) {
            return true;
        }
        return this.doWriteOrSendBytes((ByteBuf)var1_1, (InetSocketAddress)var2_4, false) > 0L;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> envelope) {
        AddressedEnvelope<?, ?> addressedEnvelope;
        if (envelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final Object filterOutboundMessage(Object msg) {
        void var1_1;
        if (msg instanceof SegmentedDatagramPacket) {
            if (!Native.IS_SUPPORTING_UDP_SEGMENT) {
                throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
            }
            SegmentedDatagramPacket packet = (SegmentedDatagramPacket)msg;
            EpollDatagramChannel.checkUnresolved(packet);
            ByteBuf content = (ByteBuf)packet.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                return packet.replace(this.newDirectBuffer(packet, content));
            }
            return msg;
        }
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            EpollDatagramChannel.checkUnresolved(packet);
            ByteBuf content = (ByteBuf)packet.content();
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                return new DatagramPacket(this.newDirectBuffer(packet, content), (InetSocketAddress)packet.recipient());
            }
            return msg;
        }
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)buf)) {
                return this.newDirectBuffer(buf);
            }
            return buf;
        }
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope e = (AddressedEnvelope)msg;
            EpollDatagramChannel.checkUnresolved(e);
            if (e.content() instanceof ByteBuf && (e.recipient() == null || e.recipient() instanceof InetSocketAddress)) {
                void var2_5;
                ByteBuf content = (ByteBuf)e.content();
                if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)content)) {
                    void var3_8;
                    return new DefaultAddressedEnvelope((Object)this.newDirectBuffer(e, (ByteBuf)var3_8), (SocketAddress)((InetSocketAddress)e.recipient()));
                }
                return var2_5;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    @Override
    public final EpollDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected final void doDisconnect() throws Exception {
        this.socket.disconnect();
        EpollDatagramChannel epollDatagramChannel = this;
        epollDatagramChannel.active = false;
        epollDatagramChannel.connected = false;
        this.resetCachedAddresses();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        void var2_2;
        void var1_1;
        if (super.doConnect((SocketAddress)var1_1, (SocketAddress)var2_2)) {
            this.connected = true;
            return true;
        }
        return false;
    }

    @Override
    protected final void doClose() throws Exception {
        super.doClose();
        this.connected = false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean connectedRead(EpollRecvByteAllocatorHandle allocHandle, ByteBuf byteBuf, int maxDatagramPacketSize) throws Exception {
        void var1_1;
        void var3_4;
        int localReadAmount;
        int writerIndex;
        int writable;
        block6: {
            block7: {
                try {
                    writable = maxDatagramPacketSize != 0 ? Math.min(byteBuf.writableBytes(), maxDatagramPacketSize) : byteBuf.writableBytes();
                    allocHandle.attemptedBytesRead(writable);
                    writerIndex = byteBuf.writerIndex();
                    if (byteBuf.hasMemoryAddress()) {
                        int n = writerIndex;
                        localReadAmount = this.socket.recvAddress(byteBuf.memoryAddress(), n, n + writable);
                    } else {
                        ByteBuffer buf;
                        ByteBuffer byteBuffer = buf = byteBuf.internalNioBuffer(writerIndex, writable);
                        localReadAmount = this.socket.recv(byteBuffer, byteBuffer.position(), buf.limit());
                    }
                    if (localReadAmount > 0) break block6;
                    allocHandle.lastBytesRead(localReadAmount);
                    if (byteBuf == null) break block7;
                }
                catch (Throwable throwable) {
                    if (byteBuf != null) {
                        void var2_3;
                        var2_3.release();
                    }
                    throw throwable;
                }
                byteBuf.release();
            }
            return false;
        }
        byteBuf.writerIndex(writerIndex + localReadAmount);
        allocHandle.lastBytesRead(var3_4 <= 0 ? localReadAmount : writable);
        DatagramPacket packet = new DatagramPacket(byteBuf, this.localAddress(), this.remoteAddress());
        var1_1.incMessagesRead(1);
        this.pipeline().fireChannelRead((Object)packet);
        byteBuf = null;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private IOException translateForConnected(Errors.NativeIoException e) {
        void var1_1;
        if (e.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            void var2_2;
            PortUnreachableException error = new PortUnreachableException(e.getMessage());
            error.initCause(e);
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void addDatagramPacketToOut(DatagramPacket packet, RecyclableArrayList out) {
        void var1_1;
        DatagramPacket datagramPacket;
        if (packet instanceof SegmentedDatagramPacket) {
            DatagramPacket segmentedDatagramPacket = (SegmentedDatagramPacket)packet;
            ByteBuf content = (ByteBuf)segmentedDatagramPacket.content();
            InetSocketAddress recipient = (InetSocketAddress)segmentedDatagramPacket.recipient();
            InetSocketAddress sender = (InetSocketAddress)segmentedDatagramPacket.sender();
            int segmentSize = segmentedDatagramPacket.segmentSize();
            do {
                ByteBuf byteBuf = content;
                out.add((Object)new DatagramPacket(byteBuf.readRetainedSlice(Math.min(byteBuf.readableBytes(), segmentSize)), recipient, sender));
            } while (content.isReadable());
            datagramPacket.release();
            return;
        }
        var1_1.add((Object)datagramPacket);
    }

    /*
     * WARNING - void declaration
     */
    private static void releaseAndRecycle(ByteBuf byteBuf, RecyclableArrayList packetList) {
        if (byteBuf != null) {
            byteBuf.release();
        }
        if (packetList != null) {
            void var1_2;
            for (int i = 0; i < packetList.size(); ++i) {
                ReferenceCountUtil.release((Object)packetList.get(i));
            }
            var1_2.recycle();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void processPacket(ChannelPipeline pipeline, EpollRecvByteAllocatorHandle handle, int bytesRead, DatagramPacket packet) {
        void var3_3;
        ChannelPipeline channelPipeline;
        void var1_1;
        void var2_2;
        handle.lastBytesRead(Math.max(1, (int)var2_2));
        var1_1.incMessagesRead(1);
        channelPipeline.fireChannelRead((Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void processPacketList(ChannelPipeline pipeline, EpollRecvByteAllocatorHandle handle, int bytesRead, RecyclableArrayList packetList) {
        void var2_3;
        int messagesRead = packetList.size();
        handle.lastBytesRead(Math.max(1, (int)var2_3));
        handle.incMessagesRead(messagesRead);
        for (int i = 0; i < messagesRead; ++i) {
            pipeline.fireChannelRead(packetList.set(i, (Object)Unpooled.EMPTY_BUFFER));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean recvmsg(EpollRecvByteAllocatorHandle allocHandle, NativeDatagramPacketArray array, ByteBuf byteBuf) throws IOException {
        block6: {
            void var1_1;
            void var2_3;
            int bytesReceived;
            NativeDatagramPacketArray.NativeDatagramPacket msg;
            RecyclableArrayList datagramPackets;
            block5: {
                datagramPackets = null;
                try {
                    int writable = byteBuf.writableBytes();
                    ByteBuf byteBuf2 = byteBuf;
                    boolean added = array.addWritable(byteBuf2, byteBuf2.writerIndex(), writable);
                    assert (added);
                    allocHandle.attemptedBytesRead(writable);
                    msg = array.packets()[0];
                    bytesReceived = this.socket.recvmsg(msg);
                    if (msg.hasSender()) break block5;
                    allocHandle.lastBytesRead(-1);
                }
                catch (Throwable throwable) {
                    void var3_4;
                    EpollDatagramChannel.releaseAndRecycle((ByteBuf)var3_4, datagramPackets);
                    throw throwable;
                }
                EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
                return false;
            }
            byteBuf.writerIndex(bytesReceived);
            InetSocketAddress local = this.localAddress();
            DatagramPacket packet = msg.newDatagramPacket(byteBuf, local);
            if (!(packet instanceof SegmentedDatagramPacket)) {
                EpollDatagramChannel.processPacket(this.pipeline(), allocHandle, bytesReceived, packet);
                break block6;
            }
            datagramPackets = RecyclableArrayList.newInstance();
            EpollDatagramChannel.addDatagramPacketToOut((DatagramPacket)var2_3, datagramPackets);
            EpollDatagramChannel.processPacketList(this.pipeline(), (EpollRecvByteAllocatorHandle)var1_1, bytesReceived, datagramPackets);
            datagramPackets.recycle();
            datagramPackets = null;
        }
        EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean scatteringRead(EpollRecvByteAllocatorHandle allocHandle, NativeDatagramPacketArray array, ByteBuf byteBuf, int datagramSize, int numDatagram) throws IOException {
        int bytesReceived;
        InetSocketAddress local;
        int received;
        NativeDatagramPacketArray.NativeDatagramPacket[] packets;
        RecyclableArrayList datagramPackets;
        block7: {
            DatagramPacket packet;
            block6: {
                datagramPackets = null;
                int offset = byteBuf.writerIndex();
                int i = 0;
                while (i < numDatagram && array.addWritable(byteBuf, offset, datagramSize)) {
                    ++i;
                    offset += datagramSize;
                }
                allocHandle.attemptedBytesRead(offset - byteBuf.writerIndex());
                packets = array.packets();
                received = this.socket.recvmmsg(packets, 0, array.count());
                if (received != 0) break block6;
                allocHandle.lastBytesRead(-1);
                EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
                return false;
            }
            local = this.localAddress();
            bytesReceived = received * datagramSize;
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.writerIndex(byteBuf2.writerIndex() + bytesReceived);
            if (received != 1 || (packet = packets[0].newDatagramPacket(byteBuf, local)) instanceof SegmentedDatagramPacket) break block7;
            EpollDatagramChannel.processPacket(this.pipeline(), allocHandle, datagramSize, packet);
            EpollDatagramChannel.releaseAndRecycle(byteBuf, null);
            return true;
        }
        try {
            void var1_1;
            datagramPackets = RecyclableArrayList.newInstance();
            for (int i = 0; i < received; ++i) {
                DatagramPacket packet = packets[i].newDatagramPacket(byteBuf, local);
                byteBuf.skipBytes(datagramSize);
                EpollDatagramChannel.addDatagramPacketToOut(packet, datagramPackets);
            }
            byteBuf.release();
            byteBuf = null;
            EpollDatagramChannel.processPacketList(this.pipeline(), (EpollRecvByteAllocatorHandle)var1_1, bytesReceived, datagramPackets);
            datagramPackets.recycle();
            datagramPackets = null;
        }
        catch (Throwable throwable) {
            void var3_5;
            EpollDatagramChannel.releaseAndRecycle((ByteBuf)var3_5, datagramPackets);
            throw throwable;
        }
        EpollDatagramChannel.releaseAndRecycle(null, null);
        return true;
    }

    private NativeDatagramPacketArray cleanDatagramPacketArray() {
        return ((EpollEventLoop)this.eventLoop()).cleanDatagramPacketArray();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(EpollDatagramChannel x0, InetAddress x1, NetworkInterface x2, InetAddress x3, ChannelPromise x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.joinGroup0((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(EpollDatagramChannel x0, InetAddress x1, NetworkInterface x2, InetAddress x3, ChannelPromise x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.leaveGroup0((InetAddress)var1_1, (NetworkInterface)var2_2, (InetAddress)var3_3, x4);
    }

    static /* synthetic */ NativeDatagramPacketArray access$200(EpollDatagramChannel x0) {
        return x0.cleanDatagramPacketArray();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$300(EpollDatagramChannel x0, EpollRecvByteAllocatorHandle x1, NativeDatagramPacketArray x2, ByteBuf x3) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.recvmsg((EpollRecvByteAllocatorHandle)var1_1, (NativeDatagramPacketArray)var2_2, (ByteBuf)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$400(EpollDatagramChannel x0, EpollRecvByteAllocatorHandle x1, ByteBuf x2, int x3) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.connectedRead((EpollRecvByteAllocatorHandle)var1_1, (ByteBuf)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$500(EpollDatagramChannel x0, EpollRecvByteAllocatorHandle x1, NativeDatagramPacketArray x2, ByteBuf x3, int x4, int x5) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.scatteringRead((EpollRecvByteAllocatorHandle)var1_1, (NativeDatagramPacketArray)var2_2, (ByteBuf)var3_3, x4, x5);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ IOException access$600(EpollDatagramChannel x0, Errors.NativeIoException x1) {
        void var1_1;
        return x0.translateForConnected((Errors.NativeIoException)var1_1);
    }

    final class EpollDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        /*
         * WARNING - void declaration
         */
        EpollDatagramChannelUnsafe() {
            void var1_1;
        }

        /*
         * Exception decompiling
         */
        @Override
        final void epollInReady() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

