/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.SystemPropertyUtil;

public final class Epoll {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return Epoll.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    private Epoll() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        void var0;
        block16: {
            Throwable cause2222 = null;
            if (SystemPropertyUtil.getBoolean((String)"io.netty.transport.noNative", (boolean)false)) {
                cause2222 = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
            } else {
                FileDescriptor eventFd;
                block15: {
                    FileDescriptor epollFd = null;
                    try {
                        epollFd = Native.newEpollCreate();
                        eventFd = Native.newEventFd();
                        if (epollFd == null) break block15;
                    }
                    catch (Throwable throwable) {
                        cause2222 = throwable;
                        cause2222 = throwable;
                        if (epollFd != null) {
                            try {
                                epollFd.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block16;
                    }
                    catch (Throwable cause2222) {
                        if (epollFd == null) throw cause2222;
                        try {
                            void var1_2;
                            var1_2.close();
                            throw cause2222;
                        }
                        catch (Exception exception) {}
                        throw cause2222;
                    }
                    try {
                        epollFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (eventFd != null) {
                    try {
                        void var2_3;
                        var2_3.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        UNAVAILABILITY_CAUSE = var0;
    }
}

