/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.EpollRecvByteAllocatorStreamingHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.SocketWritableByteChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;

public abstract class AbstractEpollStreamChannel
extends AbstractEpollChannel
implements DuplexChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEpollStreamChannel.class);
    private final Runnable flushTask;
    private volatile Queue<SpliceInTask> spliceQueue;
    private FileDescriptor pipeIn;
    private FileDescriptor pipeOut;
    private WritableByteChannel byteChannel;

    /*
     * WARNING - void declaration
     */
    protected AbstractEpollStreamChannel(Channel parent, int fd) {
        this((Channel)var1_1, new LinuxSocket((int)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractEpollStreamChannel(int fd) {
        this(new LinuxSocket((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AbstractEpollStreamChannel(LinuxSocket fd) {
        void var1_1;
        void v0 = var1_1;
        this((LinuxSocket)v0, AbstractEpollStreamChannel.isSoErrorZero((Socket)v0));
    }

    /*
     * WARNING - void declaration
     */
    AbstractEpollStreamChannel(Channel parent, LinuxSocket fd) {
        super((Channel)var1_1, (LinuxSocket)var2_2, true);
        void var2_2;
        void var1_1;
        this.flushTask = new Runnable(this){
            final /* synthetic */ AbstractEpollStreamChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                ((AbstractEpollChannel.AbstractEpollUnsafe)this.this$0.unsafe()).flush0();
            }
        };
        this.flags |= Native.EPOLLRDHUP;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractEpollStreamChannel(Channel parent, LinuxSocket fd, SocketAddress remote) {
        super((Channel)var1_1, (LinuxSocket)var2_2, (SocketAddress)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.flushTask = new /* invalid duplicate definition of identical inner class */;
        this.flags |= Native.EPOLLRDHUP;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractEpollStreamChannel(LinuxSocket fd, boolean active) {
        super(null, (LinuxSocket)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
        this.flushTask = new /* invalid duplicate definition of identical inner class */;
        this.flags |= Native.EPOLLRDHUP;
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollStreamUnsafe();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture spliceTo(AbstractEpollStreamChannel ch, int len) {
        void var2_2;
        void var1_1;
        return this.spliceTo((AbstractEpollStreamChannel)var1_1, (int)var2_2, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture spliceTo(AbstractEpollStreamChannel ch, int len, ChannelPromise promise) {
        void var3_3;
        if (ch.eventLoop() != this.eventLoop()) {
            throw new IllegalArgumentException("EventLoops are not the same.");
        }
        ObjectUtil.checkPositiveOrZero((int)len, (String)"len");
        if (ch.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED || this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        if (!this.isOpen()) {
            promise.tryFailure((Throwable)new ClosedChannelException());
        } else {
            void var2_2;
            void var1_1;
            this.addToSpliceQueue(new SpliceInChannelTask((AbstractEpollStreamChannel)var1_1, (int)var2_2, promise));
            this.failSpliceIfClosed(promise);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture spliceTo(FileDescriptor ch, int offset, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.spliceTo((FileDescriptor)var1_1, (int)var2_2, (int)var3_3, this.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public final ChannelFuture spliceTo(FileDescriptor ch, int offset, int len, ChannelPromise promise) {
        ObjectUtil.checkPositiveOrZero((int)len, (String)"len");
        ObjectUtil.checkPositiveOrZero((int)offset, (String)"offset");
        if (this.config().getEpollMode() != EpollMode.LEVEL_TRIGGERED) {
            throw new IllegalStateException("spliceTo() supported only when using " + (Object)((Object)EpollMode.LEVEL_TRIGGERED));
        }
        ObjectUtil.checkNotNull((Object)promise, (String)"promise");
        if (!this.isOpen()) {
            promise.tryFailure((Throwable)new ClosedChannelException());
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            this.addToSpliceQueue(new SpliceFdTask((FileDescriptor)var1_1, (int)var2_2, (int)var3_3, promise));
            this.failSpliceIfClosed(promise);
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    private void failSpliceIfClosed(ChannelPromise promise) {
        ClosedChannelException ex;
        void var1_1;
        if (!this.isOpen() && !promise.isDone() && var1_1.tryFailure((Throwable)(ex = new ClosedChannelException()))) {
            void var2_2;
            this.eventLoop().execute(new Runnable(this, (ClosedChannelException)var2_2){
                final /* synthetic */ ClosedChannelException val$ex;
                final /* synthetic */ AbstractEpollStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ex = closedChannelException;
                }

                @Override
                public void run() {
                    AbstractEpollStreamChannel.access$000(this.this$0, this.val$ex);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private int writeBytes(ChannelOutboundBuffer in, ByteBuf buf) throws Exception {
        void var3_3;
        void var1_1;
        void var2_2;
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            in.remove();
            return 0;
        }
        if (buf.hasMemoryAddress() || buf.nioBufferCount() == 1) {
            return this.doWriteBytes(in, buf);
        }
        ByteBuffer[] nioBuffers = buf.nioBuffers();
        void v0 = var2_2;
        return this.writeBytesMultiple((ChannelOutboundBuffer)var1_1, (ByteBuffer[])v0, ((void)v0).length, (long)var3_3, this.config().getMaxBytesPerGatheringWrite());
    }

    /*
     * WARNING - void declaration
     */
    private void adjustMaxBytesPerGatheringWrite(long attempted, long written, long oldMaxBytesPerGatheringWrite) {
        void var3_2;
        if (attempted == written) {
            if (attempted << 1 > oldMaxBytesPerGatheringWrite) {
                this.config().setMaxBytesPerGatheringWrite(attempted << 1);
                return;
            }
        } else if (attempted > 4096L && var3_2 < attempted >>> 1) {
            void var1_1;
            this.config().setMaxBytesPerGatheringWrite((long)(var1_1 >>> 1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private int writeBytesMultiple(ChannelOutboundBuffer in, IovArray array) throws IOException {
        long expectedWrittenBytes = array.size();
        assert (expectedWrittenBytes != 0L);
        int cnt = array.count();
        assert (cnt != 0);
        long localWrittenBytes = this.socket.writevAddresses(array.memoryAddress(0), cnt);
        if (localWrittenBytes > 0L) {
            void var1_1;
            void var2_2;
            void var3_3;
            this.adjustMaxBytesPerGatheringWrite((long)var3_3, localWrittenBytes, var2_2.maxBytes());
            var1_1.removeBytes(localWrittenBytes);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private int writeBytesMultiple(ChannelOutboundBuffer in, ByteBuffer[] nioBuffers, int nioBufferCnt, long expectedWrittenBytes, long maxBytesPerGatheringWrite) throws IOException {
        void var3_3;
        void var2_2;
        long localWrittenBytes;
        assert (expectedWrittenBytes != 0L);
        if (expectedWrittenBytes > maxBytesPerGatheringWrite) {
            expectedWrittenBytes = maxBytesPerGatheringWrite;
        }
        if ((localWrittenBytes = this.socket.writev((ByteBuffer[])var2_2, 0, (int)var3_3, expectedWrittenBytes)) > 0L) {
            void var1_1;
            this.adjustMaxBytesPerGatheringWrite(expectedWrittenBytes, localWrittenBytes, maxBytesPerGatheringWrite);
            var1_1.removeBytes(localWrittenBytes);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private int writeDefaultFileRegion(ChannelOutboundBuffer in, DefaultFileRegion region) throws Exception {
        long regionCount;
        long offset = region.transferred();
        if (offset >= (regionCount = region.count())) {
            in.remove();
            return 0;
        }
        DefaultFileRegion defaultFileRegion = region;
        long flushedAmount = this.socket.sendFile(defaultFileRegion, defaultFileRegion.position(), offset, regionCount - offset);
        if (flushedAmount > 0L) {
            in.progress(flushedAmount);
            if (region.transferred() >= regionCount) {
                void var1_1;
                var1_1.remove();
            }
            return 1;
        }
        if (flushedAmount == 0L) {
            void var3_3;
            void var2_2;
            this.validateFileRegion((DefaultFileRegion)var2_2, (long)var3_3);
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private int writeFileRegion(ChannelOutboundBuffer in, FileRegion region) throws Exception {
        long flushedAmount;
        if (region.transferred() >= region.count()) {
            in.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new EpollSocketWritableByteChannel();
        }
        if ((flushedAmount = region.transferTo(this.byteChannel, region.transferred())) > 0L) {
            void var2_2;
            void var3_3;
            in.progress((long)var3_3);
            if (region.transferred() >= var2_2.count()) {
                void var1_1;
                var1_1.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        void var2_2;
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            void var3_3;
            int msgCount;
            if ((msgCount = in.size()) > 1 && in.current() instanceof ByteBuf) {
                writeSpinCount -= this.doWriteMultiple(in);
                continue;
            }
            if (var3_3 == false) {
                this.clearFlag(Native.EPOLLOUT);
                return;
            }
            writeSpinCount -= this.doWriteSingle(in);
        } while (writeSpinCount > 0);
        if (var2_2 == false) {
            this.clearFlag(Native.EPOLLOUT);
            this.eventLoop().execute(this.flushTask);
            return;
        }
        this.setFlag(Native.EPOLLOUT);
    }

    /*
     * WARNING - void declaration
     */
    protected int doWriteSingle(ChannelOutboundBuffer in) throws Exception {
        Object msg = in.current();
        if (msg instanceof ByteBuf) {
            return this.writeBytes(in, (ByteBuf)msg);
        }
        if (msg instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(in, (DefaultFileRegion)msg);
        }
        if (msg instanceof FileRegion) {
            return this.writeFileRegion(in, (FileRegion)msg);
        }
        if (msg instanceof SpliceOutTask) {
            void var1_1;
            void var2_2;
            if (!((SpliceOutTask)var2_2).spliceOut()) {
                return Integer.MAX_VALUE;
            }
            var1_1.remove();
            return 1;
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    private int doWriteMultiple(ChannelOutboundBuffer in) throws Exception {
        void var1_1;
        void var2_2;
        long maxBytesPerGatheringWrite = this.config().getMaxBytesPerGatheringWrite();
        IovArray array = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
        array.maxBytes((long)var2_2);
        in.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)array);
        if (array.count() > 0) {
            return this.writeBytesMultiple(in, array);
        }
        var1_1.removeBytes(0L);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected Object filterOutboundMessage(Object msg) {
        void var1_1;
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UnixChannelUtil.isBufferCopyNeededForWrite((ByteBuf)buf)) {
                return this.newDirectBuffer(buf);
            }
            return var1_1;
        }
        if (var1_1 instanceof FileRegion || var1_1 instanceof SpliceOutTask) {
            return var1_1;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)var1_1) + EXPECTED_TYPES);
    }

    protected final void doShutdownOutput() throws Exception {
        this.socket.shutdown(false, true);
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.socket.shutdown(true, false);
            promise.setSuccess();
            return;
        }
        catch (Throwable cause) {
            void var2_2;
            void var1_1;
            var1_1.setFailure((Throwable)var2_2);
            return;
        }
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public ChannelFuture shutdownOutput() {
        AbstractEpollStreamChannel abstractEpollStreamChannel = this;
        return abstractEpollStreamChannel.shutdownOutput(abstractEpollStreamChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        void var1_1;
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise);
        } else {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractEpollStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)this.this$0.unsafe()).shutdownOutput(this.val$promise);
                }
            });
        }
        return var1_1;
    }

    public ChannelFuture shutdownInput() {
        AbstractEpollStreamChannel abstractEpollStreamChannel = this;
        return abstractEpollStreamChannel.shutdownInput(abstractEpollStreamChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture shutdownInput(ChannelPromise promise) {
        void var1_1;
        Executor closeExecutor = ((EpollStreamUnsafe)this.unsafe()).prepareToClose();
        if (closeExecutor != null) {
            closeExecutor.execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractEpollStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    AbstractEpollStreamChannel.access$100(this.this$0, this.val$promise);
                }
            });
        } else {
            EventLoop loop = this.eventLoop();
            if (loop.inEventLoop()) {
                this.shutdownInput0(promise);
            } else {
                void var2_2;
                var2_2.execute(new Runnable(this, promise){
                    final /* synthetic */ ChannelPromise val$promise;
                    final /* synthetic */ AbstractEpollStreamChannel this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$promise = channelPromise;
                    }

                    @Override
                    public void run() {
                        AbstractEpollStreamChannel.access$100(this.this$0, this.val$promise);
                    }
                });
            }
        }
        return var1_1;
    }

    public ChannelFuture shutdown() {
        AbstractEpollStreamChannel abstractEpollStreamChannel = this;
        return abstractEpollStreamChannel.shutdown(abstractEpollStreamChannel.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture shutdown(ChannelPromise promise) {
        void var1_1;
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            void var2_2;
            var2_2.addListener((GenericFutureListener)new ChannelFutureListener(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ AbstractEpollStreamChannel this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    void var1_1;
                    AbstractEpollStreamChannel.access$200(this.this$0, (ChannelFuture)var1_1, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownOutputDone(ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            AbstractEpollStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
            return;
        }
        var3_3.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelFuture)var1_1, (ChannelPromise)var2_2){
            final /* synthetic */ ChannelFuture val$shutdownOutputFuture;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ AbstractEpollStreamChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$shutdownOutputFuture = channelFuture;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                void var1_1;
                AbstractEpollStreamChannel.access$300(this.val$shutdownOutputFuture, (ChannelFuture)var1_1, this.val$promise);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        void var2_2;
        Object shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            Object object;
            if (shutdownInputCause != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure((Throwable)object);
            return;
        }
        if (shutdownInputCause != null) {
            void var1_1;
            promise.setFailure((Throwable)var1_1);
            return;
        }
        var2_2.setSuccess();
    }

    @Override
    protected void doClose() throws Exception {
        try {
            super.doClose();
            return;
        }
        finally {
            AbstractEpollStreamChannel.safeClosePipe(this.pipeIn);
            AbstractEpollStreamChannel.safeClosePipe(this.pipeOut);
            this.clearSpliceQueue(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void clearSpliceQueue(ClosedChannelException exception) {
        SpliceInTask task;
        Queue<SpliceInTask> sQueue = this.spliceQueue;
        if (sQueue == null) {
            return;
        }
        while ((task = sQueue.poll()) != null) {
            void var3_3;
            if (exception == null) {
                exception = new ClosedChannelException();
            }
            var3_3.promise.tryFailure((Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void safeClosePipe(FileDescriptor fd) {
        if (fd != null) {
            try {
                fd.close();
                return;
            }
            catch (IOException e) {
                void var0_1;
                logger.warn("Error while closing a pipe", (Throwable)var0_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addToSpliceQueue(SpliceInTask task) {
        void var1_1;
        void var2_3;
        Queue sQueue = this.spliceQueue;
        if (sQueue == null) {
            AbstractEpollStreamChannel abstractEpollStreamChannel = this;
            synchronized (abstractEpollStreamChannel) {
                sQueue = this.spliceQueue;
                if (sQueue == null) {
                    this.spliceQueue = sQueue = PlatformDependent.newMpscQueue();
                }
            }
        }
        var2_3.add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AbstractEpollStreamChannel x0, ClosedChannelException x1) {
        void var1_1;
        x0.clearSpliceQueue((ClosedChannelException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(AbstractEpollStreamChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.shutdownInput0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(AbstractEpollStreamChannel x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        x0.shutdownOutputDone((ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(ChannelFuture x0, ChannelFuture x1, ChannelPromise x2) {
        void var2_2;
        void var1_1;
        AbstractEpollStreamChannel.shutdownDone(x0, (ChannelFuture)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ FileDescriptor access$602(AbstractEpollStreamChannel x0, FileDescriptor x1) {
        void var1_1;
        x0.pipeIn = var1_1;
        return x0.pipeIn;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ FileDescriptor access$502(AbstractEpollStreamChannel x0, FileDescriptor x1) {
        void var1_1;
        x0.pipeOut = var1_1;
        return x0.pipeOut;
    }

    private final class EpollSocketWritableByteChannel
    extends SocketWritableByteChannel {
        EpollSocketWritableByteChannel() {
            super((FileDescriptor)AbstractEpollStreamChannel.this.socket);
            assert (this.fd == AbstractEpollStreamChannel.this.socket);
        }

        /*
         * WARNING - void declaration
         */
        protected final int write(ByteBuffer buf, int pos, int limit) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            return AbstractEpollStreamChannel.this.socket.send((ByteBuffer)var1_1, (int)var2_2, (int)var3_3);
        }

        protected final ByteBufAllocator alloc() {
            return AbstractEpollStreamChannel.this.alloc();
        }
    }

    private final class SpliceFdTask
    extends SpliceInTask {
        private final FileDescriptor fd;
        private final ChannelPromise promise;
        private int offset;

        /*
         * WARNING - void declaration
         */
        SpliceFdTask(FileDescriptor fd, int offset, int len, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            super(AbstractEpollStreamChannel.this, len, promise);
            this.fd = var2_2;
            this.promise = promise;
            this.offset = var3_3;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final boolean spliceIn(RecvByteBufAllocator.Handle handle) {
            assert (AbstractEpollStreamChannel.this.eventLoop().inEventLoop());
            if (this.len == 0) {
                this.promise.trySuccess();
                return true;
            }
            try {
                FileDescriptor pipeOut;
                FileDescriptor pipeIn;
                block8: {
                    FileDescriptor[] pipe = FileDescriptor.pipe();
                    pipeIn = pipe[0];
                    pipeOut = pipe[1];
                    try {
                        int splicedOut;
                        int splicedIn = this.spliceIn(pipeOut, handle);
                        if (splicedIn <= 0) break block8;
                        if (this.len != Integer.MAX_VALUE) {
                            this.len -= splicedIn;
                        }
                        do {
                            splicedOut = Native.splice(pipeIn.intValue(), -1L, this.fd.intValue(), this.offset, splicedIn);
                            this.offset += splicedOut;
                        } while ((splicedIn -= splicedOut) > 0);
                        if (this.len != 0) break block8;
                        this.promise.trySuccess();
                    }
                    catch (Throwable throwable) {
                        void var3_6;
                        AbstractEpollStreamChannel.safeClosePipe((FileDescriptor)var3_6);
                        AbstractEpollStreamChannel.safeClosePipe(pipeOut);
                        throw throwable;
                    }
                    AbstractEpollStreamChannel.safeClosePipe(pipeIn);
                    AbstractEpollStreamChannel.safeClosePipe(pipeOut);
                    return true;
                }
                AbstractEpollStreamChannel.safeClosePipe(pipeIn);
                AbstractEpollStreamChannel.safeClosePipe(pipeOut);
                return false;
            }
            catch (Throwable cause) {
                void var2_5;
                this.promise.tryFailure((Throwable)var2_5);
                return true;
            }
        }
    }

    private final class SpliceOutTask {
        private final AbstractEpollStreamChannel ch;
        private final boolean autoRead;
        private int len;

        /*
         * WARNING - void declaration
         */
        SpliceOutTask(AbstractEpollStreamChannel ch, int len, boolean autoRead) {
            void var3_3;
            void var2_2;
            this.ch = var2_2;
            this.len = var3_3;
            this.autoRead = autoRead;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean spliceOut() throws Exception {
            assert (this.ch.eventLoop().inEventLoop());
            try {
                int splicedOut = Native.splice(this.ch.pipeIn.intValue(), -1L, this.ch.socket.intValue(), -1L, this.len);
                this.len -= splicedOut;
                if (this.len == 0) {
                    if (this.autoRead) {
                        AbstractEpollStreamChannel.this.config().setAutoRead(true);
                    }
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                void var1_2;
                if (this.autoRead) {
                    AbstractEpollStreamChannel.this.config().setAutoRead(true);
                }
                throw var1_2;
            }
        }
    }

    private final class SpliceInChannelTask
    extends SpliceInTask
    implements ChannelFutureListener {
        private final AbstractEpollStreamChannel ch;

        /*
         * WARNING - void declaration
         */
        SpliceInChannelTask(AbstractEpollStreamChannel ch, int len, ChannelPromise promise) {
            void var2_2;
            void var3_3;
            super(AbstractEpollStreamChannel.this, (int)var3_3, promise);
            this.ch = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                void var1_1;
                this.promise.tryFailure(var1_1.cause());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean spliceIn(RecvByteBufAllocator.Handle handle) {
            assert (this.ch.eventLoop().inEventLoop());
            if (this.len == 0) {
                this.promise.trySuccess();
                return true;
            }
            try {
                int splicedIn;
                FileDescriptor pipe;
                FileDescriptor pipeOut = this.ch.pipeOut;
                if (pipeOut == null) {
                    pipe = FileDescriptor.pipe();
                    AbstractEpollStreamChannel.access$602(this.ch, pipe[0]);
                    pipe = AbstractEpollStreamChannel.access$502(this.ch, pipe[1]);
                }
                if ((splicedIn = this.spliceIn(pipe, handle)) > 0) {
                    void var1_1;
                    void var3_5;
                    if (this.len != Integer.MAX_VALUE) {
                        this.len -= splicedIn;
                    }
                    ChannelPromise splicePromise = this.len == 0 ? this.promise : this.ch.newPromise().addListener((GenericFutureListener)this);
                    boolean autoRead = AbstractEpollStreamChannel.this.config().isAutoRead();
                    this.ch.unsafe().write((Object)new SpliceOutTask(this.ch, splicedIn, autoRead), splicePromise);
                    this.ch.unsafe().flush();
                    if (var3_5 != false && !var1_1.isDone()) {
                        AbstractEpollStreamChannel.this.config().setAutoRead(false);
                    }
                }
                return this.len == 0;
            }
            catch (Throwable cause) {
                void var2_4;
                this.promise.tryFailure((Throwable)var2_4);
                return true;
            }
        }
    }

    protected abstract class SpliceInTask {
        final ChannelPromise promise;
        int len;
        final /* synthetic */ AbstractEpollStreamChannel this$0;

        /*
         * WARNING - void declaration
         */
        protected SpliceInTask(AbstractEpollStreamChannel this$0, int len, ChannelPromise promise) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            this.promise = var3_3;
            this.len = var2_2;
        }

        abstract boolean spliceIn(RecvByteBufAllocator.Handle var1);

        protected final int spliceIn(FileDescriptor pipeOut, RecvByteBufAllocator.Handle handle) throws IOException {
            int length = Math.min(handle.guess(), this.len);
            int splicedIn = 0;
            while (true) {
                int localSplicedIn = Native.splice(this.this$0.socket.intValue(), -1L, pipeOut.intValue(), -1L, length);
                handle.lastBytesRead(localSplicedIn);
                if (localSplicedIn == 0) break;
                splicedIn += localSplicedIn;
                length -= localSplicedIn;
            }
            return splicedIn;
        }
    }

    class EpollStreamUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        /*
         * WARNING - void declaration
         */
        EpollStreamUnsafe() {
            void var1_1;
        }

        protected Executor prepareToClose() {
            return super.prepareToClose();
        }

        /*
         * WARNING - void declaration
         */
        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, EpollRecvByteAllocatorHandle allocHandle) {
            void var3_3;
            void var1_1;
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    void var2_2;
                    var2_2.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            var1_1.fireExceptionCaught(cause);
            if (close || cause instanceof OutOfMemoryError || var3_3 instanceof IOException) {
                this.shutdownInput(false);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.ExtendedHandle handle) {
            void var1_1;
            return new EpollRecvByteAllocatorStreamingHandle((RecvByteBufAllocator.ExtendedHandle)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void epollInReady() {
            EpollChannelConfig config;
            block15: {
                config = AbstractEpollStreamChannel.this.config();
                if (AbstractEpollStreamChannel.this.shouldBreakEpollInReady((ChannelConfig)config)) {
                    this.clearEpollIn0();
                    return;
                }
                EpollRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
                allocHandle.edgeTriggered(AbstractEpollStreamChannel.this.isFlagSet(Native.EPOLLET));
                ChannelPipeline pipeline = AbstractEpollStreamChannel.this.pipeline();
                ByteBufAllocator allocator = config.getAllocator();
                allocHandle.reset((ChannelConfig)config);
                this.epollInBefore();
                ByteBuf byteBuf = null;
                boolean close = false;
                Queue sQueue = null;
                try {
                    do {
                        SpliceInTask spliceTask;
                        if ((sQueue != null || (sQueue = AbstractEpollStreamChannel.this.spliceQueue) != null) && (spliceTask = (SpliceInTask)sQueue.peek()) != null) {
                            boolean spliceInResult = spliceTask.spliceIn((RecvByteBufAllocator.Handle)allocHandle);
                            if (allocHandle.isReceivedRdHup()) {
                                this.shutdownInput(true);
                            }
                            if (!spliceInResult) break;
                            if (!AbstractEpollStreamChannel.this.isActive()) continue;
                            sQueue.remove();
                            continue;
                        }
                        byteBuf = allocHandle.allocate(allocator);
                        allocHandle.lastBytesRead(AbstractEpollStreamChannel.this.doReadBytes(byteBuf));
                        if (allocHandle.lastBytesRead() <= 0) {
                            byteBuf.release();
                            byteBuf = null;
                            close = allocHandle.lastBytesRead() < 0;
                            if (!close) break;
                            this.readPending = false;
                            break;
                        }
                        allocHandle.incMessagesRead(1);
                        this.readPending = false;
                        pipeline.fireChannelRead((Object)byteBuf);
                        byteBuf = null;
                        if (AbstractEpollStreamChannel.this.shouldBreakEpollInReady((ChannelConfig)config)) break;
                    } while (allocHandle.continueReading());
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (close) {
                        this.shutdownInput(false);
                    }
                    if (sQueue != null) break block15;
                }
                catch (Throwable t) {
                    block16: {
                        try {
                            void var2_2;
                            void var3_4;
                            this.handleReadException((ChannelPipeline)var3_4, byteBuf, t, close, (EpollRecvByteAllocatorHandle)var2_2);
                            if (sQueue != null) break block16;
                        }
                        catch (Throwable throwable) {
                            void var1_1;
                            if (sQueue == null) {
                                this.epollInFinally((ChannelConfig)config);
                            } else if (!var1_1.isAutoRead()) {
                                AbstractEpollStreamChannel.this.clearEpollIn();
                            }
                            throw throwable;
                        }
                        this.epollInFinally((ChannelConfig)config);
                        return;
                    }
                    if (!config.isAutoRead()) {
                        AbstractEpollStreamChannel.this.clearEpollIn();
                        return;
                    }
                }
                this.epollInFinally((ChannelConfig)config);
                return;
            }
            if (!config.isAutoRead()) {
                AbstractEpollStreamChannel.this.clearEpollIn();
                return;
            }
        }
    }
}

