/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollDomainSocketChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.TimeUnit;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    protected final LinuxSocket socket;
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;
    protected int flags = Native.EPOLLET;
    boolean inputClosedSeenErrorOnRead;
    boolean epollInReadyRunnablePending;
    protected volatile boolean active;

    /*
     * WARNING - void declaration
     */
    AbstractEpollChannel(LinuxSocket fd) {
        this(null, (LinuxSocket)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AbstractEpollChannel(Channel parent, LinuxSocket fd, boolean active) {
        super((Channel)var1_1);
        void var3_3;
        void var1_1;
        this.socket = (LinuxSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)fd), (String)"fd"));
        this.active = active;
        if (var3_3 != false) {
            void var2_2;
            this.local = fd.localAddress();
            this.remote = var2_2.remoteAddress();
        }
    }

    /*
     * WARNING - void declaration
     */
    AbstractEpollChannel(Channel parent, LinuxSocket fd, SocketAddress remote) {
        super((Channel)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.socket = (LinuxSocket)((Object)ObjectUtil.checkNotNull((Object)((Object)fd), (String)"fd"));
        this.active = true;
        this.remote = var3_3;
        this.local = var2_2.localAddress();
    }

    /*
     * WARNING - void declaration
     */
    static boolean isSoErrorZero(Socket fd) {
        try {
            return fd.getSoError() == 0;
        }
        catch (IOException e) {
            void var0_1;
            throw new ChannelException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setFlag(int flag) throws IOException {
        if (!this.isFlagSet(flag)) {
            void var1_1;
            this.flags |= var1_1;
            this.modifyEvents();
        }
    }

    /*
     * WARNING - void declaration
     */
    void clearFlag(int flag) throws IOException {
        if (this.isFlagSet(flag)) {
            void var1_1;
            this.flags &= ~var1_1;
            this.modifyEvents();
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isFlagSet(int flag) {
        void var1_1;
        return (this.flags & var1_1) != 0;
    }

    public final FileDescriptor fd() {
        return this.socket;
    }

    public abstract EpollChannelConfig config();

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - void declaration
     */
    protected void doClose() throws Exception {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        try {
            Future<?> future;
            ChannelPromise promise = this.connectPromise;
            if (promise != null) {
                promise.tryFailure((Throwable)new ClosedChannelException());
                this.connectPromise = null;
            }
            if ((future = this.connectTimeoutFuture) != null) {
                future.cancel(false);
                this.connectTimeoutFuture = null;
            }
            if (this.isRegistered()) {
                EventLoop loop = this.eventLoop();
                if (loop.inEventLoop()) {
                    this.doDeregister();
                } else {
                    void var1_1;
                    var1_1.execute(new Runnable(this){
                        final /* synthetic */ AbstractEpollChannel this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void run() {
                            try {
                                this.this$0.doDeregister();
                                return;
                            }
                            catch (Throwable cause) {
                                void var1_1;
                                this.this$0.pipeline().fireExceptionCaught((Throwable)var1_1);
                                return;
                            }
                        }
                    });
                }
            }
            return;
        }
        finally {
            this.socket.close();
        }
    }

    void resetCachedAddresses() {
        this.local = this.socket.localAddress();
        this.remote = this.socket.remoteAddress();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    public boolean isOpen() {
        return this.socket.isOpen();
    }

    protected void doDeregister() throws Exception {
        ((EpollEventLoop)this.eventLoop()).remove(this);
    }

    /*
     * WARNING - void declaration
     */
    protected final void doBeginRead() throws Exception {
        AbstractEpollUnsafe unsafe = (AbstractEpollUnsafe)this.unsafe();
        ((AbstractEpollUnsafe)this.unsafe()).readPending = true;
        this.setFlag(Native.EPOLLIN);
        if (unsafe.maybeMoreDataToRead) {
            void var1_1;
            var1_1.executeEpollInReadyRunnable((ChannelConfig)this.config());
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean shouldBreakEpollInReady(ChannelConfig config) {
        void var1_1;
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractEpollChannel.isAllowHalfClosure((ChannelConfig)var1_1));
    }

    private static boolean isAllowHalfClosure(ChannelConfig config) {
        ChannelConfig channelConfig;
        if (config instanceof EpollDomainSocketChannelConfig) {
            return ((EpollDomainSocketChannelConfig)config).isAllowHalfClosure();
        }
        return config instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void clearEpollIn() {
        void var2_2;
        void var1_1;
        if (!this.isRegistered()) {
            this.flags &= ~Native.EPOLLIN;
            return;
        }
        EventLoop loop = this.eventLoop();
        AbstractEpollUnsafe unsafe = (AbstractEpollUnsafe)this.unsafe();
        if (loop.inEventLoop()) {
            unsafe.clearEpollIn0();
            return;
        }
        var1_1.execute(new Runnable(this, (AbstractEpollUnsafe)var2_2){
            final /* synthetic */ AbstractEpollUnsafe val$unsafe;
            final /* synthetic */ AbstractEpollChannel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$unsafe = abstractEpollUnsafe;
            }

            @Override
            public void run() {
                if (!this.val$unsafe.readPending && !this.this$0.config().isAutoRead()) {
                    this.val$unsafe.clearEpollIn0();
                }
            }
        });
    }

    private void modifyEvents() throws IOException {
        if (this.isOpen() && this.isRegistered()) {
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    protected void doRegister() throws Exception {
        this.epollInReadyRunnablePending = false;
        ((EpollEventLoop)this.eventLoop()).add(this);
    }

    protected abstract AbstractEpollUnsafe newUnsafe();

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf newDirectBuffer(ByteBuf buf) {
        void var1_1;
        void v0 = var1_1;
        return this.newDirectBuffer(v0, (ByteBuf)v0);
    }

    /*
     * WARNING - void declaration
     */
    protected final ByteBuf newDirectBuffer(Object holder, ByteBuf buf) {
        void var1_1;
        void var3_3;
        void var2_2;
        int readableBytes = buf.readableBytes();
        if (readableBytes == 0) {
            ReferenceCountUtil.release((Object)holder);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator alloc = this.alloc();
        if (alloc.isDirectBufferPooled()) {
            return AbstractEpollChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        ByteBuf directBuf = ByteBufUtil.threadLocalDirectBuffer();
        if (directBuf == null) {
            return AbstractEpollChannel.newDirectBuffer0(holder, buf, alloc, readableBytes);
        }
        void v0 = var2_2;
        directBuf.writeBytes((ByteBuf)v0, v0.readerIndex(), (int)var3_3);
        ReferenceCountUtil.safeRelease((Object)var1_1);
        return directBuf;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf newDirectBuffer0(Object holder, ByteBuf buf, ByteBufAllocator alloc, int capacity) {
        void var2_2;
        Object object;
        void var3_3;
        void var1_1;
        ByteBuf directBuf = alloc.directBuffer(capacity);
        void v0 = var1_1;
        directBuf.writeBytes((ByteBuf)v0, v0.readerIndex(), (int)var3_3);
        ReferenceCountUtil.safeRelease((Object)object);
        return var2_2;
    }

    protected static void checkResolvable(InetSocketAddress addr) {
        if (addr.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final int doReadBytes(ByteBuf byteBuf) throws Exception {
        void var3_3;
        int localReadAmount;
        int writerIndex = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            localReadAmount = this.socket.recvAddress(byteBuf.memoryAddress(), writerIndex, byteBuf.capacity());
        } else {
            ByteBuffer buf;
            ByteBuffer byteBuffer = buf = byteBuf.internalNioBuffer(writerIndex, byteBuf.writableBytes());
            localReadAmount = this.socket.recv(byteBuffer, byteBuffer.position(), buf.limit());
        }
        if (localReadAmount > 0) {
            void var2_2;
            void var1_1;
            var1_1.writerIndex((int)(var2_2 + localReadAmount));
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected final int doWriteBytes(ChannelOutboundBuffer in, ByteBuf buf) throws Exception {
        if (buf.hasMemoryAddress()) {
            int localFlushedAmount = this.socket.sendAddress(buf.memoryAddress(), buf.readerIndex(), buf.writerIndex());
            if (localFlushedAmount > 0) {
                in.removeBytes((long)localFlushedAmount);
                return 1;
            }
        } else {
            ByteBuffer nioBuf;
            ByteBuffer byteBuffer;
            void localFlushedAmount;
            if (localFlushedAmount.nioBufferCount() == 1) {
                void v0 = localFlushedAmount;
                byteBuffer = v0.internalNioBuffer(v0.readerIndex(), localFlushedAmount.readableBytes());
            } else {
                byteBuffer = localFlushedAmount.nioBuffer();
            }
            ByteBuffer byteBuffer2 = nioBuf = byteBuffer;
            int localFlushedAmount2 = this.socket.send(byteBuffer2, byteBuffer2.position(), nioBuf.limit());
            if (localFlushedAmount2 > 0) {
                void var3_4;
                void var1_1;
                void var2_2;
                void v3 = var2_2;
                v3.position(v3.position() + localFlushedAmount2);
                var1_1.removeBytes((long)var3_4);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    final long doWriteOrSendBytes(ByteBuf data, InetSocketAddress remoteAddress, boolean fastOpen) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (!fastOpen || remoteAddress != null) : "fastOpen requires a remote address";
        if (data.hasMemoryAddress()) {
            long memoryAddress = data.memoryAddress();
            if (remoteAddress == null) {
                return this.socket.sendAddress(memoryAddress, data.readerIndex(), data.writerIndex());
            }
            return this.socket.sendToAddress(memoryAddress, data.readerIndex(), data.writerIndex(), remoteAddress.getAddress(), remoteAddress.getPort(), fastOpen);
        }
        if (data.nioBufferCount() > 1) {
            IovArray array = ((EpollEventLoop)this.eventLoop()).cleanIovArray();
            ByteBuf byteBuf = data;
            array.add(byteBuf, byteBuf.readerIndex(), data.readableBytes());
            int cnt = array.count();
            assert (cnt != 0);
            if (remoteAddress == null) {
                return this.socket.writevAddresses(array.memoryAddress(0), cnt);
            }
            return this.socket.sendToAddresses(array.memoryAddress(0), cnt, remoteAddress.getAddress(), remoteAddress.getPort(), fastOpen);
        }
        ByteBuf byteBuf = data;
        ByteBuffer nioData = byteBuf.internalNioBuffer(byteBuf.readerIndex(), var1_1.readableBytes());
        if (remoteAddress == null) {
            ByteBuffer byteBuffer = nioData;
            return this.socket.send(byteBuffer, byteBuffer.position(), nioData.limit());
        }
        ByteBuffer byteBuffer = nioData;
        return this.socket.sendTo(byteBuffer, byteBuffer.position(), nioData.limit(), remoteAddress.getAddress(), var2_2.getPort(), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void doBind(SocketAddress local) throws Exception {
        void var1_1;
        if (local instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)local);
        }
        this.socket.bind((SocketAddress)var1_1);
        this.local = this.socket.localAddress();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        void var2_3;
        boolean connected;
        InetSocketAddress remoteSocketAddr;
        if (localAddress instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)localAddress);
        }
        if ((remoteSocketAddr = remoteAddress instanceof InetSocketAddress ? (InetSocketAddress)remoteAddress : null) != null) {
            AbstractEpollChannel.checkResolvable(remoteSocketAddr);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (localAddress != null) {
            this.socket.bind(localAddress);
        }
        if (connected = this.doConnect0(remoteAddress)) {
            void var3_4;
            void var1_1;
            this.remote = remoteSocketAddr == null ? var1_1 : UnixChannelUtil.computeRemoteAddr((InetSocketAddress)var3_4, (InetSocketAddress)this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    boolean doConnect0(SocketAddress remote) throws Exception {
        boolean success = false;
        try {
            void var1_2;
            boolean connected = this.socket.connect(remote);
            if (!connected) {
                this.setFlag(Native.EPOLLOUT);
            }
            success = true;
            return (boolean)var1_2;
        }
        catch (Throwable throwable) {
            void var2_4;
            if (var2_4 == false) {
                this.doClose();
            }
            throw throwable;
        }
    }

    protected SocketAddress localAddress0() {
        return this.local;
    }

    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelPromise access$102(AbstractEpollChannel x0, ChannelPromise x1) {
        void var1_1;
        x0.connectPromise = var1_1;
        return x0.connectPromise;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$202(AbstractEpollChannel x0, SocketAddress x1) {
        void var1_1;
        x0.requestedRemoteAddress = var1_1;
        return x0.requestedRemoteAddress;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$302(AbstractEpollChannel x0, Future x1) {
        void var1_1;
        x0.connectTimeoutFuture = var1_1;
        return x0.connectTimeoutFuture;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SocketAddress access$402(AbstractEpollChannel x0, SocketAddress x1) {
        void var1_1;
        x0.remote = var1_1;
        return x0.remote;
    }

    protected abstract class AbstractEpollUnsafe
    extends AbstractChannel.AbstractUnsafe {
        boolean readPending;
        boolean maybeMoreDataToRead;
        private EpollRecvByteAllocatorHandle allocHandle;
        private final Runnable epollInReadyRunnable;

        /*
         * WARNING - void declaration
         */
        protected AbstractEpollUnsafe() {
            void var1_1;
            super((AbstractChannel)var1_1);
            this.epollInReadyRunnable = new Runnable(this){
                final /* synthetic */ AbstractEpollUnsafe this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public void run() {
                    this.this$1.AbstractEpollChannel.this.epollInReadyRunnablePending = false;
                    this.this$1.epollInReady();
                }
            };
        }

        abstract void epollInReady();

        final void epollInBefore() {
            this.maybeMoreDataToRead = false;
        }

        /*
         * WARNING - void declaration
         */
        final void epollInFinally(ChannelConfig config) {
            void var1_1;
            this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
            if (this.allocHandle.isReceivedRdHup() || this.readPending && this.maybeMoreDataToRead) {
                this.executeEpollInReadyRunnable(config);
                return;
            }
            if (!this.readPending && !var1_1.isAutoRead()) {
                AbstractEpollChannel.this.clearEpollIn();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void executeEpollInReadyRunnable(ChannelConfig config) {
            void var1_1;
            if (AbstractEpollChannel.this.epollInReadyRunnablePending || !AbstractEpollChannel.this.isActive() || AbstractEpollChannel.this.shouldBreakEpollInReady((ChannelConfig)var1_1)) {
                return;
            }
            AbstractEpollChannel.this.epollInReadyRunnablePending = true;
            AbstractEpollChannel.this.eventLoop().execute(this.epollInReadyRunnable);
        }

        final void epollRdHupReady() {
            this.recvBufAllocHandle().receivedRdHup();
            if (AbstractEpollChannel.this.isActive()) {
                this.epollInReady();
            } else {
                this.shutdownInput(true);
            }
            this.clearEpollRdHup();
        }

        /*
         * WARNING - void declaration
         */
        private void clearEpollRdHup() {
            try {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLRDHUP);
                return;
            }
            catch (IOException e) {
                void var1_1;
                AbstractEpollChannel.this.pipeline().fireExceptionCaught((Throwable)var1_1);
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        void shutdownInput(boolean rdHup) {
            void var1_1;
            if (!AbstractEpollChannel.this.socket.isInputShutdown()) {
                if (AbstractEpollChannel.isAllowHalfClosure((ChannelConfig)AbstractEpollChannel.this.config())) {
                    try {
                        AbstractEpollChannel.this.socket.shutdown(true, false);
                    }
                    catch (IOException iOException) {
                        this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                        return;
                    }
                    catch (NotYetConnectedException notYetConnectedException) {}
                    this.clearEpollIn0();
                    AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
                return;
            }
            if (var1_1 == false && !AbstractEpollChannel.this.inputClosedSeenErrorOnRead) {
                AbstractEpollChannel.this.inputClosedSeenErrorOnRead = true;
                AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fireEventAndClose(Object evt) {
            void var1_1;
            AbstractEpollChannel.this.pipeline().fireUserEventTriggered((Object)var1_1);
            AbstractEpollUnsafe abstractEpollUnsafe = this;
            abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
        }

        public EpollRecvByteAllocatorHandle recvBufAllocHandle() {
            if (this.allocHandle == null) {
                this.allocHandle = this.newEpollHandle((RecvByteBufAllocator.ExtendedHandle)super.recvBufAllocHandle());
            }
            return this.allocHandle;
        }

        /*
         * WARNING - void declaration
         */
        EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator.ExtendedHandle handle) {
            void var1_1;
            return new EpollRecvByteAllocatorHandle((RecvByteBufAllocator.ExtendedHandle)var1_1);
        }

        protected final void flush0() {
            if (!AbstractEpollChannel.this.isFlagSet(Native.EPOLLOUT)) {
                super.flush0();
            }
        }

        final void epollOutReady() {
            if (AbstractEpollChannel.this.connectPromise != null) {
                this.finishConnect();
                return;
            }
            if (!AbstractEpollChannel.this.socket.isOutputShutdown()) {
                super.flush0();
            }
        }

        /*
         * WARNING - void declaration
         */
        protected final void clearEpollIn0() {
            assert (AbstractEpollChannel.this.eventLoop().inEventLoop());
            try {
                this.readPending = false;
                AbstractEpollChannel.this.clearFlag(Native.EPOLLIN);
                return;
            }
            catch (IOException e) {
                void var1_1;
                AbstractEpollChannel.this.pipeline().fireExceptionCaught((Throwable)var1_1);
                AbstractEpollChannel.this.unsafe().close(AbstractEpollChannel.this.unsafe().voidPromise());
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (promise.isDone() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                if (AbstractEpollChannel.this.connectPromise != null) {
                    throw new ConnectionPendingException();
                }
                boolean wasActive = AbstractEpollChannel.this.isActive();
                if (!AbstractEpollChannel.this.doConnect(remoteAddress, localAddress)) {
                    AbstractEpollChannel.access$102(AbstractEpollChannel.this, promise);
                    AbstractEpollChannel.access$202(AbstractEpollChannel.this, remoteAddress);
                    int connectTimeoutMillis = AbstractEpollChannel.this.config().getConnectTimeoutMillis();
                    if (connectTimeoutMillis > 0) {
                        void var2_3;
                        AbstractEpollChannel.access$302(AbstractEpollChannel.this, (Future)AbstractEpollChannel.this.eventLoop().schedule(new Runnable(this, connectTimeoutMillis, remoteAddress){
                            final /* synthetic */ int val$connectTimeoutMillis;
                            final /* synthetic */ SocketAddress val$remoteAddress;
                            final /* synthetic */ AbstractEpollUnsafe this$1;
                            {
                                void var1_1;
                                this.this$1 = var1_1;
                                this.val$connectTimeoutMillis = n;
                                this.val$remoteAddress = socketAddress;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void run() {
                                void var1_1;
                                ChannelPromise connectPromise = this.this$1.AbstractEpollChannel.this.connectPromise;
                                if (connectPromise != null && !connectPromise.isDone() && var1_1.tryFailure((Throwable)new ConnectTimeoutException("connection timed out after " + this.val$connectTimeoutMillis + " ms: " + this.val$remoteAddress))) {
                                    this.this$1.close(this.this$1.voidPromise());
                                }
                            }
                        }, (long)var2_3, TimeUnit.MILLISECONDS));
                    }
                    promise.addListener((GenericFutureListener)new ChannelFutureListener(this){
                        final /* synthetic */ AbstractEpollUnsafe this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        public void operationComplete(ChannelFuture future) {
                            if (future.isCancelled()) {
                                if (this.this$1.AbstractEpollChannel.this.connectTimeoutFuture != null) {
                                    this.this$1.AbstractEpollChannel.this.connectTimeoutFuture.cancel(false);
                                }
                                AbstractEpollChannel.access$102(this.this$1.AbstractEpollChannel.this, null);
                                this.this$1.close(this.this$1.voidPromise());
                            }
                        }
                    });
                    return;
                }
                this.fulfillConnectPromise(promise, wasActive);
            }
            catch (Throwable t) {
                void var1_1;
                void var3_4;
                this.closeIfClosed();
                var3_4.tryFailure(this.annotateConnectException(t, (SocketAddress)var1_1));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            void var1_2;
            void var3_4;
            void var2_3;
            if (promise == null) {
                return;
            }
            AbstractEpollChannel.this.active = true;
            boolean active = AbstractEpollChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (var2_3 == false && var3_4 != false) {
                AbstractEpollChannel.this.pipeline().fireChannelActive();
            }
            if (var1_2 == false) {
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.close(abstractEpollUnsafe.voidPromise());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fulfillConnectPromise(ChannelPromise promise, Throwable cause) {
            void var2_2;
            void var1_1;
            if (promise == null) {
                return;
            }
            var1_1.tryFailure((Throwable)var2_2);
            this.closeIfClosed();
        }

        /*
         * WARNING - void declaration
         */
        private void finishConnect() {
            assert (AbstractEpollChannel.this.eventLoop().inEventLoop());
            try {
                boolean wasActive = AbstractEpollChannel.this.isActive();
                if (!this.doFinishConnect()) {
                    return;
                }
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.fulfillConnectPromise(abstractEpollUnsafe.AbstractEpollChannel.this.connectPromise, wasActive);
                return;
            }
            catch (Throwable t) {
                void var1_2;
                AbstractEpollUnsafe abstractEpollUnsafe = this;
                abstractEpollUnsafe.fulfillConnectPromise(abstractEpollUnsafe.AbstractEpollChannel.this.connectPromise, this.annotateConnectException((Throwable)var1_2, AbstractEpollChannel.this.requestedRemoteAddress));
                return;
            }
            finally {
                if (AbstractEpollChannel.this.connectTimeoutFuture != null) {
                    AbstractEpollChannel.this.connectTimeoutFuture.cancel(false);
                }
                AbstractEpollChannel.access$102(AbstractEpollChannel.this, null);
            }
        }

        private boolean doFinishConnect() throws Exception {
            if (AbstractEpollChannel.this.socket.finishConnect()) {
                AbstractEpollChannel.this.clearFlag(Native.EPOLLOUT);
                if (AbstractEpollChannel.this.requestedRemoteAddress instanceof InetSocketAddress) {
                    AbstractEpollChannel.access$402(AbstractEpollChannel.this, UnixChannelUtil.computeRemoteAddr((InetSocketAddress)((InetSocketAddress)AbstractEpollChannel.this.requestedRemoteAddress), (InetSocketAddress)AbstractEpollChannel.this.socket.remoteAddress()));
                }
                AbstractEpollChannel.access$202(AbstractEpollChannel.this, null);
                return true;
            }
            AbstractEpollChannel.this.setFlag(Native.EPOLLOUT);
            return false;
        }
    }
}

