/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Path Mappings")
public class PathMappings<E>
implements Iterable<MappedResource<E>>,
Dumpable {
    private static final Logger LOG = Log.getLogger(PathMappings.class);
    private final Set<MappedResource<E>> _mappings = new TreeSet<MappedResource>(Comparator.comparing(MappedResource::getPathSpec));
    private boolean _optimizedExact = true;
    private Trie<MappedResource<E>> _exactMap = new ArrayTernaryTrie(false);
    private boolean _optimizedPrefix = true;
    private Trie<MappedResource<E>> _prefixMap = new ArrayTernaryTrie(false);
    private boolean _optimizedSuffix = true;
    private Trie<MappedResource<E>> _suffixMap = new ArrayTernaryTrie(false);

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects((Appendable)out, (String)var2_2, (Object)this.toString(), (Object[])new Object[]{this._mappings});
    }

    @ManagedAttribute(value="mappings", readonly=true)
    public List<MappedResource<E>> getMappings() {
        return new ArrayList<MappedResource<E>>(this._mappings);
    }

    public int size() {
        return this._mappings.size();
    }

    public void reset() {
        this._mappings.clear();
        this._prefixMap.clear();
        this._suffixMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void removeIf(Predicate<MappedResource<E>> predicate) {
        void var1_1;
        this._mappings.removeIf((Predicate<MappedResource<E>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<MatchedResource<E>> getMatchedList(String path) {
        void var2_2;
        ArrayList<MatchedResource<E>> ret = new ArrayList<MatchedResource<E>>();
        for (MappedResource<E> mr : this._mappings) {
            MatchedPath matchedPath = mr.getPathSpec().matched(path);
            if (matchedPath == null) continue;
            ret.add(new MatchedResource<E>(mr.getResource(), mr.getPathSpec(), matchedPath));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public List<MappedResource<E>> getMatches(String path) {
        void var3_3;
        boolean isRootPath = "/".equals(path);
        ArrayList<MappedResource<E>> ret = new ArrayList<MappedResource<E>>();
        block4: for (MappedResource<E> mr : this._mappings) {
            switch (mr.getPathSpec().getGroup()) {
                case ROOT: {
                    if (!isRootPath) continue block4;
                    ret.add(mr);
                    continue block4;
                }
                case DEFAULT: {
                    if (!isRootPath && mr.getPathSpec().matched(path) == null) continue block4;
                    ret.add(mr);
                    continue block4;
                }
            }
            if (mr.getPathSpec().matched(path) == null) continue;
            ret.add(mr);
        }
        return var3_3;
    }

    public MatchedResource<E> getMatched(String path) {
        Object lastGroup = null;
        boolean skipRestOfGroup = false;
        for (MappedResource<E> mr : this._mappings) {
            PathSpecGroup pathSpecGroup;
            MatchedPath matchedPath;
            PathSpecGroup group = mr.getPathSpec().getGroup();
            if (group == lastGroup && skipRestOfGroup) continue;
            if (group != lastGroup) {
                skipRestOfGroup = false;
                switch (group) {
                    case EXACT: {
                        MappedResource candidate;
                        if (!this._optimizedExact) break;
                        int i = path.length();
                        while (i >= 0) {
                            if ((candidate = (MappedResource)this._exactMap.getBest(path, 0, i--)) == null || (matchedPath = candidate.getPathSpec().matched(path)) == null) continue;
                            return new MatchedResource(candidate.getResource(), candidate.getPathSpec(), matchedPath);
                        }
                        i = 1;
                        break;
                    }
                    case PREFIX_GLOB: {
                        MappedResource candidate;
                        if (!this._optimizedPrefix) break;
                        int i = path.length();
                        while (i >= 0) {
                            if ((candidate = (MappedResource)this._prefixMap.getBest(path, 0, i--)) == null || (matchedPath = candidate.getPathSpec().matched(path)) == null) continue;
                            return new MatchedResource(candidate.getResource(), candidate.getPathSpec(), matchedPath);
                        }
                        i = 1;
                        break;
                    }
                    case SUFFIX_GLOB: {
                        MappedResource candidate;
                        if (!this._optimizedSuffix) break;
                        int i = 0;
                        while ((i = path.indexOf(46, i + 1)) > 0) {
                            candidate = (MappedResource)this._suffixMap.get(path, i + 1, path.length() - i - 1);
                            if (candidate == null || (matchedPath = candidate.getPathSpec().matched(path)) == null) continue;
                            return new MatchedResource(candidate.getResource(), candidate.getPathSpec(), matchedPath);
                        }
                        boolean bl = true;
                    }
                }
            }
            if ((matchedPath = mr.getPathSpec().matched(path)) != null) {
                return new MatchedResource<E>(mr.getResource(), mr.getPathSpec(), (MatchedPath)((Object)pathSpecGroup));
            }
            pathSpecGroup = group;
        }
        return null;
    }

    @Deprecated
    public MappedResource<E> getMatch(String path) {
        throw new UnsupportedOperationException("Use .getMatched(String) instead");
    }

    @Override
    public Iterator<MappedResource<E>> iterator() {
        return this._mappings.iterator();
    }

    @Deprecated
    public static PathSpec asPathSpec(String pathSpecString) {
        return PathSpec.from(pathSpecString);
    }

    /*
     * WARNING - void declaration
     */
    public E get(PathSpec spec) {
        void var1_1;
        return this._mappings.stream().filter(arg_0 -> PathMappings.lambda$get$0((PathSpec)var1_1, arg_0)).map(MappedResource::getResource).findFirst().orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean put(String pathSpecString, E resource) {
        void var2_2;
        void var1_1;
        return this.put(PathSpec.from((String)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean put(PathSpec pathSpec, E resource) {
        void var3_3;
        MappedResource<E> entry = new MappedResource<E>(pathSpec, resource);
        boolean added = this._mappings.add(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} to {}", new Object[]{added ? "Added" : "Ignored", entry, this});
        }
        if (added) {
            switch (pathSpec.getGroup()) {
                case EXACT: {
                    String exact;
                    if (pathSpec instanceof ServletPathSpec) {
                        exact = pathSpec.getDeclaration();
                        while (exact != null && !this._exactMap.put(exact, entry)) {
                            this._exactMap = new ArrayTernaryTrie((ArrayTernaryTrie)this._exactMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedExact = false;
                    break;
                }
                case PREFIX_GLOB: {
                    String prefix;
                    String exact;
                    if (exact instanceof ServletPathSpec) {
                        prefix = exact.getPrefix();
                        while (prefix != null && !this._prefixMap.put(prefix, entry)) {
                            this._prefixMap = new ArrayTernaryTrie((ArrayTernaryTrie)this._prefixMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedPrefix = false;
                    break;
                }
                case SUFFIX_GLOB: {
                    String prefix;
                    if (prefix instanceof ServletPathSpec) {
                        String suffix = prefix.getSuffix();
                        while (suffix != null && !this._suffixMap.put(suffix, entry)) {
                            this._suffixMap = new ArrayTernaryTrie((ArrayTernaryTrie)this._prefixMap, 1.5);
                        }
                        break;
                    }
                    this._optimizedSuffix = false;
                }
            }
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(PathSpec pathSpec) {
        void var3_3;
        Iterator<MappedResource<E>> iter = this._mappings.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            void var2_2;
            if (!iter.next().getPathSpec().equals(pathSpec)) continue;
            removed = true;
            var2_2.remove();
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} to {}", new Object[]{removed ? "Removed" : "Ignored", pathSpec, this});
        }
        if (removed) {
            switch (pathSpec.getGroup()) {
                case EXACT: {
                    String exact = pathSpec.getDeclaration();
                    if (exact == null) break;
                    this._exactMap.remove(exact);
                    this._optimizedExact = this.canBeOptimized(PathSpecGroup.EXACT);
                    break;
                }
                case PREFIX_GLOB: {
                    String exact;
                    String prefix = exact.getPrefix();
                    if (prefix == null) break;
                    this._prefixMap.remove(prefix);
                    this._optimizedPrefix = this.canBeOptimized(PathSpecGroup.PREFIX_GLOB);
                    break;
                }
                case SUFFIX_GLOB: {
                    void var1_1;
                    String prefix;
                    String suffix = prefix.getSuffix();
                    if (suffix == null) break;
                    this._suffixMap.remove((String)var1_1);
                    this._optimizedSuffix = this.canBeOptimized(PathSpecGroup.SUFFIX_GLOB);
                }
            }
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean canBeOptimized(PathSpecGroup suffixGlob) {
        void var1_1;
        return this._mappings.stream().filter(arg_0 -> PathMappings.lambda$canBeOptimized$1((PathSpecGroup)var1_1, arg_0)).allMatch(mapping -> mapping.getPathSpec() instanceof ServletPathSpec);
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this._mappings.size());
    }

    private static /* synthetic */ boolean lambda$canBeOptimized$1(PathSpecGroup suffixGlob, MappedResource mapping) {
        PathSpecGroup pathSpecGroup;
        return mapping.getPathSpec().getGroup() == pathSpecGroup;
    }

    private static /* synthetic */ boolean lambda$get$0(PathSpec spec, MappedResource mappedResource) {
        PathSpec pathSpec;
        return mappedResource.getPathSpec().equals(pathSpec);
    }
}

