/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.compression;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.compression.HuffmanEncoder;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;

public class NBitStringEncoder {
    private NBitStringEncoder() {
    }

    /*
     * WARNING - void declaration
     */
    public static int octetsNeeded(int prefix, String value, boolean huffman) {
        int n;
        void var1_2;
        void var3_4;
        int n2;
        if (prefix <= 0 || prefix > 8) {
            throw new IllegalArgumentException();
        }
        int contentPrefix = prefix == 1 ? 8 : prefix - 1;
        int encodedValueSize = n2 != 0 ? HuffmanEncoder.octetsNeeded(value) : value.length();
        n2 = NBitIntegerEncoder.octetsNeeded((int)var3_4, encodedValueSize);
        return n2 + var1_2 + (n == 1 ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void encode(ByteBuffer buffer, int prefix, String value, boolean huffman2) {
        int encodedValueSize;
        byte huffmanFlag;
        if (prefix <= 0 || prefix > 8) {
            throw new IllegalArgumentException();
        }
        byte by = huffmanFlag = huffman2 ? (byte)(1 << prefix - 1) : (byte)0;
        if (prefix == 8) {
            buffer.put(huffmanFlag);
        } else {
            int p = buffer.position() - 1;
            buffer.put(p, (byte)(buffer.get(p) | huffmanFlag));
        }
        int n = prefix = prefix == 1 ? 8 : prefix - 1;
        if (huffman2) {
            encodedValueSize = HuffmanEncoder.octetsNeeded(value);
            NBitIntegerEncoder.encode(buffer, prefix, encodedValueSize);
            HuffmanEncoder.encode(buffer, value);
            return;
        }
        encodedValueSize = value.length();
        NBitIntegerEncoder.encode(buffer, prefix, encodedValueSize);
        for (int i = 0; i < encodedValueSize; ++i) {
            void var3_4;
            char c = value.charAt(i);
            c = HttpTokens.sanitizeFieldVchar(c);
            buffer.put((byte)var3_4);
        }
    }
}

