/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.compression;

import java.nio.ByteBuffer;

public class NBitIntegerEncoder {
    private NBitIntegerEncoder() {
    }

    /*
     * WARNING - void declaration
     */
    public static int octetsNeeded(int prefix, long value) {
        int n;
        void var1_1;
        if (prefix <= 0 || prefix > 8) {
            throw new IllegalArgumentException();
        }
        int nbits = 255 >>> 8 - prefix;
        if ((value -= (long)nbits) < 0L) {
            return 1;
        }
        if (value == 0L) {
            return 2;
        }
        int lz = Long.numberOfLeadingZeros((long)var1_1);
        int log = 64 - lz;
        return 1 + (n + 6) / 7;
    }

    /*
     * WARNING - void declaration
     */
    public static void encode(ByteBuffer buffer, int prefix, long value) {
        void var1_1;
        void var2_2;
        if (prefix <= 0 || prefix > 8) {
            throw new IllegalArgumentException();
        }
        if (prefix == 8) {
            buffer.put((byte)0);
        }
        int bits = 255 >>> 8 - prefix;
        int p = buffer.position() - 1;
        if (value < (long)bits) {
            buffer.put(p, (byte)((long)(buffer.get(p) & ~bits) | value));
            return;
        }
        buffer.put(p, (byte)(buffer.get(p) | bits));
        void length = var2_2 - (long)var1_1;
        while (true) {
            if ((length & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.put((byte)length);
                return;
            }
            buffer.put((byte)(length & 0x7FL | 0x80L));
            length >>>= 7;
        }
    }
}

