/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.compression;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.compression.Huffman;

public class HuffmanEncoder {
    private HuffmanEncoder() {
    }

    public static int octetsNeeded(String s) {
        String string;
        return HuffmanEncoder.octetsNeeded(Huffman.CODES, string);
    }

    /*
     * WARNING - void declaration
     */
    public static int octetsNeeded(byte[] b) {
        void var1_1;
        byte[] byArray;
        int needed = 0;
        for (byte value : byArray) {
            int c = 0xFF & value;
            needed += Huffman.CODES[c][1];
        }
        return (int)((var1_1 + 7) / 8);
    }

    /*
     * WARNING - void declaration
     */
    public static void encode(ByteBuffer buffer, String s) {
        void var1_1;
        ByteBuffer byteBuffer;
        HuffmanEncoder.encode(Huffman.CODES, byteBuffer, (String)var1_1);
    }

    public static int octetsNeededLowerCase(String s) {
        String string;
        return HuffmanEncoder.octetsNeeded(Huffman.LCCODES, string);
    }

    /*
     * WARNING - void declaration
     */
    public static void encodeLowerCase(ByteBuffer buffer, String s) {
        void var1_1;
        ByteBuffer byteBuffer;
        HuffmanEncoder.encode(Huffman.LCCODES, byteBuffer, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int octetsNeeded(int[][] table, String s) {
        void var2_2;
        int needed = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (HttpTokens.isIllegalFieldVchar(c)) {
                return -1;
            }
            needed += table[c][1];
        }
        return (int)((var2_2 + 7) / 8);
    }

    /*
     * WARNING - void declaration
     */
    private static void encode(int[][] table, ByteBuffer buffer, String s) {
        long current = 0L;
        int n = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (HttpTokens.isIllegalFieldVchar(c)) {
                throw new IllegalArgumentException();
            }
            int code = table[c][0];
            int bits = table[c][1];
            current <<= bits;
            current |= (long)code;
            n += bits;
            while (n >= 8) {
                buffer.put((byte)(current >> (n -= 8)));
            }
        }
        if (n > 0) {
            void var3_3;
            void var1_1;
            current <<= 8 - n;
            current |= (long)(255 >>> n);
            var1_1.put((byte)var3_3);
        }
    }
}

