/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PrecompressedHttpContent;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceHttpContent
implements HttpContent {
    final Resource _resource;
    final String _contentType;
    final int _maxBuffer;
    Map<CompressedContentFormat, HttpContent> _precompressedContents;
    String _etag;

    /*
     * WARNING - void declaration
     */
    public ResourceHttpContent(Resource resource, String contentType) {
        this((Resource)var1_1, (String)var2_2, -1, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ResourceHttpContent(Resource resource, String contentType, int maxBuffer) {
        this((Resource)var1_1, (String)var2_2, (int)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ResourceHttpContent(Resource resource, String contentType, int maxBuffer, Map<CompressedContentFormat, HttpContent> precompressedContents) {
        void var3_3;
        Iterator<Map.Entry<CompressedContentFormat, HttpContent>> iterator;
        this._resource = iterator;
        this._contentType = contentType;
        this._maxBuffer = var3_3;
        if (precompressedContents == null) {
            this._precompressedContents = null;
            return;
        }
        this._precompressedContents = new HashMap<CompressedContentFormat, HttpContent>(precompressedContents.size());
        for (Map.Entry<CompressedContentFormat, HttpContent> entry : precompressedContents.entrySet()) {
            void var2_2;
            this._precompressedContents.put(entry.getKey(), new PrecompressedHttpContent(this, entry.getValue(), (CompressedContentFormat)var2_2.getKey()));
        }
    }

    @Override
    public String getContentTypeValue() {
        return this._contentType;
    }

    @Override
    public HttpField getContentType() {
        if (this._contentType == null) {
            return null;
        }
        return new HttpField(HttpHeader.CONTENT_TYPE, this._contentType);
    }

    @Override
    public HttpField getContentEncoding() {
        return null;
    }

    @Override
    public String getContentEncodingValue() {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        if (this._contentType == null) {
            return null;
        }
        return MimeTypes.getCharsetFromContentType(this._contentType);
    }

    @Override
    public MimeTypes.Type getMimeType() {
        if (this._contentType == null) {
            return null;
        }
        return (MimeTypes.Type)((Object)MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset(this._contentType)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpField getLastModified() {
        long lm = this._resource.lastModified();
        if (lm >= 0L) {
            void var1_1;
            return new HttpField(HttpHeader.LAST_MODIFIED, DateGenerator.formatDate((long)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getLastModifiedValue() {
        long lm = this._resource.lastModified();
        if (lm >= 0L) {
            void var1_1;
            return DateGenerator.formatDate((long)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer getDirectBuffer() {
        if (this._resource.length() <= 0L || this._maxBuffer > 0 && this._resource.length() > (long)this._maxBuffer) {
            return null;
        }
        try {
            return BufferUtil.toBuffer((Resource)this._resource, (boolean)true);
        }
        catch (IOException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    @Override
    public HttpField getETag() {
        return new HttpField(HttpHeader.ETAG, this.getETagValue());
    }

    @Override
    public String getETagValue() {
        return this._resource.getWeakETag();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer getIndirectBuffer() {
        if (this._resource.length() <= 0L || this._maxBuffer > 0 && this._resource.length() > (long)this._maxBuffer) {
            return null;
        }
        try {
            return BufferUtil.toBuffer((Resource)this._resource, (boolean)false);
        }
        catch (IOException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpField getContentLength() {
        void var1_1;
        long l = this._resource.length();
        if (l == -1L) {
            return null;
        }
        return new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, (long)var1_1);
    }

    @Override
    public long getContentLengthValue() {
        return this._resource.length();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._resource.getInputStream();
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return this._resource.getReadableByteChannel();
    }

    @Override
    public Resource getResource() {
        return this._resource;
    }

    @Override
    public void release() {
        this._resource.close();
    }

    public String toString() {
        return String.format("%s@%x{r=%s,ct=%s,c=%b}", this.getClass().getSimpleName(), this.hashCode(), this._resource, this._contentType, this._precompressedContents != null);
    }

    public Map<CompressedContentFormat, HttpContent> getPrecompressedContents() {
        return this._precompressedContents;
    }
}

