/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.log.Log;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    public static ToIntFunction<String> MOST_SPECIFIC_MIME_ORDERING = s -> {
        String string;
        if ("*/*".equals(s)) {
            return 0;
        }
        if (s.endsWith("/*")) {
            return 1;
        }
        if (string.indexOf(59) < 0) {
            return 2;
        }
        return 3;
    };
    private final List<QualityValue> _qualities = new ArrayList<QualityValue>();
    private QualityValue _lastQuality;
    private boolean _sorted = false;
    private final ToIntFunction<String> _secondaryOrdering;

    public QuotedQualityCSV() {
        this((ToIntFunction<String>)null);
    }

    /*
     * WARNING - void declaration
     */
    public QuotedQualityCSV(String[] preferredOrder) {
        this(arg_0 -> QuotedQualityCSV.lambda$new$1((String[])var1_1, arg_0));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public QuotedQualityCSV(ToIntFunction<String> secondaryOrdering) {
        super(new String[0]);
        void var1_1;
        this._secondaryOrdering = secondaryOrdering == null ? s -> 0 : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void parsedValueAndParams(StringBuffer buffer) {
        void var1_1;
        super.parsedValueAndParams(buffer);
        QuotedQualityCSV quotedQualityCSV = this;
        this._lastQuality = quotedQualityCSV.new QualityValue(quotedQualityCSV._lastQuality._quality, var1_1.toString(), this._lastQuality._index);
        this._qualities.set(this._lastQuality._index, this._lastQuality);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void parsedValue(StringBuffer buffer) {
        void var1_1;
        super.parsedValue(buffer);
        this._sorted = false;
        this._lastQuality = new QualityValue(1.0, var1_1.toString(), this._qualities.size());
        this._qualities.add(this._lastQuality);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
        this._sorted = false;
        if (paramName < 0) {
            StringBuffer stringBuffer = buffer;
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
                StringBuffer stringBuffer2 = buffer;
                stringBuffer2.setLength(stringBuffer2.length() - 1);
                return;
            }
        } else if (paramValue >= 0 && buffer.charAt(paramName) == 'q' && paramValue > paramName && buffer.length() >= paramName && buffer.charAt(paramName + 1) == '=') {
            void var3_4;
            double q;
            try {
                q = this._keepQuotes && buffer.charAt(paramValue) == '\"' ? Double.valueOf(buffer.substring(paramValue + 1, buffer.length() - 1)) : Double.valueOf(buffer.substring(paramValue));
            }
            catch (Exception e) {
                void var2_3;
                Log.getLogger(QuotedQualityCSV.class).ignore((Throwable)var2_3);
                q = 0.0;
            }
            buffer.setLength(Math.max(0, (int)(var3_4 - true)));
            if (q != 1.0) {
                void var1_1;
                this._lastQuality = new QualityValue(q, var1_1.toString(), this._lastQuality._index);
                this._qualities.set(this._lastQuality._index, this._lastQuality);
            }
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._values.clear();
        this._qualities.stream().filter(qv -> ((QualityValue)qv)._quality != 0.0).sorted().map(rec$ -> ((QualityValue)rec$).getValue()).collect(Collectors.toCollection(() -> this._values));
        this._sorted = true;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$new$1(String[] preferredOrder, String s) {
        void var1_1;
        for (int i = 0; i < preferredOrder.length; ++i) {
            if (!preferredOrder[i].equals(s)) continue;
            return preferredOrder.length - i;
        }
        if ("*".equals(var1_1)) {
            String[] stringArray;
            return stringArray.length;
        }
        return 0;
    }

    private class QualityValue
    implements Comparable<QualityValue> {
        private final double _quality;
        private final String _value;
        private final int _index;

        /*
         * WARNING - void declaration
         */
        private QualityValue(double quality, String value, int index) {
            void var2_2;
            this._quality = var2_2;
            this._value = value;
            this._index = index;
        }

        public int hashCode() {
            return Double.hashCode(this._quality) ^ Objects.hash(this._value, this._index);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            if (!(obj instanceof QualityValue)) {
                return false;
            }
            QualityValue qv = (QualityValue)obj;
            return this._quality == qv._quality && Objects.equals(this._value, qv._value) && Objects.equals(this._index, var1_1._index);
        }

        private String getValue() {
            return this._value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(QualityValue o) {
            void var2_2;
            int compare = Double.compare(o._quality, this._quality);
            if (compare == 0 && (compare = Integer.compare(QuotedQualityCSV.this._secondaryOrdering.applyAsInt(o._value), QuotedQualityCSV.this._secondaryOrdering.applyAsInt(this._value))) == 0) {
                void var1_1;
                compare = -Integer.compare(var1_1._index, this._index);
            }
            return (int)var2_2;
        }

        public String toString() {
            return String.format("%s@%x[%s,q=%f,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this._value, this._quality, this._index);
        }
    }
}

