/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartParser;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartFormInputStream {
    private static final Logger LOG = Log.getLogger(MultiPartFormInputStream.class);
    private static final int DEFAULT_MAX_FORM_KEYS = 1000;
    private static final MultiMap<Part> EMPTY_MAP = new MultiMap(Collections.emptyMap());
    private final EnumSet<NonCompliance> _nonComplianceWarnings = EnumSet.noneOf(NonCompliance.class);
    private final MultiMap<Part> _parts;
    private final int _maxParts;
    private int _numParts = 0;
    private InputStream _in;
    private MultipartConfigElement _config;
    private String _contentType;
    private Throwable _err;
    private File _tmpDir;
    private File _contextTmpDir;
    private boolean _writeFilesWithFilenames;
    private boolean _parsed;
    private int _bufferSize = 16384;

    public EnumSet<NonCompliance> getNonComplianceWarnings() {
        return this._nonComplianceWarnings;
    }

    /*
     * WARNING - void declaration
     */
    public MultiPartFormInputStream(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir) {
        this((InputStream)var1_1, (String)var2_2, (MultipartConfigElement)var3_3, contextTmpDir, 1000);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MultiPartFormInputStream(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, int maxParts) {
        void var2_2;
        void var3_3;
        this._contentType = contentType;
        this._config = var3_3;
        this._contextTmpDir = contextTmpDir;
        this._maxParts = maxParts;
        if (this._contextTmpDir == null) {
            this._contextTmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (this._config == null) {
            this._config = new MultipartConfigElement(this._contextTmpDir.getAbsolutePath());
        }
        MultiMap<Part> parts = new MultiMap<Part>();
        if (in instanceof ServletInputStream && ((ServletInputStream)in).isFinished()) {
            parts = EMPTY_MAP;
            this._parsed = true;
        }
        if (!this._parsed) {
            void var1_1;
            this._in = new BufferedInputStream((InputStream)var1_1);
        }
        this._parts = var2_2;
    }

    public boolean isEmpty() {
        if (this._parts == null) {
            return true;
        }
        Object object = this._parts.values();
        object = object.iterator();
        while (object.hasNext()) {
            List list = (List)object.next();
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Collection<Part> getParsedParts() {
        void var2_2;
        Iterator iterator;
        if (this._parts == null) {
            return Collections.emptyList();
        }
        Collection values = this._parts.values();
        ArrayList parts = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            List asList = LazyList.getList((Object)list, (boolean)false);
            parts.addAll(list);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteParts() {
        MultiException err = null;
        for (Object object : this._parts.values()) {
            object = object.iterator();
            while (object.hasNext()) {
                Part p = (Part)object.next();
                try {
                    ((MultiPart)p).cleanUp();
                }
                catch (Exception e) {
                    if (err == null) {
                        err = new MultiException();
                    }
                    err.add((Throwable)e);
                }
            }
        }
        this._parts.clear();
        if (err != null) {
            void var1_1;
            var1_1.ifExceptionThrowRuntime();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Part> getParts() throws IOException {
        void var2_2;
        Iterator iterator;
        if (!this._parsed) {
            this.parse();
        }
        this.throwIfError();
        if (this._parts.isEmpty()) {
            return Collections.emptyList();
        }
        Collection values = this._parts.values();
        ArrayList parts = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            List asList = LazyList.getList((Object)list, (boolean)false);
            parts.addAll(list);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Part getPart(String name) throws IOException {
        void var1_1;
        if (!this._parsed) {
            this.parse();
        }
        this.throwIfError();
        return (Part)this._parts.getValue((String)var1_1, 0);
    }

    protected void throwIfError() throws IOException {
        if (this._err != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("MultiPart parsing failure ", this._err);
            }
            this._err.addSuppressed(new Throwable());
            if (this._err instanceof IOException) {
                throw (IOException)this._err;
            }
            if (this._err instanceof IllegalStateException) {
                throw (IllegalStateException)this._err;
            }
            throw new IllegalStateException(this._err);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void parse() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        MultiPartParser parser = null;
        Handler handler = new Handler(this);
        try {
            block14: {
                String bend22;
                File f;
                if (this._contentType == null || !this._contentType.startsWith("multipart/form-data")) {
                    return;
                }
                this._tmpDir = this._config.getLocation() == null ? this._contextTmpDir : ("".equals(this._config.getLocation()) ? this._contextTmpDir : ((f = new File(this._config.getLocation())).isAbsolute() ? f : new File(this._contextTmpDir, this._config.getLocation())));
                if (!this._tmpDir.exists()) {
                    this._tmpDir.mkdirs();
                }
                String contentTypeBoundary = "";
                int bstart = this._contentType.indexOf("boundary=");
                if (bstart >= 0) {
                    int bend22 = this._contentType.indexOf(";", bstart);
                    bend22 = bend22 < 0 ? this._contentType.length() : bend22;
                    bend22 = QuotedStringTokenizer.unquote((String)MultiPartFormInputStream.value(this._contentType.substring(bstart, bend22)).trim());
                }
                parser = new MultiPartParser(handler, bend22);
                byte[] data = new byte[this._bufferSize];
                long total = 0L;
                while (true) {
                    void var2_3;
                    int len;
                    if ((len = this._in.read(data)) > 0) {
                        if (this._config.getMaxRequestSize() > 0L && (total += (long)len) > this._config.getMaxRequestSize()) {
                            this._err = new IllegalStateException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                            return;
                        }
                        ByteBuffer buffer = BufferUtil.toBuffer((byte[])data);
                        buffer.limit(len);
                        if (!parser.parse(buffer, false)) {
                            if (!buffer.hasRemaining()) continue;
                            throw new IllegalStateException("Buffer did not fully consume");
                        }
                        break block14;
                    }
                    if (var2_3 == -1) break;
                }
                parser.parse(BufferUtil.EMPTY_BUFFER, true);
            }
            if (this._err != null) {
                return;
            }
            if (parser.getState() != MultiPartParser.State.END) {
                this._err = parser.getState() == MultiPartParser.State.PREAMBLE ? new IOException("Missing initial multi part boundary") : new IOException("Incomplete Multipart");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsing Complete {} err={}", new Object[]{parser, this._err});
            }
            return;
        }
        catch (Throwable e) {
            void var3_6;
            this._err = var3_6;
            if (parser != null) {
                void var1_1;
                var1_1.parse(BufferUtil.EMPTY_BUFFER, true);
            }
            return;
        }
    }

    @Deprecated
    public void setDeleteOnExit(boolean deleteOnExit) {
    }

    /*
     * WARNING - void declaration
     */
    public void setWriteFilesWithFilenames(boolean writeFilesWithFilenames) {
        void var1_1;
        this._writeFilesWithFilenames = var1_1;
    }

    public boolean isWriteFilesWithFilenames() {
        return this._writeFilesWithFilenames;
    }

    @Deprecated
    public boolean isDeleteOnExit() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static String value(String nameEqualsValue) {
        void var1_1;
        String string;
        int idx = nameEqualsValue.indexOf(61);
        string = string.substring((int)(var1_1 + true)).trim();
        return QuotedStringTokenizer.unquoteOnly((String)string);
    }

    /*
     * WARNING - void declaration
     */
    private static String filenameValue(String nameEqualsValue) {
        String string;
        int idx = nameEqualsValue.indexOf(61);
        String value = nameEqualsValue.substring(idx + 1).trim();
        if (value.matches(".??[a-z,A-Z]\\:\\\\[^\\\\].*")) {
            void var1_1;
            char first = value.charAt(0);
            if (first == '\"' || first == '\'') {
                value = value.substring(1);
            }
            String string2 = value;
            char last = string2.charAt(string2.length() - 1);
            if (last == '\"' || var1_1 == 39) {
                value = value.substring(0, value.length() - 1);
            }
            return value;
        }
        return QuotedStringTokenizer.unquoteOnly((String)string, (boolean)true);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setBufferSize(int bufferSize) {
        void var1_1;
        this._bufferSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Throwable access$702(MultiPartFormInputStream x0, Throwable x1) {
        void var1_1;
        x0._err = var1_1;
        return x0._err;
    }

    class Handler
    implements MultiPartParser.Handler {
        private MultiPart _part = null;
        private String contentDisposition = null;
        private String contentType = null;
        private MultiMap<String> headers = new MultiMap();
        final /* synthetic */ MultiPartFormInputStream this$0;

        /*
         * WARNING - void declaration
         */
        Handler(MultiPartFormInputStream this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public boolean messageComplete() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void parsedField(String key, String value) {
            void var2_2;
            void var1_1;
            this.headers.put(StringUtil.asciiToLowerCase((String)key), (Object)value);
            if (key.equalsIgnoreCase("content-disposition")) {
                this.contentDisposition = value;
            } else if (key.equalsIgnoreCase("content-type")) {
                this.contentType = value;
            }
            if (var1_1.equalsIgnoreCase("content-transfer-encoding") && !"8bit".equalsIgnoreCase(value) && !"binary".equalsIgnoreCase((String)var2_2)) {
                this.this$0._nonComplianceWarnings.add(NonCompliance.TRANSFER_ENCODING);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean headerComplete() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("headerComplete {}", new Object[]{this});
            }
            try {
                void var3_4;
                boolean formData = false;
                if (this.contentDisposition == null) {
                    throw new IOException("Missing content-disposition");
                }
                QuotedStringTokenizer tok = new QuotedStringTokenizer(this.contentDisposition, ";", false, true);
                String name = null;
                String filename = null;
                while (tok.hasMoreTokens()) {
                    String t = tok.nextToken().trim();
                    String tl = StringUtil.asciiToLowerCase((String)t);
                    if (tl.startsWith("form-data")) {
                        formData = true;
                        continue;
                    }
                    if (tl.startsWith("name=")) {
                        name = MultiPartFormInputStream.value(t);
                        continue;
                    }
                    if (!tl.startsWith("filename=")) continue;
                    filename = MultiPartFormInputStream.filenameValue(t);
                }
                if (!formData) {
                    throw new IOException("Part not form-data");
                }
                if (name == null) {
                    throw new IOException("No name in part");
                }
                this._part = new MultiPart(this.this$0, name, filename);
                this._part.setHeaders(this.headers);
                this._part.setContentType(this.contentType);
                this.this$0._parts.add((String)var3_4, (Object)this._part);
                try {
                    this._part.open();
                }
                catch (IOException e) {
                    MultiPartFormInputStream.access$702(this.this$0, e);
                    return true;
                }
            }
            catch (Exception e) {
                void var1_2;
                MultiPartFormInputStream.access$702(this.this$0, (Throwable)var1_2);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean content(ByteBuffer buffer, boolean last) {
            void var2_4;
            if (this._part == null) {
                return false;
            }
            if (BufferUtil.hasContent((ByteBuffer)buffer)) {
                try {
                    this._part.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                }
                catch (IOException e) {
                    MultiPartFormInputStream.access$702(this.this$0, e);
                    return true;
                }
            }
            if (var2_4 != false) {
                try {
                    this._part.close();
                }
                catch (IOException e) {
                    void var1_3;
                    MultiPartFormInputStream.access$702(this.this$0, (Throwable)var1_3);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void startPart() {
            this.reset();
            this.this$0._numParts++;
            if (this.this$0._maxParts >= 0 && this.this$0._numParts > this.this$0._maxParts) {
                throw new IllegalStateException(String.format("Form with too many parts [%d > %d]", this.this$0._numParts, this.this$0._maxParts));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void earlyEOF() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Early EOF {}", new Object[]{this.this$0});
            }
            try {
                if (this._part != null) {
                    this._part.close();
                }
                return;
            }
            catch (IOException e) {
                void var1_1;
                LOG.warn("part could not be closed", (Throwable)var1_1);
                return;
            }
        }

        public void reset() {
            this._part = null;
            this.contentDisposition = null;
            this.contentType = null;
            this.headers = new MultiMap();
        }
    }

    public class MultiPart
    implements Part {
        protected String _name;
        protected String _filename;
        protected File _file;
        protected OutputStream _out;
        protected ByteArrayOutputStream2 _bout;
        protected String _contentType;
        protected MultiMap<String> _headers;
        protected long _size = 0L;
        protected boolean _temporary = true;
        final /* synthetic */ MultiPartFormInputStream this$0;

        /*
         * WARNING - void declaration
         */
        public MultiPart(MultiPartFormInputStream this$0, String name, String filename) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this._name = var2_2;
            this._filename = var3_3;
        }

        public String toString() {
            return String.format("Part{n=%s,fn=%s,ct=%s,s=%d,tmp=%b,file=%s}", this._name, this._filename, this._contentType, this._size, this._temporary, this._file);
        }

        /*
         * WARNING - void declaration
         */
        protected void setContentType(String contentType) {
            void var1_1;
            this._contentType = var1_1;
        }

        protected void open() throws IOException {
            if (this.this$0.isWriteFilesWithFilenames() && this._filename != null && !this._filename.trim().isEmpty()) {
                this.createFile();
                return;
            }
            this._bout = new ByteArrayOutputStream2();
            this._out = this._bout;
        }

        protected void close() throws IOException {
            this._out.close();
        }

        /*
         * WARNING - void declaration
         */
        protected void write(int b) throws IOException {
            void var1_1;
            if (this.this$0._config.getMaxFileSize() > 0L && this._size + 1L > this.this$0._config.getMaxFileSize()) {
                throw new IllegalStateException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (this.this$0._config.getFileSizeThreshold() > 0 && this._size + 1L > (long)this.this$0._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write((int)var1_1);
            ++this._size;
        }

        /*
         * WARNING - void declaration
         */
        protected void write(byte[] bytes, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.this$0._config.getMaxFileSize() > 0L && this._size + (long)length > this.this$0._config.getMaxFileSize()) {
                throw new IllegalStateException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (this.this$0._config.getFileSizeThreshold() > 0 && this._size + (long)length > (long)this.this$0._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write((byte[])var1_1, (int)var2_2, length);
            this._size += (long)var3_3;
        }

        protected void createFile() throws IOException {
            Path path = this.this$0._tmpDir.toPath();
            Path tempFile = Files.createTempFile(path, "MultiPart", "", new FileAttribute[0]);
            this._file = tempFile.toFile();
            OutputStream fos = Files.newOutputStream(tempFile, StandardOpenOption.WRITE);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            if (this._size > 0L && this._out != null) {
                this._out.flush();
                this._bout.writeTo((OutputStream)bos);
                this._out.close();
            }
            this._bout = null;
            this._out = path;
        }

        /*
         * WARNING - void declaration
         */
        protected void setHeaders(MultiMap<String> headers) {
            void var1_1;
            this._headers = var1_1;
        }

        public String getContentType() {
            return this._contentType;
        }

        /*
         * WARNING - void declaration
         */
        public String getHeader(String name) {
            void var1_1;
            if (name == null) {
                return null;
            }
            return (String)this._headers.getValue(StringUtil.asciiToLowerCase((String)var1_1), 0);
        }

        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        /*
         * WARNING - void declaration
         */
        public Collection<String> getHeaders(String name) {
            void var1_1;
            List headers = this._headers.getValues(name);
            if (headers == null) {
                return Collections.emptyList();
            }
            return var1_1;
        }

        public InputStream getInputStream() throws IOException {
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
            return new ByteArrayInputStream(this._bout.getBuf(), 0, this._bout.size());
        }

        public String getSubmittedFileName() {
            return this.getContentDispositionFilename();
        }

        public byte[] getBytes() {
            if (this._bout != null) {
                return this._bout.toByteArray();
            }
            return null;
        }

        public String getName() {
            return this._name;
        }

        public long getSize() {
            return this._size;
        }

        /*
         * WARNING - void declaration
         */
        public void write(String fileName) throws IOException {
            block9: {
                void var1_1;
                void var2_6;
                if (this._file == null) {
                    this._temporary = false;
                    this._file = new File(this.this$0._tmpDir, fileName);
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this._file));){
                        this._bout.writeTo((OutputStream)bos);
                        bos.flush();
                        break block9;
                    }
                    finally {
                        this._bout = null;
                    }
                }
                this._temporary = false;
                Path src = this._file.toPath();
                Path target = src.resolveSibling(fileName);
                Files.move((Path)var2_6, target, StandardCopyOption.REPLACE_EXISTING);
                this._file = var1_1.toFile();
            }
        }

        public void delete() throws IOException {
            if (this._file != null && this._file.exists() && !this._file.delete()) {
                throw new IOException("Could Not Delete File");
            }
        }

        public void cleanUp() throws IOException {
            if (this._temporary) {
                this.delete();
            }
        }

        public File getFile() {
            return this._file;
        }

        public String getContentDispositionFilename() {
            return this._filename;
        }
    }

    public static enum NonCompliance {
        TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7");

        final String _rfcRef;

        /*
         * WARNING - void declaration
         */
        private NonCompliance(String rfcRef) {
            void var3_3;
            this._rfcRef = var3_3;
        }

        public final String getURL() {
            return this._rfcRef;
        }
    }
}

