/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;

public class MetaData
implements Iterable<HttpField> {
    private HttpVersion _httpVersion;
    private final HttpFields _fields;
    private long _contentLength;
    private Supplier<HttpFields> _trailers;

    /*
     * WARNING - void declaration
     */
    public MetaData(HttpVersion version, HttpFields fields) {
        this((HttpVersion)var1_1, (HttpFields)var2_2, Long.MIN_VALUE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MetaData(HttpVersion version, HttpFields fields, long contentLength) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._httpVersion = var1_1;
        this._fields = var2_2;
        this._contentLength = var3_3;
    }

    protected void recycle() {
        this._httpVersion = null;
        if (this._fields != null) {
            this._fields.clear();
        }
        this._contentLength = Long.MIN_VALUE;
    }

    public boolean isRequest() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    @Deprecated
    public HttpVersion getVersion() {
        return this.getHttpVersion();
    }

    public HttpVersion getHttpVersion() {
        return this._httpVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpVersion(HttpVersion httpVersion) {
        void var1_1;
        this._httpVersion = var1_1;
    }

    public HttpFields getFields() {
        return this._fields;
    }

    public Supplier<HttpFields> getTrailerSupplier() {
        return this._trailers;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrailerSupplier(Supplier<HttpFields> trailers) {
        void var1_1;
        this._trailers = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public long getContentLength() {
        if (this._contentLength == Long.MIN_VALUE && this._fields != null) {
            void var1_1;
            HttpField field = this._fields.getField(HttpHeader.CONTENT_LENGTH);
            this._contentLength = field == null ? -1L : var1_1.getLongValue();
        }
        return this._contentLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentLength(long contentLength) {
        void var1_1;
        this._contentLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<HttpField> iterator() {
        void var1_1;
        HttpFields fields = this.getFields();
        if (fields == null) {
            return Collections.emptyIterator();
        }
        return var1_1.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder out = new StringBuilder();
        for (HttpField field : this) {
            void var3_3;
            out.append(var3_3).append(System.lineSeparator());
        }
        return var1_1.toString();
    }

    public static class Response
    extends MetaData {
        private int _status;
        private String _reason;

        public Response() {
            this(null, 0, null);
        }

        /*
         * WARNING - void declaration
         */
        public Response(HttpVersion version, int status, HttpFields fields) {
            this((HttpVersion)var1_1, (int)var2_2, (HttpFields)var3_3, Long.MIN_VALUE);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Response(HttpVersion version, int status, HttpFields fields, long contentLength) {
            super((HttpVersion)var1_1, (HttpFields)var3_3, contentLength);
            void var2_2;
            void var3_3;
            void var1_1;
            this._status = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Response(HttpVersion version, int status, String reason, HttpFields fields, long contentLength) {
            super((HttpVersion)var1_1, fields, contentLength);
            void var2_2;
            void var3_3;
            void var1_1;
            this._reason = var3_3;
            this._status = var2_2;
        }

        @Override
        public boolean isResponse() {
            return true;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        /*
         * WARNING - void declaration
         */
        public void setStatus(int status) {
            void var1_1;
            this._status = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setReason(String reason) {
            void var1_1;
            this._reason = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            HttpFields fields = this.getFields();
            return String.format("%s{s=%d,h=%d,cl=%d}", new Object[]{this.getHttpVersion(), this.getStatus(), fields == null ? -1 : var1_1.size(), this.getContentLength()});
        }
    }

    public static class Request
    extends MetaData {
        private String _method;
        private HttpURI _uri;

        /*
         * WARNING - void declaration
         */
        public Request(HttpFields fields) {
            this(null, null, null, (HttpFields)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Request(String method, HttpURI uri, HttpVersion version, HttpFields fields) {
            this((String)var1_1, (HttpURI)var2_2, (HttpVersion)var3_3, fields, Long.MIN_VALUE);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Request(String method, HttpURI uri, HttpVersion version, HttpFields fields, long contentLength) {
            super((HttpVersion)var3_3, fields, contentLength);
            void var2_2;
            void var1_1;
            void var3_3;
            this._method = var1_1;
            this._uri = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Request(String method, HttpScheme scheme, HostPortHttpField hostPort, String uri, HttpVersion version, HttpFields fields) {
            this((String)var1_1, new HttpURI(scheme == null ? null : var2_2.asString(), hostPort == null ? null : hostPort.getHost(), hostPort == null ? -1 : var3_3.getPort(), uri), version, fields);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Request(String method, HttpScheme scheme, HostPortHttpField hostPort, String uri, HttpVersion version, HttpFields fields, long contentLength) {
            this((String)var1_1, new HttpURI(scheme == null ? null : var2_2.asString(), hostPort == null ? null : hostPort.getHost(), hostPort == null ? -1 : var3_3.getPort(), uri), version, fields, contentLength);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Request(String method, String scheme, HostPortHttpField hostPort, String uri, HttpVersion version, HttpFields fields, long contentLength) {
            this((String)var1_1, new HttpURI((String)var2_2, hostPort == null ? null : hostPort.getHost(), hostPort == null ? -1 : var3_3.getPort(), uri), version, fields, contentLength);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Request(Request request) {
            this(request.getMethod(), new HttpURI(request.getURI()), request.getHttpVersion(), new HttpFields(request.getFields()), var1_1.getContentLength());
            void var1_1;
        }

        @Override
        public void recycle() {
            super.recycle();
            this._method = null;
            if (this._uri != null) {
                this._uri.clear();
            }
        }

        @Override
        public boolean isRequest() {
            return true;
        }

        public String getMethod() {
            return this._method;
        }

        /*
         * WARNING - void declaration
         */
        public void setMethod(String method) {
            void var1_1;
            this._method = var1_1;
        }

        public HttpURI getURI() {
            return this._uri;
        }

        public String getURIString() {
            if (this._uri == null) {
                return null;
            }
            return this._uri.toString();
        }

        /*
         * WARNING - void declaration
         */
        public void setURI(HttpURI uri) {
            void var1_1;
            this._uri = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            HttpFields fields = this.getFields();
            return String.format("%s{u=%s,%s,h=%d,cl=%d}", new Object[]{this.getMethod(), this.getURI(), this.getHttpVersion(), fields == null ? -1 : var1_1.size(), this.getContentLength()});
        }
    }
}

