/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Objects;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class HttpURI {
    private static final Trie<Boolean> __ambiguousSegments = new ArrayTrie();
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    private String _uri;
    private String _decodedPath;
    private final EnumSet<Violation> _violations = EnumSet.noneOf(Violation.class);
    private boolean _emptySegment;

    /*
     * WARNING - void declaration
     */
    public static HttpURI createHttpURI(String scheme, String host, int port, String path, String param, String query, String fragment) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (port == 80 && HttpScheme.HTTP.is(scheme)) {
            port = 0;
        }
        if (port == 443 && HttpScheme.HTTPS.is(scheme)) {
            port = 0;
        }
        return new HttpURI(string, (String)var1_1, (int)var2_2, (String)var3_3, param, query, fragment);
    }

    public HttpURI() {
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI(String scheme, String host, int port, String path, String param, String query, String fragment) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._scheme = var1_1;
        this._host = var2_2;
        this._port = var3_3;
        if (path != null) {
            this.parse(State.PATH, path, 0, path.length());
        }
        if (param != null) {
            this._param = param;
        }
        if (query != null) {
            this._query = query;
        }
        if (fragment != null) {
            this._fragment = fragment;
        }
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI(HttpURI uri) {
        void var1_1;
        this._scheme = uri._scheme;
        this._user = uri._user;
        this._host = uri._host;
        this._port = uri._port;
        this._path = uri._path;
        this._param = uri._param;
        this._query = uri._query;
        this._fragment = uri._fragment;
        this._uri = uri._uri;
        this._decodedPath = uri._decodedPath;
        this._violations.addAll(var1_1._violations);
        this._emptySegment = false;
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI(HttpURI schemeHostPort, HttpURI uri) {
        void var2_2;
        void var1_1;
        this._scheme = schemeHostPort._scheme;
        this._user = schemeHostPort._user;
        this._host = schemeHostPort._host;
        this._port = var1_1._port;
        this._path = uri._path;
        this._param = uri._param;
        this._query = uri._query;
        this._fragment = uri._fragment;
        this._uri = uri._uri;
        this._decodedPath = uri._decodedPath;
        this._violations.addAll(var2_2._violations);
        this._emptySegment = false;
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI(String uri) {
        void var1_1;
        this._port = -1;
        this.parse(State.START, uri, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI(URI uri) {
        void var1_1;
        this._uri = null;
        this._scheme = uri.getScheme();
        this._host = uri.getHost();
        if (this._host == null && uri.getRawSchemeSpecificPart().startsWith("//")) {
            this._host = "";
        }
        this._port = uri.getPort();
        this._user = uri.getUserInfo();
        String path = uri.getRawPath();
        if (path != null) {
            void var2_2;
            this.parse(State.PATH, path, 0, var2_2.length());
        }
        this._query = uri.getRawQuery();
        this._fragment = var1_1.getFragment();
    }

    /*
     * WARNING - void declaration
     */
    public HttpURI(String scheme, String host, int port, String pathQuery) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._uri = null;
        this._scheme = var1_1;
        this._host = var2_2;
        this._port = var3_3;
        if (pathQuery != null) {
            this.parse(State.PATH, pathQuery, 0, pathQuery.length());
        }
    }

    public void clear() {
        this._uri = null;
        this._scheme = null;
        this._user = null;
        this._host = null;
        this._port = -1;
        this._path = null;
        this._param = null;
        this._query = null;
        this._fragment = null;
        this._decodedPath = null;
        this._emptySegment = false;
        this._violations.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void parse(String uri) {
        void var1_1;
        this.clear();
        this._uri = uri;
        this.parse(State.START, uri, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public void parseRequestTarget(String method, String uri) {
        void var2_2;
        State state;
        HttpURI httpURI;
        void var1_1;
        this.clear();
        this._uri = uri;
        if (HttpMethod.CONNECT.is((String)var1_1)) {
            httpURI = this;
            state = State.HOST;
        } else {
            httpURI = this;
            state = uri.startsWith("/") ? State.PATH : State.START;
        }
        httpURI.parse(state, uri, 0, var2_2.length());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void parseConnect(String uri) {
        void var1_1;
        this.clear();
        this._uri = uri;
        this._path = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void parse(String uri, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.clear();
        int end = offset + length;
        this._uri = uri.substring(offset, end);
        this.parse(State.START, (String)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void parse(State state, String uri, int offset, int end) {
        int i;
        int mark = offset;
        int pathMark = 0;
        int segment = 0;
        boolean encodedPath = false;
        boolean encodedUtf16 = false;
        int encodedCharacters = 0;
        int encodedValue = 0;
        boolean dot = false;
        while (i < end) {
            char c = uri.charAt(i);
            block0 : switch (state) {
                case START: {
                    switch (c) {
                        case '/': {
                            mark = i;
                            state = State.HOST_OR_PATH;
                            break block0;
                        }
                        case ';': {
                            this.checkSegment(uri, segment, i, true);
                            mark = i + 1;
                            state = State.PARAM;
                            break block0;
                        }
                        case '?': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = "";
                            mark = i + 1;
                            state = State.QUERY;
                            break block0;
                        }
                        case '#': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = "";
                            mark = i + 1;
                            state = State.FRAGMENT;
                            break block0;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            break block0;
                        }
                        case '%': {
                            encodedPath = true;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            pathMark = segment = i;
                            mark = segment;
                            state = State.PATH;
                            break block0;
                        }
                        case '.': {
                            dot = true;
                            pathMark = segment = i;
                            state = State.PATH;
                            break block0;
                        }
                    }
                    mark = i;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        break;
                    }
                    pathMark = segment = i;
                    state = State.PATH;
                    break;
                }
                case SCHEME_OR_PATH: {
                    switch (c) {
                        case ':': {
                            this._scheme = uri.substring(mark, i);
                            state = State.START;
                            break block0;
                        }
                        case '/': {
                            segment = i + true;
                            state = State.PATH;
                            break block0;
                        }
                        case ';': {
                            mark = i + true;
                            state = State.PARAM;
                            break block0;
                        }
                        case '?': {
                            this._path = uri.substring(mark, i);
                            mark = i + 1;
                            state = State.QUERY;
                            break block0;
                        }
                        case '%': {
                            encodedPath = true;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            state = State.PATH;
                            break block0;
                        }
                        case '#': {
                            this._path = uri.substring(mark, i);
                            state = State.FRAGMENT;
                            break block0;
                        }
                    }
                    break;
                }
                case HOST_OR_PATH: {
                    switch (c) {
                        case '/': {
                            this._host = "";
                            mark = i + true;
                            state = State.HOST;
                            break block0;
                        }
                        case '#': 
                        case '%': 
                        case '.': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i;
                            pathMark = mark;
                            segment = mark + 1;
                            state = State.PATH;
                            break block0;
                        }
                    }
                    pathMark = mark;
                    segment = mark + 1;
                    state = State.PATH;
                    break;
                }
                case HOST: {
                    switch (c) {
                        case '/': {
                            this._host = uri.substring(mark, i);
                            pathMark = mark = i;
                            segment = mark + 1;
                            state = State.PATH;
                            break block0;
                        }
                        case ':': {
                            if (i > mark) {
                                this._host = uri.substring(mark, i);
                            }
                            mark = i + true;
                            state = State.PORT;
                            break block0;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = uri.substring(mark, i);
                            mark = i + 1;
                            break block0;
                        }
                        case '[': {
                            state = State.IPV6;
                            break block0;
                        }
                    }
                    break;
                }
                case IPV6: {
                    switch (c) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
                        }
                        case ']': {
                            c = uri.charAt(++i);
                            this._host = uri.substring(mark, i);
                            if (c == ':') {
                                mark = i + 1;
                                state = State.PORT;
                                break block0;
                            }
                            pathMark = mark = i;
                            state = State.PATH;
                            break block0;
                        }
                    }
                    break;
                }
                case PORT: {
                    if (c == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + uri.substring(mark, i);
                        mark = i + 1;
                        state = State.HOST;
                        break;
                    }
                    if (c != '/') break;
                    this._port = TypeUtil.parseInt((String)uri, (int)mark, (int)(i - mark), (int)10);
                    pathMark = mark = i;
                    segment = i + 1;
                    state = State.PATH;
                    break;
                }
                case PATH: {
                    if (encodedCharacters > 0) {
                        if (encodedCharacters == 2 && c == 'u' && !encodedUtf16) {
                            this._violations.add(Violation.UTF16);
                            encodedUtf16 = true;
                            encodedCharacters = 4;
                            break;
                        }
                        encodedValue = (encodedValue << 4) + TypeUtil.convertHexDigit((char)c);
                        if (--encodedCharacters != 0) break;
                        switch (encodedValue) {
                            case 0: {
                                throw new IllegalArgumentException("Illegal character in path");
                            }
                            case 47: {
                                this._violations.add(Violation.SEPARATOR);
                                break block0;
                            }
                            case 37: {
                                this._violations.add(Violation.ENCODING);
                                break block0;
                            }
                        }
                        break;
                    }
                    switch (c) {
                        case ';': {
                            this.checkSegment(uri, segment, i, true);
                            mark = i + 1;
                            state = State.PARAM;
                            break block0;
                        }
                        case '?': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = uri.substring(pathMark, i);
                            mark = i + 1;
                            state = State.QUERY;
                            break block0;
                        }
                        case '#': {
                            this.checkSegment(uri, segment, i, false);
                            this._path = uri.substring(pathMark, i);
                            mark = i + 1;
                            state = State.FRAGMENT;
                            break block0;
                        }
                        case '/': {
                            if (i != 0) {
                                this.checkSegment(uri, segment, i, false);
                            }
                            segment = i + true;
                            break block0;
                        }
                        case '.': {
                            dot |= segment == i;
                            break block0;
                        }
                        case '%': {
                            encodedPath = true;
                            encodedUtf16 = false;
                            encodedCharacters = 2;
                            encodedValue = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case PARAM: {
                    switch (c) {
                        case '?': {
                            this._path = uri.substring(pathMark, i);
                            this._param = uri.substring(mark, i);
                            mark = i + 1;
                            state = State.QUERY;
                            break block0;
                        }
                        case '#': {
                            this._path = uri.substring(pathMark, i);
                            this._param = uri.substring(mark, i);
                            mark = i + 1;
                            state = State.FRAGMENT;
                            break block0;
                        }
                        case '/': {
                            encodedPath = true;
                            segment = i + true;
                            state = State.PATH;
                            break block0;
                        }
                        case ';': {
                            mark = i + true;
                            break block0;
                        }
                    }
                    break;
                }
                case QUERY: {
                    if (c != '#') break;
                    this._query = uri.substring(mark, i);
                    mark = i + 1;
                    state = State.FRAGMENT;
                    break;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = uri.substring(mark, end);
                    i = end;
                    break;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
            ++i;
        }
        switch (state) {
            case START: {
                this._path = "";
                this.checkSegment(uri, segment, end, false);
                break;
            }
            case ASTERISK: {
                break;
            }
            case SCHEME_OR_PATH: 
            case HOST_OR_PATH: {
                this._path = uri.substring(mark, end);
                break;
            }
            case HOST: {
                if (end <= mark) break;
                this._host = uri.substring(mark, end);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + uri);
            }
            case PORT: {
                this._port = TypeUtil.parseInt((String)uri, (int)mark, (int)(end - mark), (int)10);
                break;
            }
            case PARAM: {
                this._path = uri.substring(pathMark, end);
                this._param = uri.substring(mark, end);
                break;
            }
            case PATH: {
                this.checkSegment(uri, segment, end, false);
                this._path = uri.substring(pathMark, end);
                break;
            }
            case QUERY: {
                this._query = uri.substring(mark, end);
                break;
            }
            case FRAGMENT: {
                void var2_2;
                this._fragment = var2_2.substring(mark, end);
                break;
            }
            default: {
                void var1_1;
                throw new IllegalStateException(var1_1.toString());
            }
        }
        if (!encodedPath && !dot) {
            if (this._param == null) {
                this._decodedPath = this._path;
                return;
            }
            this._decodedPath = this._path.substring(0, this._path.length() - this._param.length() - 1);
            return;
        }
        if (this._path != null) {
            void var3_4;
            String decodedNonCanonical = URIUtil.decodePath((String)this._path);
            this._decodedPath = URIUtil.canonicalPath((String)var3_4);
            if (this._decodedPath == null) {
                throw new IllegalArgumentException("Bad URI");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkSegment(String uri, int segment, int end, boolean param) {
        void var2_2;
        void var3_3;
        Boolean ambiguous;
        if (this._emptySegment) {
            this._violations.add(Violation.EMPTY);
        }
        if (end == segment) {
            if (end >= uri.length() || "#?".indexOf(uri.charAt(end)) >= 0) {
                return;
            }
            if (segment == 0) {
                this._violations.add(Violation.EMPTY);
                return;
            }
            if (!this._emptySegment) {
                this._emptySegment = true;
                return;
            }
        }
        if ((ambiguous = (Boolean)__ambiguousSegments.get(uri, segment, (int)(var3_3 - var2_2))) != null) {
            void var1_1;
            if (Boolean.TRUE.equals(var1_1)) {
                this._violations.add(Violation.SEGMENT);
            }
            if (param) {
                this._violations.add(Violation.PARAM);
            }
        }
    }

    public boolean hasAmbiguousSegment() {
        return this._violations.contains((Object)Violation.SEGMENT);
    }

    public boolean hasAmbiguousEmptySegment() {
        return this._violations.contains((Object)Violation.EMPTY);
    }

    public boolean hasAmbiguousSeparator() {
        return this._violations.contains((Object)Violation.SEPARATOR);
    }

    public boolean hasAmbiguousParameter() {
        return this._violations.contains((Object)Violation.PARAM);
    }

    public boolean hasAmbiguousEncoding() {
        return this._violations.contains((Object)Violation.ENCODING);
    }

    public boolean isAmbiguous() {
        return !this._violations.isEmpty() && (this._violations.size() != 1 || !this._violations.contains((Object)Violation.UTF16));
    }

    public boolean hasViolations() {
        return !this._violations.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    boolean hasViolation(Violation violation) {
        void var1_1;
        return this._violations.contains(var1_1);
    }

    public boolean hasUtf16Encoding() {
        return this._violations.contains((Object)Violation.UTF16);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        if (this._host != null && this._host.isEmpty()) {
            return null;
        }
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath() {
        return this._path;
    }

    public String getDecodedPath() {
        return this._decodedPath;
    }

    public String getParam() {
        return this._param;
    }

    /*
     * WARNING - void declaration
     */
    public void setParam(String param) {
        if (!Objects.equals(this._param, param)) {
            void var1_1;
            if (this._param != null && this._path.endsWith(";" + this._param)) {
                this._path = this._path.substring(0, this._path.length() - 1 - this._param.length());
            }
            this._param = var1_1;
            if (this._param != null) {
                this._path = (this._path == null ? "" : this._path) + ";" + this._param;
            }
            this._uri = null;
        }
    }

    public String getQuery() {
        return this._query;
    }

    public boolean hasQuery() {
        return this._query != null && !this._query.isEmpty();
    }

    public String getFragment() {
        return this._fragment;
    }

    /*
     * WARNING - void declaration
     */
    public void decodeQueryTo(MultiMap<String> parameters) {
        void var1_1;
        if (this._query == null) {
            return;
        }
        UrlEncoded.decodeUtf8To((String)this._query, (MultiMap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void decodeQueryTo(MultiMap<String> parameters, String encoding) throws UnsupportedEncodingException {
        void var2_2;
        void var1_1;
        this.decodeQueryTo((MultiMap<String>)var1_1, Charset.forName((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void decodeQueryTo(MultiMap<String> parameters, Charset encoding) throws UnsupportedEncodingException {
        void var2_2;
        void var1_1;
        if (this._query == null) {
            return;
        }
        if (encoding == null || StandardCharsets.UTF_8.equals(encoding)) {
            UrlEncoded.decodeUtf8To((String)this._query, parameters);
            return;
        }
        UrlEncoded.decodeTo((String)this._query, (MultiMap)var1_1, (Charset)var2_2);
    }

    public boolean isAbsolute() {
        return this._scheme != null && !this._scheme.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        if (this._uri == null) {
            void var1_1;
            StringBuilder out = new StringBuilder();
            if (this._scheme != null) {
                out.append(this._scheme).append(':');
            }
            if (this._host != null) {
                out.append("//");
                if (this._user != null) {
                    out.append(this._user).append('@');
                }
                out.append(this._host);
            }
            if (this._port > 0) {
                out.append(':').append(this._port);
            }
            if (this._path != null) {
                out.append(this._path);
            }
            if (this._query != null) {
                out.append('?').append(this._query);
            }
            if (this._fragment != null) {
                out.append('#').append(this._fragment);
            }
            this._uri = out.length() > 0 ? var1_1.toString() : "";
        }
        return this._uri;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(var1_1.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public void setScheme(String scheme) {
        void var1_1;
        this._scheme = var1_1;
        this._uri = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthority(String host, int port) {
        void var2_2;
        void var1_1;
        if (host != null) {
            HttpURI httpURI = this;
            if (!httpURI.isPathValidForAuthority(httpURI._path)) {
                throw new IllegalArgumentException("Relative path with authority");
            }
        }
        this._host = var1_1;
        this._port = var2_2;
        this._uri = null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isPathValidForAuthority(String path) {
        void var1_1;
        if (path == null) {
            return true;
        }
        if (path.isEmpty() || "*".equals(path)) {
            return true;
        }
        return var1_1.startsWith("/");
    }

    /*
     * WARNING - void declaration
     */
    public void setPath(String path) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(path)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        if (path != null) {
            void var1_1;
            this.parse(State.PATH, path, 0, var1_1.length());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPathQuery(String pathQuery) {
        if (this.hasAuthority() && !this.isPathValidForAuthority(pathQuery)) {
            throw new IllegalArgumentException("Relative path with authority");
        }
        this._uri = null;
        this._path = null;
        this._decodedPath = null;
        this._param = null;
        this._fragment = null;
        if (pathQuery != null) {
            void var1_1;
            this.parse(State.PATH, pathQuery, 0, var1_1.length());
        }
    }

    private boolean hasAuthority() {
        return this._host != null;
    }

    /*
     * WARNING - void declaration
     */
    public void setQuery(String query) {
        void var1_1;
        this._query = var1_1;
        this._uri = null;
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this._scheme, null, this._host, this._port, this._path, this._query == null ? null : UrlEncoded.decodeString((String)this._query), this._fragment);
    }

    public String getPathQuery() {
        if (this._query == null) {
            return this._path;
        }
        return this._path + "?" + this._query;
    }

    public String getAuthority() {
        if (this._port > 0) {
            return this._host + ":" + this._port;
        }
        return this._host;
    }

    public String getUser() {
        return this._user;
    }

    static {
        __ambiguousSegments.put(".", (Object)Boolean.FALSE);
        __ambiguousSegments.put("%2e", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%u002e", (Object)Boolean.TRUE);
        __ambiguousSegments.put("..", (Object)Boolean.FALSE);
        __ambiguousSegments.put(".%2e", (Object)Boolean.TRUE);
        __ambiguousSegments.put(".%u002e", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%2e.", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%2e%2e", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%2e%u002e", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%u002e.", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%u002e%2e", (Object)Boolean.TRUE);
        __ambiguousSegments.put("%u002e%u002e", (Object)Boolean.TRUE);
    }

    static enum Violation {
        SEGMENT("Ambiguous path segments"),
        SEPARATOR("Ambiguous path separator"),
        PARAM("Ambiguous path parameters"),
        ENCODING("Ambiguous double encoding"),
        EMPTY("Ambiguous empty segments"),
        UTF16("Non standard UTF-16 encoding");

        private final String _message;

        /*
         * WARNING - void declaration
         */
        private Violation(String message) {
            void var3_3;
            this._message = var3_3;
        }

        final String getMessage() {
            return this._message;
        }
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

