/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public enum HttpMethod {
    ACL(Type.IDEMPOTENT),
    BASELINE_CONTROL(Type.IDEMPOTENT),
    BIND(Type.IDEMPOTENT),
    CHECKIN(Type.IDEMPOTENT),
    CHECKOUT(Type.IDEMPOTENT),
    CONNECT(Type.NORMAL),
    COPY(Type.IDEMPOTENT),
    DELETE(Type.IDEMPOTENT),
    GET(Type.SAFE),
    HEAD(Type.SAFE),
    LABEL(Type.IDEMPOTENT),
    LINK(Type.IDEMPOTENT),
    LOCK(Type.NORMAL),
    MERGE(Type.IDEMPOTENT),
    MKACTIVITY(Type.IDEMPOTENT),
    MKCALENDAR(Type.IDEMPOTENT),
    MKCOL(Type.IDEMPOTENT),
    MKREDIRECTREF(Type.IDEMPOTENT),
    MKWORKSPACE(Type.IDEMPOTENT),
    MOVE(Type.IDEMPOTENT),
    OPTIONS(Type.SAFE),
    ORDERPATCH(Type.IDEMPOTENT),
    PATCH(Type.NORMAL),
    POST(Type.NORMAL),
    PRI(Type.SAFE),
    PROPFIND(Type.SAFE),
    PROPPATCH(Type.IDEMPOTENT),
    PUT(Type.IDEMPOTENT),
    REBIND(Type.IDEMPOTENT),
    REPORT(Type.SAFE),
    SEARCH(Type.SAFE),
    TRACE(Type.SAFE),
    UNBIND(Type.IDEMPOTENT),
    UNCHECKOUT(Type.IDEMPOTENT),
    UNLINK(Type.IDEMPOTENT),
    UNLOCK(Type.IDEMPOTENT),
    UPDATE(Type.IDEMPOTENT),
    UPDATEREDIRECTREF(Type.IDEMPOTENT),
    VERSION_CONTROL(Type.IDEMPOTENT),
    PROXY(Type.NORMAL);

    private final String _method = this.name().replace('_', '-');
    private final byte[] _bytes;
    private final ByteBuffer _buffer;
    private final Type _type;
    public static final Trie<HttpMethod> INSENSITIVE_CACHE;
    public static final Trie<HttpMethod> CACHE;
    public static final Trie<HttpMethod> LOOK_AHEAD;
    public static final int ACL_AS_INT = 1094929440;
    public static final int GET_AS_INT = 1195725856;
    public static final int PRI_AS_INT = 1347569952;
    public static final int PUT_AS_INT = 1347769376;
    public static final int POST_AS_INT = 1347375956;
    public static final int HEAD_AS_INT = 1212498244;

    /*
     * WARNING - void declaration
     */
    private HttpMethod(Type type) {
        void var3_3;
        this._type = var3_3;
        this._bytes = StringUtil.getBytes((String)this._method);
        this._buffer = ByteBuffer.wrap(this._bytes);
    }

    public final byte[] getBytes() {
        return this._bytes;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean is(String s) {
        void var1_1;
        return this.toString().equalsIgnoreCase((String)var1_1);
    }

    public final boolean isSafe() {
        return this._type == Type.SAFE;
    }

    public final boolean isIdempotent() {
        return this._type.ordinal() >= Type.IDEMPOTENT.ordinal();
    }

    public final ByteBuffer asBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public final String asString() {
        return this._method;
    }

    public final String toString() {
        return this._method;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static HttpMethod lookAheadGet(byte[] bytes, int position, int limit) {
        void var1_1;
        void var2_2;
        byte[] byArray;
        return (HttpMethod)((Object)LOOK_AHEAD.getBest(byArray, position, (int)(var2_2 - var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static HttpMethod lookAheadGet(ByteBuffer buffer) {
        void var1_1;
        ByteBuffer byteBuffer;
        int len = buffer.remaining();
        if (len > 3) {
            ByteBuffer byteBuffer2 = buffer;
            switch (byteBuffer2.getInt(byteBuffer2.position())) {
                case 1094929440: {
                    return ACL;
                }
                case 1195725856: {
                    return GET;
                }
                case 1347569952: {
                    return PRI;
                }
                case 1347769376: {
                    return PUT;
                }
                case 1347375956: {
                    if (len <= 4) break;
                    ByteBuffer byteBuffer3 = buffer;
                    if (byteBuffer3.get(byteBuffer3.position() + 4) != 32) break;
                    return POST;
                }
                case 1212498244: {
                    if (len <= 4) break;
                    ByteBuffer byteBuffer4 = buffer;
                    if (byteBuffer4.get(byteBuffer4.position() + 4) != 32) break;
                    return HEAD;
                }
            }
        }
        return (HttpMethod)((Object)LOOK_AHEAD.getBest(byteBuffer, 0, (int)var1_1));
    }

    public static HttpMethod fromString(String method) {
        String string;
        return (HttpMethod)((Object)CACHE.get(string));
    }

    /*
     * WARNING - void declaration
     */
    static {
        INSENSITIVE_CACHE = new ArrayTrie(252);
        CACHE = new ArrayTernaryTrie(false, 300);
        LOOK_AHEAD = new ArrayTernaryTrie(false, 330);
        for (HttpMethod method : HttpMethod.values()) {
            void var3_3;
            if (!INSENSITIVE_CACHE.put(method.asString(), (Object)method)) {
                throw new IllegalStateException("INSENSITIVE_CACHE too small: " + (Object)((Object)method));
            }
            if (!CACHE.put(method.asString(), (Object)method)) {
                throw new IllegalStateException("CACHE too small: " + (Object)((Object)method));
            }
            if (LOOK_AHEAD.put(method.asString() + ' ', (Object)method)) continue;
            throw new IllegalStateException("LOOK_AHEAD too small: " + var3_3);
        }
    }

    private static enum Type {
        NORMAL,
        IDEMPOTENT,
        SAFE;

    }
}

