/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Trie;

public enum HttpHeaderValue {
    CLOSE("close"),
    CHUNKED("chunked"),
    GZIP("gzip"),
    IDENTITY("identity"),
    KEEP_ALIVE("keep-alive"),
    CONTINUE("100-continue"),
    PROCESSING("102-processing"),
    TE("TE"),
    BYTES("bytes"),
    NO_CACHE("no-cache"),
    UPGRADE("Upgrade"),
    UNKNOWN("::UNKNOWN::");

    public static final Trie<HttpHeaderValue> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;
    private static EnumSet<HttpHeader> __known;

    /*
     * WARNING - void declaration
     */
    private HttpHeaderValue(String s) {
        void var3_3;
        this._string = s;
        this._buffer = BufferUtil.toBuffer((String)var3_3);
    }

    public final ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean is(String s) {
        void var1_1;
        return this._string.equalsIgnoreCase((String)var1_1);
    }

    public final String asString() {
        return this._string;
    }

    public final String toString() {
        return this._string;
    }

    public static boolean hasKnownValues(HttpHeader header) {
        HttpHeader httpHeader;
        if (header == null) {
            return false;
        }
        return __known.contains((Object)httpHeader);
    }

    /*
     * WARNING - void declaration
     */
    static {
        CACHE = new ArrayTrie();
        for (HttpHeaderValue value : HttpHeaderValue.values()) {
            void var3_3;
            if (value == UNKNOWN) continue;
            CACHE.put(value.toString(), (Object)var3_3);
        }
        __known = EnumSet.of(HttpHeader.CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.CONTENT_ENCODING);
    }
}

