/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final boolean __STRICT = Boolean.getBoolean("org.eclipse.jetty.http.HttpGenerator.STRICT");
    private static final byte[] __colon_space = new byte[]{58, 32};
    public static final MetaData.Response CONTINUE_100_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 100, null, null, -1L);
    public static final MetaData.Response PROGRESS_102_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 102, null, null, -1L);
    public static final MetaData.Response RESPONSE_500_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 500, null, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L);
    public static final int CHUNK_SIZE = 12;
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContentResponse = false;
    private Boolean _persistent = null;
    private Supplier<HttpFields> _trailers = null;
    private final int _send;
    private static final int SEND_SERVER = 1;
    private static final int SEND_XPOWEREDBY = 2;
    private static final Trie<Boolean> ASSUMED_CONTENT_METHODS = new ArrayTrie(8);
    private boolean _needCRLF = false;
    private static final byte[] ZERO_CHUNK;
    private static final byte[] LAST_CHUNK;
    private static final byte[] CONTENT_LENGTH_0;
    private static final byte[] CONNECTION_CLOSE;
    private static final byte[] HTTP_1_1_SPACE;
    private static final byte[] TRANSFER_ENCODING_CHUNKED;
    private static final byte[][] SEND;
    private static final PreparedResponse[] __preprepared;

    public static void setJettyVersion(String serverVersion) {
        String string;
        HttpGenerator.SEND[1] = StringUtil.getBytes((String)("Server: " + serverVersion + "\r\n"));
        HttpGenerator.SEND[2] = StringUtil.getBytes((String)("X-Powered-By: " + serverVersion + "\r\n"));
        HttpGenerator.SEND[3] = StringUtil.getBytes((String)("Server: " + serverVersion + "\r\nX-Powered-By: " + string + "\r\n"));
    }

    public HttpGenerator() {
        this(false, false);
    }

    /*
     * WARNING - void declaration
     */
    public HttpGenerator(boolean sendServerVersion, boolean sendXPoweredBy) {
        void var2_2;
        void var1_1;
        this._send = (var1_1 != false ? 1 : 0) | (var2_2 != false ? 2 : 0);
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContentResponse = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
        this._trailers = null;
    }

    @Deprecated
    public boolean getSendServerVersion() {
        return (this._send & 1) != 0;
    }

    @Deprecated
    public void setSendServerVersion(boolean sendServerVersion) {
        throw new UnsupportedOperationException();
    }

    public State getState() {
        return this._state;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isState(State state) {
        void var1_1;
        return this._state == var1_1;
    }

    public boolean isIdle() {
        return this._state == State.START;
    }

    public boolean isEnd() {
        return this._state == State.END;
    }

    public boolean isCommitted() {
        return this._state.ordinal() >= State.COMMITTED.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isNoContent() {
        return this._noContentResponse;
    }

    /*
     * WARNING - void declaration
     */
    public void setPersistent(boolean persistent) {
        void var1_1;
        this._persistent = (boolean)var1_1;
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this._persistent);
    }

    public boolean isWritten() {
        return this._contentPrepared > 0L;
    }

    public long getContentPrepared() {
        return this._contentPrepared;
    }

    public void abort() {
        this._persistent = Boolean.FALSE;
        this._state = State.END;
        this._endOfContent = null;
    }

    /*
     * Exception decompiling
     */
    public Result generateRequest(MetaData.Request info, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private Result committed(ByteBuffer chunk, ByteBuffer content, boolean last) {
        void var2_3;
        void var3_4;
        int len = BufferUtil.length((ByteBuffer)content);
        if (len > 0) {
            if (this.isChunking()) {
                void var1_1;
                if (chunk == null) {
                    return Result.NEED_CHUNK;
                }
                BufferUtil.clearToFill((ByteBuffer)chunk);
                this.prepareChunk(chunk, len);
                BufferUtil.flipToFlush((ByteBuffer)var1_1, (int)0);
            }
            this._contentPrepared += (long)len;
        }
        if (var3_4 != false) {
            this._state = State.COMPLETING;
            if (len > 0) {
                return Result.FLUSH;
            }
            return Result.CONTINUE;
        }
        if (var2_3 > 0) {
            return Result.FLUSH;
        }
        return Result.DONE;
    }

    /*
     * WARNING - void declaration
     */
    private Result completing(ByteBuffer chunk, ByteBuffer content) {
        if (BufferUtil.hasContent((ByteBuffer)content)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("discarding content in COMPLETING", new Object[0]);
            }
            BufferUtil.clear((ByteBuffer)content);
        }
        if (this.isChunking()) {
            void var1_1;
            if (this._trailers != null) {
                if (chunk == null || chunk.capacity() <= 12) {
                    return Result.NEED_CHUNK_TRAILER;
                }
                HttpFields trailers = this._trailers.get();
                if (trailers != null) {
                    void var2_2;
                    BufferUtil.clearToFill((ByteBuffer)chunk);
                    this.generateTrailers(chunk, (HttpFields)var2_2);
                    BufferUtil.flipToFlush((ByteBuffer)chunk, (int)0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
            }
            if (chunk == null) {
                return Result.NEED_CHUNK;
            }
            BufferUtil.clearToFill((ByteBuffer)chunk);
            this.prepareChunk(chunk, 0);
            BufferUtil.flipToFlush((ByteBuffer)var1_1, (int)0);
            this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
            return Result.FLUSH;
        }
        this._state = State.END;
        if (Boolean.TRUE.equals(this._persistent)) {
            return Result.DONE;
        }
        return Result.SHUTDOWN_OUT;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Result generateResponse(MetaData.Response info, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.generateResponse((MetaData.Response)var1_1, false, (ByteBuffer)var2_2, (ByteBuffer)var3_3, content, last);
    }

    /*
     * Exception decompiling
     */
    public Result generateResponse(MetaData.Response info, boolean head, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private void prepareChunk(ByteBuffer chunk, int remaining) {
        void var1_1;
        if (this._needCRLF) {
            BufferUtil.putCRLF((ByteBuffer)chunk);
        }
        if (remaining > 0) {
            void var2_2;
            BufferUtil.putHexInt((ByteBuffer)chunk, (int)var2_2);
            BufferUtil.putCRLF((ByteBuffer)chunk);
            this._needCRLF = true;
            return;
        }
        var1_1.put(LAST_CHUNK);
        this._needCRLF = false;
    }

    /*
     * WARNING - void declaration
     */
    private void generateTrailers(ByteBuffer buffer, HttpFields trailer) {
        void var1_1;
        if (this._needCRLF) {
            BufferUtil.putCRLF((ByteBuffer)buffer);
        }
        buffer.put(ZERO_CHUNK);
        int n = trailer.size();
        for (int f = 0; f < n; ++f) {
            HttpField httpField = trailer.getField(f);
            HttpGenerator.putTo(httpField, buffer);
        }
        BufferUtil.putCRLF((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void generateRequestLine(MetaData.Request request, ByteBuffer header) {
        void var2_2;
        void var1_1;
        header.put(StringUtil.getBytes((String)request.getMethod()));
        header.put((byte)32);
        header.put(StringUtil.getBytes((String)request.getURIString()));
        header.put((byte)32);
        header.put(var1_1.getHttpVersion().toBytes());
        var2_2.put(HttpTokens.CRLF);
    }

    /*
     * WARNING - void declaration
     */
    private void generateResponseLine(MetaData.Response response, ByteBuffer header) {
        void var2_2;
        int status = response.getStatus();
        PreparedResponse preprepared = status < __preprepared.length ? __preprepared[status] : null;
        String reason = response.getReason();
        if (preprepared != null) {
            if (reason == null) {
                header.put(preprepared._responseLine);
                return;
            }
            header.put(preprepared._schemeCode);
            header.put(this.getReasonBytes(reason));
            header.put(HttpTokens.CRLF);
            return;
        }
        header.put(HTTP_1_1_SPACE);
        header.put((byte)(48 + status / 100));
        header.put((byte)(48 + status % 100 / 10));
        header.put((byte)(48 + status % 10));
        header.put((byte)32);
        if (reason == null) {
            void var3_3;
            header.put((byte)(48 + status / 100));
            header.put((byte)(48 + status % 100 / 10));
            header.put((byte)(48 + var3_3 % 10));
        } else {
            void var1_1;
            header.put(this.getReasonBytes((String)var1_1));
        }
        var2_2.put(HttpTokens.CRLF);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getReasonBytes(String reason) {
        void var1_1;
        if (reason.length() > 1024) {
            reason = reason.substring(0, 1024);
        }
        byte[] bytes = StringUtil.getBytes((String)reason);
        int i = bytes.length;
        while (i-- > 0) {
            if (bytes[i] != 13 && bytes[i] != 10) continue;
            bytes[i] = 63;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void generateHeaders(MetaData info, ByteBuffer header, ByteBuffer content, boolean last) {
        void var2_2;
        int n;
        boolean chunkedHint;
        HttpField transferEncoding;
        int send;
        MetaData.Response response;
        block39: {
            boolean assumedContent;
            boolean contentLengthField;
            long contentLength;
            boolean close;
            boolean http11;
            MetaData.Request request;
            block42: {
                boolean assumedContentRequest;
                block40: {
                    block41: {
                        boolean nocontentRequest;
                        request = info instanceof MetaData.Request ? (MetaData.Request)info : null;
                        MetaData.Response response2 = response = info instanceof MetaData.Response ? (MetaData.Response)info : null;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("generateHeaders {} last={} content={}", new Object[]{info, last, BufferUtil.toDetailString((ByteBuffer)content)});
                            LOG.debug(info.getFields().toString(), new Object[0]);
                        }
                        send = this._send;
                        transferEncoding = null;
                        http11 = info.getHttpVersion() == HttpVersion.HTTP_1_1;
                        close = false;
                        this._trailers = http11 ? info.getTrailerSupplier() : null;
                        chunkedHint = this._trailers != null;
                        boolean contentType = false;
                        contentLength = info.getContentLength();
                        contentLengthField = false;
                        HttpFields fields = info.getFields();
                        if (fields != null) {
                            int n2 = fields.size();
                            block7: for (int f = 0; f < n2; ++f) {
                                HttpField field = fields.getField(f);
                                HttpHeader h = field.getHeader();
                                if (h != null) {
                                    switch (h) {
                                        case CONTENT_LENGTH: {
                                            if (contentLength < 0L) {
                                                contentLength = field.getLongValue();
                                            } else if (contentLength != field.getLongValue()) {
                                                throw new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, field.getLongValue()));
                                            }
                                            contentLengthField = true;
                                            continue block7;
                                        }
                                        case CONTENT_TYPE: {
                                            contentType = true;
                                            break;
                                        }
                                        case TRANSFER_ENCODING: {
                                            if (!http11) continue block7;
                                            transferEncoding = field;
                                            chunkedHint = field.contains(HttpHeaderValue.CHUNKED.asString());
                                            continue block7;
                                        }
                                        case CONNECTION: {
                                            boolean keepAlive = field.contains(HttpHeaderValue.KEEP_ALIVE.asString());
                                            if (keepAlive && info.getHttpVersion() == HttpVersion.HTTP_1_0 && this._persistent == null) {
                                                this._persistent = Boolean.TRUE;
                                            }
                                            if (field.contains(HttpHeaderValue.CLOSE.asString())) {
                                                close = true;
                                                this._persistent = Boolean.FALSE;
                                            }
                                            if (keepAlive && Boolean.FALSE.equals(this._persistent)) {
                                                field = new HttpField(HttpHeader.CONNECTION, Stream.of(field.getValues()).filter(s -> {
                                                    String string;
                                                    return !HttpHeaderValue.KEEP_ALIVE.is(string);
                                                }).collect(Collectors.joining(", ")));
                                            }
                                            HttpGenerator.putTo(field, header);
                                            continue block7;
                                        }
                                        case SERVER: {
                                            send &= 0xFFFFFFFE;
                                        }
                                    }
                                }
                                HttpGenerator.putTo(field, header);
                            }
                        }
                        if (last && contentLength < 0L && this._trailers == null) {
                            contentLength = this._contentPrepared + (long)BufferUtil.length((ByteBuffer)content);
                        }
                        assumedContentRequest = request != null && Boolean.TRUE.equals(ASSUMED_CONTENT_METHODS.get(request.getMethod()));
                        assumedContent = assumedContentRequest || contentType || chunkedHint;
                        boolean bl = nocontentRequest = request != null && contentLength <= 0L && !assumedContent;
                        if (this._persistent == null) {
                            this._persistent = http11 || request != null && HttpMethod.CONNECT.is(request.getMethod());
                        }
                        if (!this._noContentResponse && !nocontentRequest) break block40;
                        this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                        if (this._contentPrepared > 0L) {
                            throw new BadMessageException(500, "Content for no content response");
                        }
                        if (!contentLengthField) break block39;
                        if (response == null || response.getStatus() != 304) break block41;
                        HttpGenerator.putContentLength(header, contentLength);
                        break block39;
                    }
                    if (contentLength > 0L) {
                        if (this._contentPrepared == 0L && last) {
                            void var3_3;
                            var3_3.clear();
                            break block39;
                        } else {
                            throw new BadMessageException(500, "Content for no content response");
                        }
                    }
                    break block39;
                }
                if (!http11 || !chunkedHint && (contentLength >= 0L || !this._persistent.booleanValue() && !assumedContentRequest)) break block42;
                this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                if (transferEncoding == null) {
                    header.put(TRANSFER_ENCODING_CHUNKED);
                    break block39;
                } else if (transferEncoding.toString().endsWith(HttpHeaderValue.CHUNKED.toString())) {
                    HttpGenerator.putTo(transferEncoding, header);
                    transferEncoding = null;
                    break block39;
                } else {
                    if (chunkedHint) {
                        throw new BadMessageException(500, "Bad Transfer-Encoding");
                    }
                    HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, transferEncoding.getValue() + ",chunked"), header);
                    transferEncoding = null;
                }
                break block39;
            }
            if (contentLength >= 0L && (request != null || this._persistent.booleanValue())) {
                this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                HttpGenerator.putContentLength(header, contentLength);
            } else {
                if (response == null) {
                    throw new BadMessageException(500, "Unknown content length for request");
                }
                this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                this._persistent = Boolean.FALSE;
                if (contentLength >= 0L && (contentLength > 0L || assumedContent || contentLengthField)) {
                    HttpGenerator.putContentLength(header, contentLength);
                }
                if (http11 && !close) {
                    header.put(CONNECTION_CLOSE);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._endOfContent.toString(), new Object[0]);
        }
        if (transferEncoding != null) {
            if (chunkedHint) {
                String v = transferEncoding.getValue();
                int c = v.lastIndexOf(44);
                if (c > 0 && v.lastIndexOf(HttpHeaderValue.CHUNKED.toString(), c) > c) {
                    HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, v.substring(0, c).trim()), header);
                }
            } else {
                HttpGenerator.putTo(transferEncoding, header);
            }
        }
        if ((n = response != null ? response.getStatus() : -1) > 199) {
            header.put(SEND[send]);
        }
        var2_2.put(HttpTokens.CRLF);
    }

    /*
     * WARNING - void declaration
     */
    private static void putContentLength(ByteBuffer header, long contentLength) {
        ByteBuffer byteBuffer;
        void var1_1;
        if (contentLength == 0L) {
            header.put(CONTENT_LENGTH_0);
            return;
        }
        header.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
        BufferUtil.putDecLong((ByteBuffer)header, (long)var1_1);
        byteBuffer.put(HttpTokens.CRLF);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getReasonBuffer(int code) {
        PreparedResponse status = code < __preprepared.length ? __preprepared[code] : null;
        if (status != null) {
            void var0_1;
            return var0_1._reason;
        }
        return null;
    }

    public String toString() {
        return String.format("%s@%x{s=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    private static void putSanitisedName(String s, ByteBuffer buffer) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n' || c == ':') {
                buffer.put((byte)63);
                continue;
            }
            buffer.put((byte)(0xFF & c));
        }
    }

    private static void putSanitisedValue(String s, ByteBuffer buffer) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n') {
                buffer.put((byte)32);
                continue;
            }
            buffer.put((byte)(0xFF & c));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void putTo(HttpField field, ByteBuffer bufferInFillMode) {
        void var1_1;
        if (field instanceof PreEncodedHttpField) {
            ((PreEncodedHttpField)field).putTo(bufferInFillMode, HttpVersion.HTTP_1_0);
            return;
        }
        HttpHeader header = field.getHeader();
        if (header != null) {
            void var2_2;
            bufferInFillMode.put(var2_2.getBytesColonSpace());
            HttpGenerator.putSanitisedValue(field.getValue(), bufferInFillMode);
        } else {
            HttpField httpField;
            HttpGenerator.putSanitisedName(field.getName(), bufferInFillMode);
            bufferInFillMode.put(__colon_space);
            HttpGenerator.putSanitisedValue(httpField.getValue(), bufferInFillMode);
        }
        BufferUtil.putCRLF((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void putTo(HttpFields fields, ByteBuffer bufferInFillMode) {
        void var1_1;
        for (HttpField field : fields) {
            void var2_2;
            if (field == null) continue;
            HttpGenerator.putTo((HttpField)var2_2, bufferInFillMode);
        }
        BufferUtil.putCRLF((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        ASSUMED_CONTENT_METHODS.put(HttpMethod.POST.asString(), (Object)Boolean.TRUE);
        ASSUMED_CONTENT_METHODS.put(HttpMethod.PUT.asString(), (Object)Boolean.TRUE);
        ZERO_CHUNK = new byte[]{48, 13, 10};
        LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
        CONTENT_LENGTH_0 = StringUtil.getBytes((String)"Content-Length: 0\r\n");
        CONNECTION_CLOSE = StringUtil.getBytes((String)"Connection: close\r\n");
        HTTP_1_1_SPACE = StringUtil.getBytes((String)((Object)((Object)HttpVersion.HTTP_1_1) + " "));
        TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes((String)"Transfer-Encoding: chunked\r\n");
        SEND = new byte[][]{new byte[0], StringUtil.getBytes((String)"Server: Jetty(9.x.x)\r\n"), StringUtil.getBytes((String)"X-Powered-By: Jetty(9.x.x)\r\n"), StringUtil.getBytes((String)"Server: Jetty(9.x.x)\r\nX-Powered-By: Jetty(9.x.x)\r\n")};
        __preprepared = new PreparedResponse[512];
        int versionLength = HttpVersion.HTTP_1_1.toString().length();
        for (int i = 0; i < __preprepared.length; ++i) {
            void var3_3;
            HttpStatus.Code code = HttpStatus.getCode(i);
            if (code == null) continue;
            String reason = code.getMessage();
            byte[] line = new byte[versionLength + 5 + reason.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(line, 0, versionLength);
            line[versionLength] = 32;
            line[versionLength + 1] = (byte)(48 + i / 100);
            line[versionLength + 2] = (byte)(48 + i % 100 / 10);
            line[versionLength + 3] = (byte)(48 + i % 10);
            line[versionLength + 4] = 32;
            for (int j = 0; j < reason.length(); ++j) {
                line[versionLength + 5 + j] = (byte)reason.charAt(j);
            }
            line[versionLength + 5 + reason.length()] = 13;
            line[versionLength + 6 + var2_2.length()] = 10;
            HttpGenerator.__preprepared[i] = new PreparedResponse();
            HttpGenerator.__preprepared[i]._schemeCode = Arrays.copyOfRange(line, 0, versionLength + 5);
            HttpGenerator.__preprepared[i]._reason = Arrays.copyOfRange(line, versionLength + 5, line.length - 2);
            HttpGenerator.__preprepared[i]._responseLine = var3_3;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        HEADER_OVERFLOW,
        NEED_CHUNK_TRAILER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

