/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedCSVParser;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpFields
implements Iterable<HttpField> {
    @Deprecated
    public static final String __separators = ", \t";
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;
    @Deprecated
    private static final Float __one = new Float("1.0");
    @Deprecated
    private static final Float __zero = new Float("0.0");
    @Deprecated
    private static final Trie<Float> __qualities = new ArrayTernaryTrie();

    public HttpFields() {
        this(16);
    }

    /*
     * WARNING - void declaration
     */
    public HttpFields(int capacity) {
        void var1_1;
        this._fields = new HttpField[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public HttpFields(HttpFields fields) {
        void var1_1;
        this._fields = Arrays.copyOf(fields._fields, fields._fields.length);
        this._size = var1_1._size;
    }

    /*
     * WARNING - void declaration
     */
    public void computeField(HttpHeader header, BiFunction<HttpHeader, List<HttpField>, HttpField> computeFn) {
        void var2_2;
        void var1_1;
        this.computeField(var1_1, (BiFunction)var2_2, (BiFunction)(f, h) -> {
            void var1_1;
            return f.getHeader() == var1_1;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void computeField(String name, BiFunction<String, List<HttpField>, HttpField> computeFn) {
        void var2_2;
        void var1_1;
        this.computeField(var1_1, (BiFunction)var2_2, (BiFunction)HttpField::is);
    }

    /*
     * WARNING - void declaration
     */
    private <T> void computeField(T header, BiFunction<T, List<HttpField>, HttpField> computeFn, BiFunction<HttpField, T, Boolean> matcher) {
        void var1_1;
        void var2_2;
        int first = -1;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!matcher.apply(f, (HttpField)header).booleanValue()) continue;
            first = i;
            break;
        }
        if (first < 0) {
            HttpField newField = computeFn.apply(header, null);
            if (newField != null) {
                this.add(newField);
            }
            return;
        }
        List<Object> found = null;
        for (int i = first + 1; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!matcher.apply(f, (HttpField)header).booleanValue()) continue;
            if (found == null) {
                found = new ArrayList<HttpField>();
                found.add(this._fields[first]);
            }
            found.add(f);
            this.remove(i--);
        }
        HttpField newField = (HttpField)var2_2.apply(var1_1, found = found == null ? Collections.singletonList(this._fields[first]) : Collections.unmodifiableList(found));
        if (newField == null) {
            this.remove(first);
            return;
        }
        this._fields[first] = newField;
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new ListItr();
    }

    public ListIterator<HttpField> listIterator() {
        return new ListItr();
    }

    public Stream<HttpField> stream() {
        return Arrays.stream(this._fields).limit(this._size);
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getFieldNamesCollection() {
        void var1_1;
        HashSet<String> set = null;
        for (int i = 0; i < this._size; ++i) {
            void var3_3;
            HttpField f = this._fields[i];
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(var3_3.getName());
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return var1_1;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    /*
     * WARNING - void declaration
     */
    public HttpField getField(int index) {
        void var1_1;
        if (index >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public HttpField getField(HttpHeader header) {
        for (int i = 0; i < this._size; ++i) {
            void var3_3;
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public HttpField getField(String name) {
        for (int i = 0; i < this._size; ++i) {
            void var3_3;
            HttpField f = this._fields[i];
            if (!f.is(name)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<HttpField> getFields(HttpHeader header) {
        void var2_2;
        ArrayList<HttpField> fields = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            if (fields == null) {
                fields = new ArrayList<HttpField>();
            }
            fields.add(f);
        }
        if (fields == null) {
            return Collections.emptyList();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public List<HttpField> getFields(String name) {
        void var2_2;
        ArrayList<HttpField> fields = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name)) continue;
            if (fields == null) {
                fields = new ArrayList<HttpField>();
            }
            fields.add(f);
        }
        if (fields == null) {
            return Collections.emptyList();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(HttpField field) {
        int i = this._size;
        while (i-- > 0) {
            void var3_3;
            HttpField f = this._fields[i];
            if (!f.isSameName(field) || !f.equals(field) && !var3_3.contains(field.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header, String value) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name, String value) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.is(name) || !f.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header) {
        int i = this._size;
        while (i-- > 0) {
            HttpField httpField = this._fields[i];
            if (httpField.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String name) {
        int i = this._size;
        while (i-- > 0) {
            HttpField httpField = this._fields[i];
            if (!httpField.is(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String getStringField(HttpHeader header) {
        void var1_1;
        return this.get((HttpHeader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String get(HttpHeader header) {
        for (int i = 0; i < this._size; ++i) {
            void var3_3;
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return var3_3.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public String getStringField(String name) {
        void var1_1;
        return this.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String get(String header) {
        for (int i = 0; i < this._size; ++i) {
            void var3_3;
            HttpField f = this._fields[i];
            if (!f.is(header)) continue;
            return var3_3.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getValuesList(HttpHeader header) {
        void var2_2;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            list.add(f.getValue());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getValuesList(String name) {
        void var2_2;
        ArrayList<String> list = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name)) continue;
            if (list == null) {
                list = new ArrayList<String>(this.size() - i);
            }
            list.add(f.getValue());
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addCSV(HttpHeader header, String ... values) {
        void var2_2;
        void var3_3;
        QuotedCSVParser existing = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            if (existing == null) {
                existing = new QuotedCSV(false, new String[0]);
            }
            existing.addValue(f.getValue());
        }
        String value = this.addCSV((QuotedCSV)var3_3, (String[])var2_2);
        if (value != null) {
            void var1_1;
            this.add((HttpHeader)var1_1, value);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addCSV(String name, String ... values) {
        void var2_2;
        void var3_3;
        QuotedCSVParser existing = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name)) continue;
            if (existing == null) {
                existing = new QuotedCSV(false, new String[0]);
            }
            existing.addValue(f.getValue());
        }
        String value = this.addCSV((QuotedCSV)var3_3, (String[])var2_2);
        if (value != null) {
            void var1_1;
            this.add((String)var1_1, value);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected String addCSV(QuotedCSV existing, String ... values) {
        boolean add = true;
        if (existing != null && !existing.isEmpty()) {
            add = false;
            int i = values.length;
            while (i-- > 0) {
                String unquoted = QuotedCSV.unquote(values[i]);
                if (existing.getValues().contains(unquoted)) {
                    values[i] = null;
                    continue;
                }
                add = true;
            }
        }
        if (add) {
            void var2_3;
            StringBuilder value = new StringBuilder();
            for (void v : var2_3) {
                void var3_6;
                if (v == null) continue;
                if (value.length() > 0) {
                    value.append(", ");
                }
                value.append((String)var3_6);
            }
            if (value.length() > 0) {
                return value.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getCSV(HttpHeader header, boolean keepQuotes) {
        void var3_3;
        QuotedCSVParser values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f.getValue());
        }
        if (values == null) {
            return Collections.emptyList();
        }
        return var3_3.getValues();
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getCSV(String name, boolean keepQuotes) {
        void var3_3;
        QuotedCSVParser values = null;
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            if (values == null) {
                values = new QuotedCSV(keepQuotes, new String[0]);
            }
            values.addValue(f.getValue());
        }
        if (values == null) {
            return Collections.emptyList();
        }
        return var3_3.getValues();
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getQualityCSV(HttpHeader header) {
        void var1_1;
        return this.getQualityCSV((HttpHeader)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getQualityCSV(HttpHeader header, ToIntFunction<String> secondaryOrdering) {
        void var3_3;
        QuotedCSVParser values = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values == null) {
                values = new QuotedQualityCSV(secondaryOrdering);
            }
            values.addValue(f.getValue());
        }
        if (values == null) {
            return Collections.emptyList();
        }
        return var3_3.getValues();
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getQualityCSV(String name) {
        void var2_2;
        QuotedQualityCSV values = null;
        for (HttpField f : this) {
            if (!f.is(name)) continue;
            if (values == null) {
                values = new QuotedQualityCSV();
            }
            values.addValue(f.getValue());
        }
        if (values == null) {
            return Collections.emptyList();
        }
        return var2_2.getValues();
    }

    /*
     * WARNING - void declaration
     */
    public Enumeration<String> getValues(String name) {
        int i = 0;
        while (i < this._size) {
            void var2_2;
            HttpField f = this._fields[i];
            if (f.is(name) && f.getValue() != null) {
                void var3_4;
                return new Enumeration<String>(this, (HttpField)var3_4, (int)var2_2, name){
                    HttpField field;
                    int i;
                    final /* synthetic */ HttpField val$f;
                    final /* synthetic */ int val$first;
                    final /* synthetic */ String val$name;
                    final /* synthetic */ HttpFields this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$f = httpField;
                        this.val$first = n;
                        this.val$name = string;
                        this.field = this.val$f;
                        this.i = this.val$first + 1;
                    }

                    @Override
                    public boolean hasMoreElements() {
                        if (this.field == null) {
                            while (this.i < this.this$0._size) {
                                this.field = this.this$0._fields[this.i++];
                                if (!this.field.is(this.val$name) || this.field.getValue() == null) continue;
                                return true;
                            }
                            this.field = null;
                            return false;
                        }
                        return true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public String nextElement() throws NoSuchElementException {
                        if (this.hasMoreElements()) {
                            void var1_1;
                            String value = this.field.getValue();
                            this.field = null;
                            return var1_1;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
            ++var2_2;
        }
        List list = Collections.emptyList();
        return Collections.enumeration(list);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Enumeration<String> getValues(String name, String separators) {
        void var2_2;
        void var1_1;
        Enumeration<String> e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(this, (Enumeration)var1_1, (String)var2_2){
            QuotedStringTokenizer tok = null;
            final /* synthetic */ Enumeration val$e;
            final /* synthetic */ String val$separators;
            final /* synthetic */ HttpFields this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$e = enumeration;
                this.val$separators = string;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (this.val$e.hasMoreElements()) {
                    void var1_1;
                    String value = (String)this.val$e.nextElement();
                    if (value == null) continue;
                    this.tok = new QuotedStringTokenizer((String)var1_1, this.val$separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String nextElement() throws NoSuchElementException {
                void var1_1;
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public void put(HttpField field) {
        void var2_2;
        boolean put = false;
        int i = this._size;
        while (i-- > 0) {
            HttpField httpField = this._fields[i];
            if (!httpField.isSameName(field)) continue;
            if (put) {
                --this._size;
                System.arraycopy(this._fields, i + 1, this._fields, i, this._size - i);
                continue;
            }
            this._fields[i] = field;
            put = true;
        }
        if (var2_2 == false) {
            void var1_1;
            this.add((HttpField)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void put(String name, String value) {
        void var2_2;
        void var1_1;
        if (value == null) {
            this.remove(name);
            return;
        }
        this.put(new HttpField((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void put(HttpHeader header, HttpHeaderValue value) {
        void var2_2;
        void var1_1;
        this.put((HttpHeader)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void put(HttpHeader header, String value) {
        void var2_2;
        void var1_1;
        Objects.requireNonNull(header, "header must not be null");
        if (value == null) {
            this.remove(header);
            return;
        }
        this.put(new HttpField((HttpHeader)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void put(String name, List<String> list) {
        Iterator iterator;
        Objects.requireNonNull(name, "name must not be null");
        this.remove(name);
        if (list == null) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            String v = (String)iterator.next();
            if (v == null) continue;
            this.add(name, (String)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(String name, String value) {
        void var1_1;
        void var2_2;
        if (value == null) {
            return;
        }
        HttpField field = new HttpField(name, (String)var2_2);
        this.add((HttpField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void add(HttpHeader header, HttpHeaderValue value) {
        if (value != null) {
            void var2_2;
            void var1_1;
            this.add((HttpHeader)var1_1, var2_2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(HttpHeader header, String value) {
        void var1_1;
        void var2_2;
        Objects.requireNonNull(header, "header must not be null");
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField field = new HttpField(header, (String)var2_2);
        this.add((HttpField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpField remove(HttpHeader name) {
        void var2_2;
        HttpField removed = null;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != name) continue;
            removed = f;
            this.remove(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public HttpField remove(String name) {
        void var2_2;
        HttpField removed = null;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.is(name)) continue;
            removed = f;
            this.remove(i);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void remove(int i) {
        void var1_1;
        --this._size;
        System.arraycopy(this._fields, i + 1, this._fields, i, this._size - var1_1);
        this._fields[this._size] = null;
    }

    /*
     * WARNING - void declaration
     */
    public long getLongField(String name) throws NumberFormatException {
        void var1_1;
        HttpField field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        return var1_1.getLongValue();
    }

    /*
     * WARNING - void declaration
     */
    public long getDateField(String name) {
        HttpField field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        long date = DateParser.parseDate(val);
        if (date == -1L) {
            void var1_1;
            throw new IllegalArgumentException("Cannot convert date: " + (String)var1_1);
        }
        return date;
    }

    /*
     * WARNING - void declaration
     */
    public void putLongField(HttpHeader name, long value) {
        void var2_3;
        void var1_1;
        String v = Long.toString(value);
        this.put((HttpHeader)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void putLongField(String name, long value) {
        void var2_3;
        void var1_1;
        String v = Long.toString(value);
        this.put((String)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void putDateField(HttpHeader name, long date) {
        void var2_3;
        void var1_1;
        String d = DateGenerator.formatDate(date);
        this.put((HttpHeader)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void putDateField(String name, long date) {
        void var2_3;
        void var1_1;
        String d = DateGenerator.formatDate(date);
        this.put((String)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addDateField(String name, long date) {
        void var2_3;
        void var1_1;
        String d = DateGenerator.formatDate(date);
        this.add((String)var1_1, (String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int hash = 0;
        HttpField[] httpFieldArray = this._fields;
        int n = this._fields.length;
        for (int i = 0; i < n; ++i) {
            HttpField field = httpFieldArray[i];
            hash += field.hashCode();
        }
        return (int)var1_1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpFields)) {
            return false;
        }
        HttpFields that = (HttpFields)o;
        if (this.size() != that.size()) {
            return false;
        }
        block0: for (HttpField fi : this) {
            for (HttpField fa : that) {
                if (fi.equals(fa)) continue block0;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (HttpField field : this) {
                void var3_4;
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = var3_4.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            void var1_2;
            LOG.warn((Throwable)e);
            return var1_2.toString();
        }
    }

    public void clear() {
        this._size = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void add(HttpField field) {
        if (field != null) {
            void var1_1;
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size << 1);
            }
            this._fields[this._size++] = var1_1;
        }
    }

    public void addAll(HttpFields fields) {
        for (int i = 0; i < fields._size; ++i) {
            this.add(fields._fields[i]);
        }
    }

    @Deprecated
    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, values.nextElement());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String stripParameters(String value) {
        void var1_1;
        String string;
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        return string.substring(0, (int)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    public static String valueParameters(String value, Map<String, String> parameters) {
        void var2_2;
        String string;
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (tok1.hasMoreTokens()) {
            String token = tok1.nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!tok2.hasMoreTokens()) continue;
            String paramName = tok2.nextToken();
            String paramVal = null;
            if (tok2.hasMoreTokens()) {
                paramVal = tok2.nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return string.substring(0, (int)var2_2).trim();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Float getQuality(String value) {
        void var1_3;
        Float q;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe < 0 || ++qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (q = (Float)__qualities.get(value, ++qe, value.length() - qe)) != null) {
            return q;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        HttpFields.valueParameters(value, params);
        String qs = (String)params.get("q");
        if (qs == null) {
            qs = "*";
        }
        if ((q = (Float)__qualities.get(qs)) == null) {
            try {
                String string;
                q = new Float(string);
            }
            catch (Exception exception) {
                q = __one;
            }
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static List<String> qualityList(Enumeration<String> e) {
        void var1_1;
        if (e == null || !e.hasMoreElements()) {
            return Collections.emptyList();
        }
        QuotedQualityCSV values = new QuotedQualityCSV();
        while (e.hasMoreElements()) {
            values.addValue(e.nextElement());
        }
        return var1_1.getValues();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(HttpFields x0, int x1) {
        void var1_1;
        x0.remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HttpField[] access$202(HttpFields x0, HttpField[] x1) {
        void var1_1;
        x0._fields = var1_1;
        return x0._fields;
    }

    static {
        __qualities.put("*", (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    private class ListItr
    implements ListIterator<HttpField> {
        int _cursor;
        int _current = -1;

        private ListItr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            if (this._cursor == HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._cursor++;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public void remove() {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            HttpFields.access$300(HttpFields.this, this._current);
            ((HttpFields)HttpFields.this)._fields[((HttpFields)HttpFields.this)._size] = null;
            this._cursor = this._current;
            this._current = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public HttpField previous() {
            if (this._cursor == 0) {
                throw new NoSuchElementException();
            }
            this._current = --this._cursor;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public int nextIndex() {
            return this._cursor;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void set(HttpField field) {
            void var1_1;
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            if (field == null) {
                this.remove();
                return;
            }
            ((HttpFields)HttpFields.this)._fields[this._current] = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(HttpField field) {
            if (field != null) {
                void var1_1;
                HttpFields.access$202(HttpFields.this, Arrays.copyOf(HttpFields.this._fields, HttpFields.this._fields.length + 1));
                System.arraycopy(HttpFields.this._fields, this._cursor, HttpFields.this._fields, this._cursor + 1, HttpFields.this._size - this._cursor);
                ((HttpFields)HttpFields.this)._fields[this._cursor++] = var1_1;
                HttpFields.this._size++;
                this._current = -1;
            }
        }
    }
}

