/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Objects;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.StringUtil;

public class HttpField {
    private static final String ZEROQUALITY = "q=0";
    private final HttpHeader _header;
    private final String _name;
    private final String _value;
    private int hash;

    /*
     * WARNING - void declaration
     */
    public HttpField(HttpHeader header, String name, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.hash = 0;
        this._header = var1_1;
        this._name = this._header != null && name == null ? this._header.asString() : (String)Objects.requireNonNull(var2_2, "name");
        this._value = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public HttpField(HttpHeader header, String value) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((HttpHeader)v0, v0.asString(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpField(HttpHeader header, HttpHeaderValue value) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((HttpHeader)v0, v0.asString(), var2_2.asString());
    }

    /*
     * WARNING - void declaration
     */
    public HttpField(String name, String value) {
        this((HttpHeader)((Object)HttpHeader.CACHE.get(name)), (String)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public String getName() {
        return this._name;
    }

    public String getLowerCaseName() {
        if (this._header != null) {
            return this._header.lowerCaseName();
        }
        return StringUtil.asciiToLowerCase((String)this._name);
    }

    public String getValue() {
        return this._value;
    }

    public int getIntValue() {
        return Integer.parseInt(this._value);
    }

    public long getLongValue() {
        return Long.parseLong(this._value);
    }

    /*
     * WARNING - void declaration
     */
    public String[] getValues() {
        void var1_1;
        if (this._value == null) {
            return null;
        }
        QuotedCSV list = new QuotedCSV(false, this._value);
        return list.getValues().toArray(new String[var1_1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(String search) {
        void var1_1;
        void var3_3;
        if (search == null) {
            return this._value == null;
        }
        if (search.isEmpty()) {
            return false;
        }
        if (this._value == null) {
            return false;
        }
        if (search.equals(this._value)) {
            return true;
        }
        search = StringUtil.asciiToLowerCase((String)search);
        int state = 0;
        int match = 0;
        int param = 0;
        block31: for (int i = 0; i < this._value.length(); ++i) {
            char c = this._value.charAt(i);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            match = 0;
                            state = 2;
                            continue block31;
                        }
                        case ',': {
                            continue block31;
                        }
                        case ';': {
                            param = -1;
                            match = -1;
                            state = 5;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    match = Character.toLowerCase(c) == search.charAt(0) ? 1 : -1;
                    state = 1;
                    continue block31;
                }
                case 1: {
                    switch (c) {
                        case ',': {
                            if (match == search.length()) {
                                return true;
                            }
                            state = 0;
                            continue block31;
                        }
                        case ';': {
                            param = match >= 0 ? 0 : -1;
                            state = 5;
                            continue block31;
                        }
                    }
                    if (match <= 0) continue block31;
                    if (match < search.length()) {
                        match = Character.toLowerCase(c) == search.charAt(match) ? match + 1 : -1;
                        continue block31;
                    }
                    if (c == ' ' || c == '\t') continue block31;
                    match = -1;
                    continue block31;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            state = 3;
                            continue block31;
                        }
                        case '\"': {
                            state = 4;
                            continue block31;
                        }
                    }
                    if (match < 0) continue block31;
                    if (match < search.length()) {
                        match = Character.toLowerCase(c) == search.charAt(match) ? match + 1 : -1;
                        continue block31;
                    }
                    match = -1;
                    continue block31;
                }
                case 3: {
                    if (match >= 0) {
                        match = match < search.length() ? (Character.toLowerCase(c) == search.charAt(match) ? match + 1 : -1) : -1;
                    }
                    state = 2;
                    continue block31;
                }
                case 4: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case ';': {
                            state = 5;
                            continue block31;
                        }
                        case ',': {
                            if (match == search.length()) {
                                return true;
                            }
                            state = 0;
                            continue block31;
                        }
                    }
                    match = -1;
                    continue block31;
                }
                case 5: {
                    switch (c) {
                        case ',': {
                            if (param != 3 && match == search.length()) {
                                return true;
                            }
                            param = 0;
                            state = 0;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    if (param < 0) continue block31;
                    if (param < 3) {
                        param = Character.toLowerCase(c) == ZEROQUALITY.charAt(param) ? param + 1 : -1;
                        continue block31;
                    }
                    if (c == '0' || c == '.') continue block31;
                    param = -1;
                    continue block31;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return param != 3 && var3_3 == var1_1.length();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        String v = this.getValue();
        return this.getName() + ": " + (String)(v == null ? "" : var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSameName(HttpField field) {
        void var1_1;
        if (field == null) {
            return false;
        }
        if (field == this) {
            return true;
        }
        if (this._header != null && this._header == field.getHeader()) {
            return true;
        }
        return this._name.equalsIgnoreCase(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public boolean is(String name) {
        void var1_1;
        return this._name.equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int nameHashCode() {
        void var1_1;
        int h = this.hash;
        int len = this._name.length();
        if (h == 0 && len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = this._name.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                h = h * 31 + c;
            }
            this.hash = h;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int vhc = Objects.hashCode(this._value);
        if (this._header == null) {
            return vhc ^ this.nameHashCode();
        }
        return var1_1 ^ this._header.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpField)) {
            return false;
        }
        HttpField field = (HttpField)o;
        if (this._header != field.getHeader()) {
            return false;
        }
        if (!this._name.equalsIgnoreCase(field.getName())) {
            return false;
        }
        return Objects.equals(this._value, var1_1.getValue());
    }

    public static class LongValueHttpField
    extends HttpField {
        private final long _long;

        /*
         * WARNING - void declaration
         */
        public LongValueHttpField(HttpHeader header, String name, String value, long longValue) {
            super((HttpHeader)var1_1, (String)var2_2, (String)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this._long = longValue;
        }

        /*
         * WARNING - void declaration
         */
        public LongValueHttpField(HttpHeader header, String name, String value) {
            void var2_2;
            void var1_1;
            void var3_3;
            void v0 = var3_3;
            this((HttpHeader)var1_1, (String)var2_2, (String)v0, Long.parseLong((String)v0));
        }

        /*
         * WARNING - void declaration
         */
        public LongValueHttpField(HttpHeader header, String name, long value) {
            this((HttpHeader)var1_1, (String)var2_2, Long.toString(value), (long)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public LongValueHttpField(HttpHeader header, long value) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this((HttpHeader)v0, v0.asString(), (long)var2_2);
        }

        @Override
        public int getIntValue() {
            return (int)this._long;
        }

        @Override
        public long getLongValue() {
            return this._long;
        }
    }

    public static class IntValueHttpField
    extends HttpField {
        private final int _int;

        /*
         * WARNING - void declaration
         */
        public IntValueHttpField(HttpHeader header, String name, String value, int intValue) {
            super((HttpHeader)var1_1, (String)var2_2, (String)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this._int = intValue;
        }

        /*
         * WARNING - void declaration
         */
        public IntValueHttpField(HttpHeader header, String name, String value) {
            void var2_2;
            void var1_1;
            void var3_3;
            void v0 = var3_3;
            this((HttpHeader)var1_1, (String)var2_2, (String)v0, Integer.parseInt((String)v0));
        }

        /*
         * WARNING - void declaration
         */
        public IntValueHttpField(HttpHeader header, String name, int intValue) {
            this((HttpHeader)var1_1, (String)var2_2, Integer.toString(intValue), (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public IntValueHttpField(HttpHeader header, int value) {
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this((HttpHeader)v0, v0.asString(), (int)var2_2);
        }

        @Override
        public int getIntValue() {
            return this._int;
        }

        @Override
        public long getLongValue() {
            return this._int;
        }
    }
}

