/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Destroyable;

public class GZIPContentDecoder
implements Destroyable {
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private final List<ByteBuffer> _inflateds = new ArrayList<ByteBuffer>();
    private final Inflater _inflater = new Inflater(true);
    private final ByteBufferPool _pool;
    private final int _bufferSize;
    private State _state;
    private int _size;
    private long _value;
    private byte _flags;
    private ByteBuffer _inflated;

    public GZIPContentDecoder() {
        this(null, 2048);
    }

    /*
     * WARNING - void declaration
     */
    public GZIPContentDecoder(int bufferSize) {
        this(null, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GZIPContentDecoder(ByteBufferPool pool, int bufferSize) {
        void var1_1;
        void var2_2;
        this._bufferSize = var2_2;
        this._pool = var1_1;
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer decode(ByteBuffer compressed) {
        void var1_3;
        this.decodeChunks(compressed);
        if (this._inflateds.isEmpty()) {
            if (BufferUtil.isEmpty((ByteBuffer)this._inflated) || this._state == State.CRC || this._state == State.ISIZE) {
                return BufferUtil.EMPTY_BUFFER;
            }
            ByteBuffer result = this._inflated;
            this._inflated = null;
            return result;
        }
        this._inflateds.add(this._inflated);
        this._inflated = null;
        int length = this._inflateds.stream().mapToInt(Buffer::remaining).sum();
        ByteBuffer result = this.acquire(length);
        for (ByteBuffer buffer : this._inflateds) {
            void var3_5;
            BufferUtil.append((ByteBuffer)result, (ByteBuffer)buffer);
            this.release((ByteBuffer)var3_5);
        }
        this._inflateds.clear();
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean decodedChunk(ByteBuffer chunk) {
        if (this._inflated == null) {
            this._inflated = chunk;
        } else if (BufferUtil.space((ByteBuffer)this._inflated) >= chunk.remaining()) {
            BufferUtil.append((ByteBuffer)this._inflated, (ByteBuffer)chunk);
            this.release(chunk);
        } else {
            void var1_1;
            this._inflateds.add(this._inflated);
            this._inflated = var1_1;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeChunks(ByteBuffer compressed) {
        ByteBuffer buffer = null;
        try {
            block28: while (true) {
                block47: {
                    switch (this._state) {
                        case INITIAL: {
                            this._state = State.ID;
                            break;
                        }
                        case FLAGS: {
                            if ((this._flags & 4) == 4) {
                                this._state = State.EXTRA_LENGTH;
                                this._size = 0;
                                this._value = 0L;
                                break;
                            }
                            if ((this._flags & 8) == 8) {
                                this._state = State.NAME;
                                break;
                            }
                            if ((this._flags & 0x10) == 16) {
                                this._state = State.COMMENT;
                                break;
                            }
                            if ((this._flags & 2) == 2) {
                                this._state = State.HCRC;
                                this._size = 0;
                                this._value = 0L;
                                break;
                            }
                            this._state = State.DATA;
                            continue block28;
                        }
                        case DATA: {
                            break block47;
                        }
                    }
                    if (compressed.hasRemaining()) {
                        byte currByte = compressed.get();
                        switch (this._state) {
                            case ID: {
                                this._value += (long)((currByte & 0xFF) << 8 * this._size);
                                ++this._size;
                                if (this._size != 2) continue block28;
                                if (this._value != 35615L) {
                                    throw new ZipException("Invalid gzip bytes");
                                }
                                this._state = State.CM;
                                continue block28;
                            }
                            case CM: {
                                if ((currByte & 0xFF) != 8) {
                                    throw new ZipException("Invalid gzip compression method");
                                }
                                this._state = State.FLG;
                                continue block28;
                            }
                            case FLG: {
                                this._flags = currByte;
                                this._state = State.MTIME;
                                this._size = 0;
                                this._value = 0L;
                                continue block28;
                            }
                            case MTIME: {
                                ++this._size;
                                if (this._size != 4) continue block28;
                                this._state = State.XFL;
                                continue block28;
                            }
                            case XFL: {
                                this._state = State.OS;
                                continue block28;
                            }
                            case OS: {
                                this._state = State.FLAGS;
                                continue block28;
                            }
                            case EXTRA_LENGTH: {
                                this._value += (long)((currByte & 0xFF) << 8 * this._size);
                                ++this._size;
                                if (this._size != 2) continue block28;
                                this._state = State.EXTRA;
                                continue block28;
                            }
                            case EXTRA: {
                                --this._value;
                                if (this._value != 0L) continue block28;
                                this._flags = (byte)(this._flags & 0xFFFFFFFB);
                                this._state = State.FLAGS;
                                continue block28;
                            }
                            case NAME: {
                                if (currByte != 0) continue block28;
                                this._flags = (byte)(this._flags & 0xFFFFFFF7);
                                this._state = State.FLAGS;
                                continue block28;
                            }
                            case COMMENT: {
                                if (currByte != 0) continue block28;
                                this._flags = (byte)(this._flags & 0xFFFFFFEF);
                                this._state = State.FLAGS;
                                continue block28;
                            }
                            case HCRC: {
                                ++this._size;
                                if (this._size != 2) continue block28;
                                this._flags = (byte)(this._flags & 0xFFFFFFFD);
                                this._state = State.FLAGS;
                                continue block28;
                            }
                            case CRC: {
                                this._value += (long)((currByte & 0xFF) << 8 * this._size);
                                ++this._size;
                                if (this._size != 4) continue block28;
                                this._state = State.ISIZE;
                                this._size = 0;
                                this._value = 0L;
                                continue block28;
                            }
                            case ISIZE: {
                                this._value |= ((long)currByte & 0xFFL) << 8 * this._size;
                                ++this._size;
                                if (this._size != 4) continue block28;
                                if (this._value != (this._inflater.getBytesWritten() & 0xFFFFFFFFL)) {
                                    throw new ZipException("Invalid input size");
                                }
                                this.reset();
                                if (buffer != null) {
                                    this.release(buffer);
                                }
                                return;
                            }
                        }
                        throw new ZipException();
                    }
                    if (buffer != null) {
                        this.release(buffer);
                        return;
                    }
                    return;
                }
                while (true) {
                    if (buffer == null) {
                        GZIPContentDecoder gZIPContentDecoder = this;
                        buffer = gZIPContentDecoder.acquire(gZIPContentDecoder._bufferSize);
                    }
                    try {
                        int length = this._inflater.inflate(buffer.array(), buffer.arrayOffset(), buffer.capacity());
                        buffer.limit(length);
                    }
                    catch (DataFormatException x) {
                        throw new ZipException(x.getMessage());
                    }
                    if (buffer.hasRemaining()) {
                        ByteBuffer chunk = buffer;
                        buffer = null;
                        if (!this.decodedChunk(chunk)) continue;
                        return;
                    }
                    if (this._inflater.needsInput()) {
                        if (!compressed.hasRemaining()) {
                            if (buffer != null) {
                                this.release(buffer);
                            }
                            return;
                        }
                        if (compressed.hasArray()) {
                            this._inflater.setInput(compressed.array(), compressed.arrayOffset() + compressed.position(), compressed.remaining());
                            ByteBuffer byteBuffer = compressed;
                            byteBuffer.position(byteBuffer.limit());
                            continue;
                        }
                        byte[] input = new byte[compressed.remaining()];
                        compressed.get(input);
                        this._inflater.setInput(input);
                        continue;
                    }
                    if (this._inflater.finished()) break;
                }
                int remaining = this._inflater.getRemaining();
                ByteBuffer byteBuffer = compressed;
                byteBuffer.position(byteBuffer.limit() - remaining);
                this._state = State.CRC;
                this._size = 0;
                this._value = 0L;
            }
        }
        catch (ZipException x) {
            try {
                void var3_8;
                throw new RuntimeException((Throwable)var3_8);
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    void var2_3;
                    this.release((ByteBuffer)var2_3);
                }
                throw throwable;
            }
        }
    }

    private void reset() {
        this._inflater.reset();
        this._state = State.INITIAL;
        this._size = 0;
        this._value = 0L;
        this._flags = 0;
    }

    public void destroy() {
        this._inflater.end();
    }

    public boolean isFinished() {
        return this._state == State.INITIAL;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer acquire(int capacity) {
        void var1_1;
        if (this._pool == null) {
            return BufferUtil.allocate((int)capacity);
        }
        return this._pool.acquire((int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void release(ByteBuffer buffer) {
        if (this._pool != null && !BufferUtil.isTheEmptyBuffer((ByteBuffer)buffer)) {
            void var1_1;
            this._pool.release((ByteBuffer)var1_1);
        }
    }

    private static enum State {
        INITIAL,
        ID,
        CM,
        FLG,
        MTIME,
        XFL,
        OS,
        FLAGS,
        EXTRA_LENGTH,
        EXTRA,
        NAME,
        COMMENT,
        HCRC,
        DATA,
        CRC,
        ISIZE;

    }
}

