/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.util;

public final class Pow2 {
    public static final int MAX_POW2 = 0x40000000;

    public static int roundToPowerOfTwo(int value) {
        int n;
        if (value > 0x40000000) {
            throw new IllegalArgumentException("There is no larger power of 2 int for value:" + value + " since it exceeds 2^31.");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Given value:" + value + ". Expecting value >= 0.");
        }
        n = 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
        return n;
    }

    public static boolean isPowerOfTwo(int value) {
        int n = value;
        return (n & n - 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static long align(long value, int alignment) {
        void var2_1;
        long l;
        if (!Pow2.isPowerOfTwo(alignment)) {
            throw new IllegalArgumentException("alignment must be a power of 2:" + alignment);
        }
        return l + (long)(alignment - 1) & (long)(~(var2_1 - true));
    }
}

