/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueueL3Pad;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscAtomicArrayQueue<E>
extends MpscAtomicArrayQueueL3Pad<E> {
    /*
     * WARNING - void declaration
     */
    public MpscAtomicArrayQueue(int capacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean offerIfBelowThreshold(E e, int threshold) {
        void var1_1;
        void var3_3;
        long pIndex;
        long l;
        if (e == null) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long capacity = mask + 1;
        long producerLimit = this.lvProducerLimit();
        do {
            long available;
            long l2;
            if ((l2 = capacity - (available = producerLimit - (pIndex = this.lvProducerIndex()))) >= (long)threshold) {
                long cIndex = this.lvConsumerIndex();
                l2 = pIndex - cIndex;
                if (l2 >= (long)threshold) {
                    return false;
                }
                producerLimit = cIndex + capacity;
                this.soProducerLimit(producerLimit);
            }
            l = pIndex;
        } while (!this.casProducerIndex(l, l + 1L));
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(pIndex, (long)var3_3);
        AtomicQueueUtil.soRefElement(this.buffer, offset, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_1;
        void var2_2;
        long pIndex;
        long l;
        if (e == null) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long producerLimit = this.lvProducerLimit();
        do {
            if ((pIndex = this.lvProducerIndex()) >= producerLimit) {
                long l2 = this.lvConsumerIndex();
                producerLimit = l2 + (long)mask + 1L;
                if (pIndex >= producerLimit) {
                    return false;
                }
                this.soProducerLimit(producerLimit);
            }
            l = pIndex;
        } while (!this.casProducerIndex(l, l + 1L));
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(pIndex, (long)var2_2);
        AtomicQueueUtil.soRefElement(this.buffer, offset, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int failFastOffer(E e) {
        void var1_1;
        void var2_2;
        long producerLimit;
        if (e == null) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long capacity = mask + 1;
        long pIndex = this.lvProducerIndex();
        if (pIndex >= (producerLimit = this.lvProducerLimit())) {
            void var3_3;
            long l = this.lvConsumerIndex();
            producerLimit = l + var3_3;
            if (pIndex >= producerLimit) {
                return 1;
            }
            this.soProducerLimit(producerLimit);
        }
        long l = pIndex;
        if (!this.casProducerIndex(l, l + 1L)) {
            return -1;
        }
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(pIndex, (long)var2_2);
        AtomicQueueUtil.soRefElement(this.buffer, offset, var1_1);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var1_1;
        void var3_2;
        AtomicReferenceArray buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        AtomicQueueUtil.spRefElement(buffer, (int)var3_2, null);
        this.soConsumerIndex((long)(var1_1 + 1L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E peek() {
        AtomicReferenceArray buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            void var2_2;
            if (var2_2 != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relaxedOffer(E e) {
        void var1_1;
        return this.offer(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPoll() {
        void var2_2;
        void var1_1;
        AtomicReferenceArray buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        AtomicQueueUtil.spRefElement(var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 1L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPeek() {
        void var2_2;
        void var3_3;
        void var1_1;
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        return AtomicQueueUtil.lvRefElement(var1_1, AtomicQueueUtil.calcCircularRefElementOffset((long)var3_3, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = cIndex + (long)i;
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
            Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
            if (e == null) {
                return i;
            }
            AtomicQueueUtil.spRefElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return (int)var2_2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        long pIndex;
        int actualLimit;
        long l;
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        int mask = this.mask;
        long capacity = mask + 1;
        long producerLimit = this.lvProducerLimit();
        do {
            long available;
            if ((available = producerLimit - (pIndex = this.lvProducerIndex())) <= 0L) {
                long l2 = this.lvConsumerIndex();
                producerLimit = l2 + capacity;
                available = producerLimit - pIndex;
                if (available <= 0L) {
                    return 0;
                }
                this.soProducerLimit(producerLimit);
            }
            actualLimit = Math.min((int)available, limit);
            l = pIndex;
        } while (!this.casProducerIndex(l, l + (long)actualLimit));
        AtomicReferenceArray buffer = this.buffer;
        for (int i = 0; i < actualLimit; ++i) {
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(pIndex + (long)i, mask);
            AtomicQueueUtil.soRefElement(buffer, offset, s.get());
        }
        return actualLimit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        void var1_1;
        return this.drain((MessagePassingQueue.Consumer<E>)var1_1, this.capacity());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        void var1_1;
        return MessagePassingQueueUtil.fillBounded(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.drain(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.fill(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public int weakOffer(E e) {
        void var1_1;
        return this.failFastOffer(var1_1);
    }
}

