/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpmcAtomicArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpmcAtomicArrayQueue<E>
extends MpmcAtomicArrayQueueL3Pad<E> {
    public static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.mpmc.max.lookahead.step", 4096);
    private final int lookAheadStep = Math.max(2, Math.min(this.capacity() / 4, MAX_LOOK_AHEAD_STEP));

    /*
     * WARNING - void declaration
     */
    public MpmcAtomicArrayQueue(int capacity) {
        super(RangeUtil.checkGreaterThanOrEqual((int)var1_1, 2, "capacity"));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_1;
        void var2_2;
        long pIndex;
        int seqOffset;
        if (e == null) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long capacity = mask + 1;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        long cIndex = Long.MIN_VALUE;
        while (true) {
            long seq;
            if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(pIndex = this.lvProducerIndex(), mask))) < pIndex) {
                if (pIndex - capacity >= cIndex && pIndex - capacity >= (cIndex = this.lvConsumerIndex())) {
                    return false;
                }
                seq = pIndex + 1L;
            }
            if (seq > pIndex) continue;
            long l = pIndex;
            if (this.casProducerIndex(l, l + 1L)) break;
        }
        AtomicQueueUtil.spRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(pIndex, (long)var2_2), var1_1);
        AtomicQueueUtil.soLongElement(sBuffer, seqOffset, pIndex + 1L);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var2_2;
        void var3_4;
        void var1_1;
        long cIndex;
        int seqOffset;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        long pIndex = -1L;
        while (true) {
            long expectedSeq;
            long seq;
            if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                if (cIndex >= pIndex && cIndex == (pIndex = this.lvProducerIndex())) {
                    return null;
                }
                seq = expectedSeq + 1L;
            }
            if (seq > expectedSeq) continue;
            long l = cIndex;
            if (this.casConsumerIndex(l, l + 1L)) break;
        }
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, mask);
        Object e = AtomicQueueUtil.lpRefElement(this.buffer, offset);
        AtomicQueueUtil.spRefElement(this.buffer, offset, null);
        AtomicQueueUtil.soLongElement((AtomicLongArray)var1_1, seqOffset, (long)(var3_4 + (long)var2_2 + 1L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E peek() {
        Object e;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        long pIndex = -1L;
        while (true) {
            void var3_4;
            long expectedSeq;
            long cIndex;
            int seqOffset;
            long seq;
            if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                if (cIndex < pIndex || cIndex != (pIndex = this.lvProducerIndex())) continue;
                return null;
            }
            if (seq != expectedSeq) continue;
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, mask);
            e = AtomicQueueUtil.lvRefElement(this.buffer, offset);
            if (this.lvConsumerIndex() == var3_4) break;
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relaxedOffer(E e) {
        void var3_3;
        void var1_1;
        void var2_2;
        long pIndex;
        int seqOffset;
        if (e == null) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        while (true) {
            long seq;
            if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(pIndex = this.lvProducerIndex(), mask))) < pIndex) {
                return false;
            }
            if (seq > pIndex) continue;
            long l = pIndex;
            if (this.casProducerIndex(l, l + 1L)) break;
        }
        AtomicQueueUtil.spRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(pIndex, (long)var2_2), var1_1);
        AtomicQueueUtil.soLongElement((AtomicLongArray)var3_3, seqOffset, pIndex + 1L);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPoll() {
        void var2_2;
        void var3_3;
        void var1_1;
        long cIndex;
        int seqOffset;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        while (true) {
            long expectedSeq;
            long seq;
            if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                return null;
            }
            if (seq > expectedSeq) continue;
            long l = cIndex;
            if (this.casConsumerIndex(l, l + 1L)) break;
        }
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, mask);
        Object e = AtomicQueueUtil.lpRefElement(this.buffer, offset);
        AtomicQueueUtil.spRefElement(this.buffer, offset, null);
        AtomicQueueUtil.soLongElement((AtomicLongArray)var1_1, seqOffset, (long)(var3_3 + (long)var2_2 + 1L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPeek() {
        Object e;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        while (true) {
            void var3_3;
            long expectedSeq;
            long cIndex;
            int seqOffset;
            long seq;
            if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                return null;
            }
            if (seq != expectedSeq) continue;
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, mask);
            e = AtomicQueueUtil.lvRefElement(this.buffer, offset);
            if (this.lvConsumerIndex() == var3_3) break;
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        int lookAheadStep;
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        AtomicReferenceArray buffer = this.buffer;
        int maxLookAheadStep = Math.min(this.lookAheadStep, limit);
        for (int consumed = 0; consumed < limit; consumed += lookAheadStep) {
            void var8_8;
            void var1_1;
            void var3_3;
            long expectedLookAheadSeq;
            int remaining = limit - consumed;
            lookAheadStep = Math.min(remaining, maxLookAheadStep);
            long cIndex = this.lvConsumerIndex();
            long lookAheadIndex = cIndex + (long)lookAheadStep - 1L;
            int lookAheadSeqOffset = AtomicQueueUtil.calcCircularLongElementOffset(lookAheadIndex, mask);
            long lookAheadSeq = AtomicQueueUtil.lvLongElement(sBuffer, lookAheadSeqOffset);
            if (lookAheadSeq == (expectedLookAheadSeq = lookAheadIndex + 1L) && this.casConsumerIndex(cIndex, expectedLookAheadSeq)) {
                for (int i = 0; i < lookAheadStep; ++i) {
                    long index = cIndex + (long)i;
                    int seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(index, mask);
                    int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
                    long expectedSeq = index + 1L;
                    while (AtomicQueueUtil.lvLongElement(sBuffer, seqOffset) != expectedSeq) {
                    }
                    Object e = AtomicQueueUtil.lpRefElement(buffer, offset);
                    AtomicQueueUtil.spRefElement(buffer, offset, null);
                    AtomicQueueUtil.soLongElement(sBuffer, seqOffset, index + (long)mask + 1L);
                    c.accept(e);
                }
                continue;
            }
            if (lookAheadSeq < expectedLookAheadSeq && this.notAvailable(cIndex, mask, (AtomicLongArray)var3_3, cIndex + 1L)) {
                return consumed;
            }
            return consumed + this.drainOneByOne((MessagePassingQueue.Consumer<E>)var1_1, (int)var8_8);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int drainOneByOne(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        AtomicReferenceArray buffer = this.buffer;
        for (int i = 0; i < limit; ++i) {
            long cIndex;
            int seqOffset;
            while (true) {
                long expectedSeq;
                long seq;
                if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                    return i;
                }
                if (seq > expectedSeq) continue;
                long l = cIndex;
                if (this.casConsumerIndex(l, l + 1L)) break;
            }
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, mask);
            Object e = AtomicQueueUtil.lpRefElement(buffer, offset);
            AtomicQueueUtil.spRefElement(buffer, offset, null);
            AtomicQueueUtil.soLongElement(sBuffer, seqOffset, cIndex + (long)mask + 1L);
            c.accept(e);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        void var2_2;
        int lookAheadStep;
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        AtomicReferenceArray buffer = this.buffer;
        int maxLookAheadStep = Math.min(this.lookAheadStep, limit);
        for (int produced = 0; produced < limit; produced += lookAheadStep) {
            void var8_8;
            void var1_1;
            void var3_3;
            long expectedLookAheadSeq;
            int remaining = limit - produced;
            lookAheadStep = Math.min(remaining, maxLookAheadStep);
            long pIndex = this.lvProducerIndex();
            long lookAheadIndex = pIndex + (long)lookAheadStep - 1L;
            int lookAheadSeqOffset = AtomicQueueUtil.calcCircularLongElementOffset(lookAheadIndex, mask);
            long lookAheadSeq = AtomicQueueUtil.lvLongElement(sBuffer, lookAheadSeqOffset);
            if (lookAheadSeq == (expectedLookAheadSeq = lookAheadIndex) && this.casProducerIndex(pIndex, expectedLookAheadSeq + 1L)) {
                for (int i = 0; i < lookAheadStep; ++i) {
                    long index = pIndex + (long)i;
                    int seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(index, mask);
                    int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
                    while (AtomicQueueUtil.lvLongElement(sBuffer, seqOffset) != index) {
                    }
                    AtomicQueueUtil.soRefElement(buffer, offset, s.get());
                    AtomicQueueUtil.soLongElement(sBuffer, seqOffset, index + 1L);
                }
                continue;
            }
            if (lookAheadSeq < expectedLookAheadSeq && this.notAvailable(pIndex, mask, (AtomicLongArray)var3_3, pIndex)) {
                return produced;
            }
            return produced + this.fillOneByOne((MessagePassingQueue.Supplier<E>)var1_1, (int)var8_8);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean notAvailable(long index, int mask, AtomicLongArray sBuffer, long expectedSeq) {
        void var1_2;
        void var3_3;
        int seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(index, (int)var3_3);
        long l = AtomicQueueUtil.lvLongElement(sBuffer, (int)var1_2);
        return l < expectedSeq;
    }

    /*
     * WARNING - void declaration
     */
    private int fillOneByOne(MessagePassingQueue.Supplier<E> s, int limit) {
        void var2_2;
        AtomicLongArray sBuffer = this.sequenceBuffer;
        int mask = this.mask;
        AtomicReferenceArray buffer = this.buffer;
        for (int i = 0; i < limit; ++i) {
            long pIndex;
            int seqOffset;
            while (true) {
                long seq;
                if ((seq = AtomicQueueUtil.lvLongElement(sBuffer, seqOffset = AtomicQueueUtil.calcCircularLongElementOffset(pIndex = this.lvProducerIndex(), mask))) < pIndex) {
                    return i;
                }
                if (seq > pIndex) continue;
                long l = pIndex;
                if (this.casProducerIndex(l, l + 1L)) break;
            }
            AtomicQueueUtil.soRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pIndex, mask), s.get());
            AtomicQueueUtil.soLongElement(sBuffer, seqOffset, pIndex + 1L);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        void var1_1;
        return MessagePassingQueueUtil.drain(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        void var1_1;
        return MessagePassingQueueUtil.fillBounded(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.drain(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.fill(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }
}

