/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;

abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    /*
     * WARNING - void declaration
     */
    public BaseMpscLinkedAtomicArrayQueue(int initialCapacity) {
        void var3_3;
        void var1_2;
        RangeUtil.checkGreaterThanOrEqual(initialCapacity, 2, "initialCapacity");
        int p2capacity = Pow2.roundToPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1 << 1;
        AtomicReferenceArray buffer = AtomicQueueUtil.allocateRefArray(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = var1_2;
        this.consumerMask = mask;
        this.soProducerLimit((long)var3_3);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public boolean isEmpty() {
        return (this.lvConsumerIndex() - this.lvProducerIndex()) / 2L == 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_1;
        void var2_2;
        AtomicReferenceArray buffer;
        long pIndex;
        if (e == null) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit2 = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            long mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit2 <= pIndex) {
                int producerLimit2 = this.offerSlowPath(mask, pIndex, producerLimit2);
                switch (producerLimit2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e, null);
                        return true;
                    }
                }
            }
            long l = pIndex;
            if (this.casProducerIndex(l, l + 2L)) break;
        }
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, (long)var2_2);
        AtomicQueueUtil.soRefElement(buffer, offset, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var2_2;
        void var1_1;
        long mask;
        AtomicReferenceArray buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            long pIndex = this.lvProducerIndex();
            if ((cIndex - pIndex) / 2L == 0L) {
                return null;
            }
            while ((e = AtomicQueueUtil.lvRefElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            AtomicReferenceArray nextBuffer = this.nextBuffer(buffer, mask);
            return this.newBufferPoll(nextBuffer, cIndex);
        }
        AtomicQueueUtil.soRefElement((AtomicReferenceArray)var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 2L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E peek() {
        long mask;
        AtomicReferenceArray buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            long pIndex = this.lvProducerIndex();
            if ((cIndex - pIndex) / 2L == 0L) {
                return null;
            }
            while ((e = AtomicQueueUtil.lvRefElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            void var2_2;
            void var1_1;
            BaseMpscLinkedAtomicArrayQueue baseMpscLinkedAtomicArrayQueue = this;
            return baseMpscLinkedAtomicArrayQueue.newBufferPeek(baseMpscLinkedAtomicArrayQueue.nextBuffer((AtomicReferenceArray<E>)var1_1, mask), (long)var2_2);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    private int offerSlowPath(long mask, long pIndex, long producerLimit) {
        void var3_2;
        void var1_1;
        long bufferCapacity;
        long cIndex = this.lvConsumerIndex();
        if (cIndex + (bufferCapacity = this.getCurrentBufferCapacity((long)var1_1)) > pIndex) {
            if (!this.casProducerLimit(producerLimit, cIndex + bufferCapacity)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(pIndex, cIndex) <= 0L) {
            return 2;
        }
        void v0 = var3_2;
        if (this.casProducerIndex((long)v0, (long)(v0 + 1L))) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    /*
     * WARNING - void declaration
     */
    private AtomicReferenceArray<E> nextBuffer(AtomicReferenceArray<E> buffer, long mask) {
        void var3_4;
        void var2_3;
        void var1_1;
        AtomicReferenceArray nextBuffer;
        int offset = BaseMpscLinkedAtomicArrayQueue.nextArrayOffset(mask);
        this.consumerBuffer = nextBuffer = (AtomicReferenceArray)AtomicQueueUtil.lvRefElement(buffer, offset);
        this.consumerMask = AtomicQueueUtil.length(nextBuffer) - 2 << 1;
        AtomicQueueUtil.soRefElement((AtomicReferenceArray)var1_1, (int)var2_3, BUFFER_CONSUMED);
        return var3_4;
    }

    private static int nextArrayOffset(long mask) {
        return AtomicQueueUtil.modifiedCalcCircularRefElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private E newBufferPoll(AtomicReferenceArray<E> nextBuffer, long cIndex) {
        void var2_2;
        void var1_1;
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, this.consumerMask);
        E n = AtomicQueueUtil.lvRefElement(nextBuffer, offset);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        AtomicQueueUtil.soRefElement((AtomicReferenceArray)var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 2L));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private E newBufferPeek(AtomicReferenceArray<E> nextBuffer, long cIndex) {
        void var1_1;
        void var2_3;
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, this.consumerMask);
        E n = AtomicQueueUtil.lvRefElement(nextBuffer, (int)var2_3);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return var1_1;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relaxedOffer(E e) {
        void var1_1;
        return this.offer(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPoll() {
        void var2_2;
        void var1_1;
        long mask;
        AtomicReferenceArray buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            AtomicReferenceArray nextBuffer = this.nextBuffer(buffer, mask);
            return this.newBufferPoll((AtomicReferenceArray<E>)var1_1, cIndex);
        }
        AtomicQueueUtil.soRefElement((AtomicReferenceArray)var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 2L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPeek() {
        long mask;
        AtomicReferenceArray buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (e == JUMP) {
            void var2_2;
            void var1_1;
            BaseMpscLinkedAtomicArrayQueue baseMpscLinkedAtomicArrayQueue = this;
            return baseMpscLinkedAtomicArrayQueue.newBufferPeek(baseMpscLinkedAtomicArrayQueue.nextBuffer((AtomicReferenceArray<E>)var1_1, mask), (long)var2_2);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        void var2_2;
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        void var2_2;
        long batchIndex;
        AtomicReferenceArray buffer;
        long mask;
        long pIndex;
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        block5: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            batchIndex = Math.min(producerLimit, pIndex + 2L * (long)limit);
            if (pIndex >= producerLimit) {
                int n = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (n) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, null, s);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, batchIndex)) break;
        }
        int claimedSlots = (int)((batchIndex - pIndex) / 2L);
        for (int i = 0; i < claimedSlots; ++i) {
            int offset = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(pIndex + 2L * (long)i, mask);
            AtomicQueueUtil.soRefElement(buffer, offset, s.get());
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.fill(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        void var1_1;
        return this.drain((MessagePassingQueue.Consumer<E>)var1_1, this.capacity());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        void var1_1;
        return MessagePassingQueueUtil.drain(this, var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.drain(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    /*
     * WARNING - void declaration
     */
    private void resize(long oldMask, AtomicReferenceArray<E> oldBuffer, long pIndex, E e, MessagePassingQueue.Supplier<E> s) {
        void var3_2;
        void var1_1;
        AtomicReferenceArray newBuffer;
        assert (e != null && s == null || e == null || s != null);
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        try {
            newBuffer = AtomicQueueUtil.allocateRefArray(newBufferLength);
        }
        catch (OutOfMemoryError oom) {
            assert (this.lvProducerIndex() == pIndex + 1L);
            this.soProducerIndex(pIndex);
            throw oom;
        }
        this.producerBuffer = newBuffer;
        void newMask = oom - 2 << 1;
        this.producerMask = (long)newMask;
        int offsetInOld = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, oldMask);
        int offsetInNew = AtomicQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, (long)newMask);
        AtomicQueueUtil.soRefElement(newBuffer, offsetInNew, e == null ? s.get() : e);
        AtomicQueueUtil.soRefElement(oldBuffer, BaseMpscLinkedAtomicArrayQueue.nextArrayOffset((long)var1_1), newBuffer);
        long cIndex = this.lvConsumerIndex();
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        RangeUtil.checkPositive(availableInQueue, "availableInQueue");
        this.soProducerLimit(pIndex + Math.min((long)newMask, availableInQueue));
        this.soProducerIndex(pIndex + 2L);
        AtomicQueueUtil.soRefElement((AtomicReferenceArray)var3_2, offsetInOld, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private long nextIndex;
        private E nextElement;
        private AtomicReferenceArray<E> currentBuffer;
        private int mask;

        /*
         * WARNING - void declaration
         */
        WeakIterator(AtomicReferenceArray<E> currentBuffer, long cIndex, long pIndex) {
            void var1_1;
            void var2_2;
            this.pIndex = pIndex >> 1;
            this.nextIndex = var2_2 >> 1;
            this.setBuffer((AtomicReferenceArray<E>)var1_1);
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E next() {
            void var1_1;
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setBuffer(AtomicReferenceArray<E> buffer) {
            void var1_1;
            this.currentBuffer = buffer;
            this.mask = AtomicQueueUtil.length(var1_1) - 2;
        }

        /*
         * WARNING - void declaration
         */
        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                void var1_1;
                E e;
                long index;
                ++this.nextIndex;
                E e2 = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcCircularRefElementOffset(index, this.mask));
                if (e2 == null) continue;
                if (e2 != JUMP) {
                    return e2;
                }
                int nextBufferIndex = this.mask + 1;
                E nextBuffer = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcRefElementOffset(nextBufferIndex));
                if (nextBuffer == BUFFER_CONSUMED || nextBuffer == null) {
                    return null;
                }
                this.setBuffer((AtomicReferenceArray)e);
                e = AtomicQueueUtil.lvRefElement(this.currentBuffer, AtomicQueueUtil.calcCircularRefElementOffset((long)var1_1, this.mask));
                if (e == null) continue;
                return e;
            }
            return null;
        }
    }
}

