/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.queues.SupportsIterator;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class AtomicReferenceArrayQueue<E>
extends AbstractQueue<E>
implements IndexedQueueSizeUtil.IndexedQueue,
MessagePassingQueue<E>,
QueueProgressIndicators,
SupportsIterator {
    protected final AtomicReferenceArray<E> buffer;
    protected final int mask;

    /*
     * WARNING - void declaration
     */
    public AtomicReferenceArrayQueue(int capacity) {
        void var1_1;
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = new AtomicReferenceArray((int)var1_1);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public final int capacity() {
        return this.mask + 1;
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public final long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public final long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Iterator<E> iterator() {
        void var3_2;
        void var1_1;
        long cIndex = this.lvConsumerIndex();
        long pIndex = this.lvProducerIndex();
        return new WeakIterator<E>((long)var1_1, (long)var3_2, this.mask, this.buffer);
    }

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private final int mask;
        private final AtomicReferenceArray<E> buffer;
        private long nextIndex;
        private E nextElement;

        /*
         * WARNING - void declaration
         */
        WeakIterator(long cIndex, long pIndex, int mask, AtomicReferenceArray<E> buffer) {
            void var3_2;
            void var1_1;
            this.nextIndex = var1_1;
            this.pIndex = var3_2;
            this.mask = mask;
            this.buffer = buffer;
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E next() {
            void var1_1;
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private E getNext() {
            int mask = this.mask;
            AtomicReferenceArray<E> buffer = this.buffer;
            while (this.nextIndex < this.pIndex) {
                void var3_3;
                int offset;
                E e;
                if ((e = AtomicQueueUtil.lvRefElement(buffer, offset = AtomicQueueUtil.calcCircularRefElementOffset(this.nextIndex++, mask))) == null) continue;
                return var3_3;
            }
            return null;
        }
    }
}

