/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpscArrayQueue<E>
extends MpscArrayQueueL3Pad<E> {
    /*
     * WARNING - void declaration
     */
    public MpscArrayQueue(int capacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean offerIfBelowThreshold(E e, int threshold) {
        void var1_1;
        void var3_3;
        long pIndex;
        long l;
        if (e == null) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long producerLimit = this.lvProducerLimit();
        do {
            long available;
            long l2;
            if ((l2 = capacity - (available = producerLimit - (pIndex = this.lvProducerIndex()))) >= (long)threshold) {
                long cIndex = this.lvConsumerIndex();
                l2 = pIndex - cIndex;
                if (l2 >= (long)threshold) {
                    return false;
                }
                producerLimit = cIndex + capacity;
                this.soProducerLimit(producerLimit);
            }
            l = pIndex;
        } while (!this.casProducerIndex(l, l + 1L));
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, (long)var3_3);
        UnsafeRefArrayAccess.soRefElement(this.buffer, offset, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_1;
        void var2_2;
        long pIndex;
        long l;
        if (e == null) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long producerLimit = this.lvProducerLimit();
        do {
            if ((pIndex = this.lvProducerIndex()) >= producerLimit) {
                long l2 = this.lvConsumerIndex();
                producerLimit = l2 + mask + 1L;
                if (pIndex >= producerLimit) {
                    return false;
                }
                this.soProducerLimit(producerLimit);
            }
            l = pIndex;
        } while (!this.casProducerIndex(l, l + 1L));
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, (long)var2_2);
        UnsafeRefArrayAccess.soRefElement(this.buffer, offset, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int failFastOffer(E e) {
        void var1_1;
        void var2_2;
        long producerLimit;
        if (e == null) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long pIndex = this.lvProducerIndex();
        if (pIndex >= (producerLimit = this.lvProducerLimit())) {
            long l = this.lvConsumerIndex();
            producerLimit = l + capacity;
            if (pIndex >= producerLimit) {
                return 1;
            }
            this.soProducerLimit(producerLimit);
        }
        long l = pIndex;
        if (!this.casProducerIndex(l, l + 1L)) {
            return -1;
        }
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, (long)var2_2);
        UnsafeRefArrayAccess.soRefElement(this.buffer, offset, var1_1);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var1_1;
        void var3_2;
        long cIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, this.mask);
        E[] buffer = this.buffer;
        Object e = UnsafeRefArrayAccess.lvRefElement(this.buffer, offset);
        if (e == null) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        UnsafeRefArrayAccess.spRefElement(buffer, (long)var3_2, null);
        this.soConsumerIndex((long)(var1_1 + 1L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E peek() {
        E[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            void var2_2;
            if (var2_2 != this.lvProducerIndex()) {
                while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
                }
            } else {
                return null;
            }
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relaxedOffer(E e) {
        void var1_1;
        return this.offer(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPoll() {
        void var2_2;
        void var1_1;
        E[] buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        UnsafeRefArrayAccess.spRefElement(var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 1L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPeek() {
        void var2_2;
        void var1_1;
        E[] buffer = this.buffer;
        long mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        return UnsafeRefArrayAccess.lvRefElement(var1_1, UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, (long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        E[] buffer = this.buffer;
        long mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = cIndex + (long)i;
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
            Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
            if (e == null) {
                return i;
            }
            UnsafeRefArrayAccess.spRefElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return (int)var2_2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        long pIndex;
        int actualLimit;
        long l;
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long producerLimit = this.lvProducerLimit();
        do {
            long available;
            if ((available = producerLimit - (pIndex = this.lvProducerIndex())) <= 0L) {
                long l2 = this.lvConsumerIndex();
                producerLimit = l2 + capacity;
                available = producerLimit - pIndex;
                if (available <= 0L) {
                    return 0;
                }
                this.soProducerLimit(producerLimit);
            }
            actualLimit = Math.min((int)available, limit);
            l = pIndex;
        } while (!this.casProducerIndex(l, l + (long)actualLimit));
        E[] buffer = this.buffer;
        for (int i = 0; i < actualLimit; ++i) {
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex + (long)i, mask);
            UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
        }
        return actualLimit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        void var1_1;
        return this.drain((MessagePassingQueue.Consumer<E>)var1_1, this.capacity());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        void var1_1;
        return MessagePassingQueueUtil.fillBounded(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.drain(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.fill(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }
}

