/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeLongArrayAccess;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpmcArrayQueue<E>
extends MpmcArrayQueueL3Pad<E> {
    public static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.mpmc.max.lookahead.step", 4096);
    private final int lookAheadStep = Math.max(2, Math.min(this.capacity() / 4, MAX_LOOK_AHEAD_STEP));

    /*
     * WARNING - void declaration
     */
    public MpmcArrayQueue(int capacity) {
        super(RangeUtil.checkGreaterThanOrEqual((int)var1_1, 2, "capacity"));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_1;
        void var2_2;
        long pIndex;
        long seqOffset;
        if (e == null) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long capacity = mask + 1L;
        long[] sBuffer = this.sequenceBuffer;
        long cIndex = Long.MIN_VALUE;
        while (true) {
            long seq;
            if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(pIndex = this.lvProducerIndex(), mask))) < pIndex) {
                if (pIndex - capacity >= cIndex && pIndex - capacity >= (cIndex = this.lvConsumerIndex())) {
                    return false;
                }
                seq = pIndex + 1L;
            }
            if (seq > pIndex) continue;
            long l = pIndex;
            if (this.casProducerIndex(l, l + 1L)) break;
        }
        UnsafeRefArrayAccess.spRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, (long)var2_2), var1_1);
        UnsafeLongArrayAccess.soLongElement(sBuffer, seqOffset, pIndex + 1L);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var2_2;
        void var1_1;
        long cIndex;
        long seqOffset;
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        long pIndex = -1L;
        while (true) {
            long expectedSeq;
            long seq;
            if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                if (cIndex >= pIndex && cIndex == (pIndex = this.lvProducerIndex())) {
                    return null;
                }
                seq = expectedSeq + 1L;
            }
            if (seq > expectedSeq) continue;
            long l = cIndex;
            if (this.casConsumerIndex(l, l + 1L)) break;
        }
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, mask);
        Object e = UnsafeRefArrayAccess.lpRefElement(this.buffer, offset);
        UnsafeRefArrayAccess.spRefElement(this.buffer, offset, null);
        UnsafeLongArrayAccess.soLongElement((long[])var1_1, seqOffset, cIndex + var2_2 + 1L);
        return e;
    }

    @Override
    public E peek() {
        Object e;
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        long pIndex = -1L;
        while (true) {
            long expectedSeq;
            long cIndex;
            long seqOffset;
            long seq;
            if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                if (cIndex < pIndex || cIndex != (pIndex = this.lvProducerIndex())) continue;
                return null;
            }
            if (seq != expectedSeq) continue;
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, mask);
            e = UnsafeRefArrayAccess.lvRefElement(this.buffer, offset);
            if (this.lvConsumerIndex() == cIndex) break;
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relaxedOffer(E e) {
        void var1_1;
        void var2_2;
        long pIndex;
        long seqOffset;
        if (e == null) {
            throw new NullPointerException();
        }
        long mask = this.mask;
        long[] sBuffer = this.sequenceBuffer;
        while (true) {
            long seq;
            if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(pIndex = this.lvProducerIndex(), mask))) < pIndex) {
                return false;
            }
            if (seq > pIndex) continue;
            long l = pIndex;
            if (this.casProducerIndex(l, l + 1L)) break;
        }
        UnsafeRefArrayAccess.spRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, (long)var2_2), var1_1);
        UnsafeLongArrayAccess.soLongElement(sBuffer, seqOffset, pIndex + 1L);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPoll() {
        void var2_2;
        void var1_1;
        long cIndex;
        long seqOffset;
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        while (true) {
            long expectedSeq;
            long seq;
            if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                return null;
            }
            if (seq > expectedSeq) continue;
            long l = cIndex;
            if (this.casConsumerIndex(l, l + 1L)) break;
        }
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, mask);
        Object e = UnsafeRefArrayAccess.lpRefElement(this.buffer, offset);
        UnsafeRefArrayAccess.spRefElement(this.buffer, offset, null);
        UnsafeLongArrayAccess.soLongElement((long[])var1_1, seqOffset, cIndex + var2_2 + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        Object e;
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        while (true) {
            long expectedSeq;
            long cIndex;
            long seqOffset;
            long seq;
            if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                return null;
            }
            if (seq != expectedSeq) continue;
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, mask);
            e = UnsafeRefArrayAccess.lvRefElement(this.buffer, offset);
            if (this.lvConsumerIndex() == cIndex) break;
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        int lookAheadStep;
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        E[] buffer = this.buffer;
        int maxLookAheadStep = Math.min(this.lookAheadStep, limit);
        for (int consumed = 0; consumed < limit; consumed += lookAheadStep) {
            void var9_8;
            void var1_1;
            void var3_3;
            long expectedLookAheadSeq;
            int remaining = limit - consumed;
            lookAheadStep = Math.min(remaining, maxLookAheadStep);
            long cIndex = this.lvConsumerIndex();
            long lookAheadIndex = cIndex + (long)lookAheadStep - 1L;
            long lookAheadSeqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(lookAheadIndex, mask);
            long lookAheadSeq = UnsafeLongArrayAccess.lvLongElement(sBuffer, lookAheadSeqOffset);
            if (lookAheadSeq == (expectedLookAheadSeq = lookAheadIndex + 1L) && this.casConsumerIndex(cIndex, expectedLookAheadSeq)) {
                for (int i = 0; i < lookAheadStep; ++i) {
                    long index = cIndex + (long)i;
                    long seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(index, mask);
                    long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
                    long expectedSeq = index + 1L;
                    while (UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset) != expectedSeq) {
                    }
                    Object e = UnsafeRefArrayAccess.lpRefElement(buffer, offset);
                    UnsafeRefArrayAccess.spRefElement(buffer, offset, null);
                    UnsafeLongArrayAccess.soLongElement(sBuffer, seqOffset, index + mask + 1L);
                    c.accept(e);
                }
                continue;
            }
            if (lookAheadSeq < expectedLookAheadSeq && this.notAvailable(cIndex, mask, (long[])var3_3, cIndex + 1L)) {
                return consumed;
            }
            return consumed + this.drainOneByOne((MessagePassingQueue.Consumer<E>)var1_1, (int)var9_8);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int drainOneByOne(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        E[] buffer = this.buffer;
        for (int i = 0; i < limit; ++i) {
            long cIndex;
            long seqOffset;
            while (true) {
                long expectedSeq;
                long seq;
                if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(cIndex = this.lvConsumerIndex(), mask))) < (expectedSeq = cIndex + 1L)) {
                    return i;
                }
                if (seq > expectedSeq) continue;
                long l = cIndex;
                if (this.casConsumerIndex(l, l + 1L)) break;
            }
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(cIndex, mask);
            Object e = UnsafeRefArrayAccess.lpRefElement(buffer, offset);
            UnsafeRefArrayAccess.spRefElement(buffer, offset, null);
            UnsafeLongArrayAccess.soLongElement(sBuffer, seqOffset, cIndex + mask + 1L);
            c.accept(e);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        void var2_2;
        int lookAheadStep;
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        E[] buffer = this.buffer;
        int maxLookAheadStep = Math.min(this.lookAheadStep, limit);
        for (int produced = 0; produced < limit; produced += lookAheadStep) {
            void var9_8;
            void var1_1;
            void var3_3;
            long expectedLookAheadSeq;
            int remaining = limit - produced;
            lookAheadStep = Math.min(remaining, maxLookAheadStep);
            long pIndex = this.lvProducerIndex();
            long lookAheadIndex = pIndex + (long)lookAheadStep - 1L;
            long lookAheadSeqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(lookAheadIndex, mask);
            long lookAheadSeq = UnsafeLongArrayAccess.lvLongElement(sBuffer, lookAheadSeqOffset);
            if (lookAheadSeq == (expectedLookAheadSeq = lookAheadIndex) && this.casProducerIndex(pIndex, expectedLookAheadSeq + 1L)) {
                for (int i = 0; i < lookAheadStep; ++i) {
                    long index = pIndex + (long)i;
                    long seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(index, mask);
                    long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
                    while (UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset) != index) {
                    }
                    UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
                    UnsafeLongArrayAccess.soLongElement(sBuffer, seqOffset, index + 1L);
                }
                continue;
            }
            if (lookAheadSeq < expectedLookAheadSeq && this.notAvailable(pIndex, mask, (long[])var3_3, pIndex)) {
                return produced;
            }
            return produced + this.fillOneByOne((MessagePassingQueue.Supplier<E>)var1_1, (int)var9_8);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean notAvailable(long index, long mask, long[] sBuffer, long expectedSeq) {
        void var3_2;
        long seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(index, (long)var3_2);
        long l = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset);
        return l < expectedSeq;
    }

    /*
     * WARNING - void declaration
     */
    private int fillOneByOne(MessagePassingQueue.Supplier<E> s, int limit) {
        void var2_2;
        long[] sBuffer = this.sequenceBuffer;
        long mask = this.mask;
        E[] buffer = this.buffer;
        for (int i = 0; i < limit; ++i) {
            long pIndex;
            long seqOffset;
            while (true) {
                long seq;
                if ((seq = UnsafeLongArrayAccess.lvLongElement(sBuffer, seqOffset = UnsafeLongArrayAccess.calcCircularLongElementOffset(pIndex = this.lvProducerIndex(), mask))) < pIndex) {
                    return i;
                }
                if (seq > pIndex) continue;
                long l = pIndex;
                if (this.casProducerIndex(l, l + 1L)) break;
            }
            UnsafeRefArrayAccess.soRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex, mask), s.get());
            UnsafeLongArrayAccess.soLongElement(sBuffer, seqOffset, pIndex + 1L);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        void var1_1;
        return MessagePassingQueueUtil.drain(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        void var1_1;
        return MessagePassingQueueUtil.fillBounded(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.drain(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.fill(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }
}

