/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;

public final class MessagePassingQueueUtil {
    /*
     * WARNING - void declaration
     */
    public static <E> int drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c, int limit) {
        E e;
        int i;
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        for (i = 0; i < limit && (e = queue.relaxedPoll()) != null; ++i) {
            void var3_4;
            c.accept(var3_4);
        }
        return i;
    }

    /*
     * WARNING - void declaration
     */
    public static <E> int drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c) {
        void var3_2;
        E e;
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        int i = 0;
        while ((e = queue.relaxedPoll()) != null) {
            void var2_3;
            ++i;
            c.accept(var2_3);
        }
        return (int)var3_2;
    }

    public static <E> void drain(MessagePassingQueue<E> queue, MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        if (c == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (wait == null) {
            throw new IllegalArgumentException("wait is null");
        }
        if (exit == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int idleCounter = 0;
        while (exit.keepRunning()) {
            E e = queue.relaxedPoll();
            if (e == null) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
            c.accept(e);
        }
    }

    public static <E> void fill(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        if (wait == null) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (exit == null) {
            throw new IllegalArgumentException("exit condition is null");
        }
        int idleCounter = 0;
        while (exit.keepRunning()) {
            if (q.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                idleCounter = wait.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <E> int fillBounded(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s) {
        MessagePassingQueue<E> messagePassingQueue;
        void var1_1;
        return MessagePassingQueueUtil.fillInBatchesToLimit(q, var1_1, PortableJvmInfo.RECOMENDED_OFFER_BATCH, messagePassingQueue.capacity());
    }

    public static <E> int fillInBatchesToLimit(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s, int batch, int limit) {
        int filled;
        long result = 0L;
        do {
            if ((filled = q.fill(s, batch)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)limit);
        return (int)result;
    }

    /*
     * WARNING - void declaration
     */
    public static <E> int fillUnbounded(MessagePassingQueue<E> q, MessagePassingQueue.Supplier<E> s) {
        void var1_1;
        return MessagePassingQueueUtil.fillInBatchesToLimit(q, var1_1, PortableJvmInfo.RECOMENDED_OFFER_BATCH, 4096);
    }
}

