/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

public final class IndexedQueueSizeUtil {
    public static final int PLAIN_DIVISOR = 1;
    public static final int IGNORE_PARITY_DIVISOR = 2;

    public static int size(IndexedQueue iq, int divisor) {
        IndexedQueue indexedQueue;
        long currentProducerIndex;
        long before;
        long after = iq.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = iq.lvProducerIndex();
        } while (before != (after = iq.lvConsumerIndex()));
        long size = (currentProducerIndex - after) / (long)divisor;
        return IndexedQueueSizeUtil.sanitizedSize(indexedQueue.capacity(), size);
    }

    /*
     * WARNING - void declaration
     */
    public static int sanitizedSize(int capacity, long size) {
        void var1_1;
        if (size < 0L) {
            return 0;
        }
        if (capacity != -1 && size > (long)capacity) {
            int n;
            return n;
        }
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)var1_1;
    }

    public static boolean isEmpty(IndexedQueue iq) {
        IndexedQueue indexedQueue;
        return iq.lvConsumerIndex() >= indexedQueue.lvProducerIndex();
    }

    public static interface IndexedQueue {
        public long lvConsumerIndex();

        public long lvProducerIndex();

        public int capacity();
    }
}

