/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final Object BUFFER_CONSUMED = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    /*
     * WARNING - void declaration
     */
    public BaseMpscLinkedArrayQueue(int initialCapacity) {
        void var3_3;
        void var1_2;
        RangeUtil.checkGreaterThanOrEqual(initialCapacity, 2, "initialCapacity");
        int p2capacity = Pow2.roundToPowerOfTwo(initialCapacity);
        long mask = p2capacity - 1 << 1;
        E[] buffer = UnsafeRefArrayAccess.allocateRefArray(p2capacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = var1_2;
        this.consumerMask = mask;
        this.soProducerLimit((long)var3_3);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 2);
    }

    @Override
    public boolean isEmpty() {
        return (this.lvConsumerIndex() - this.lvProducerIndex()) / 2L == 0L;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean offer(E e) {
        void var1_1;
        void var2_2;
        E[] buffer;
        long pIndex;
        if (e == null) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long producerLimit2 = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            long mask = this.producerMask;
            buffer = this.producerBuffer;
            if (producerLimit2 <= pIndex) {
                int producerLimit2 = this.offerSlowPath(mask, pIndex, producerLimit2);
                switch (producerLimit2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, e, null);
                        return true;
                    }
                }
            }
            long l = pIndex;
            if (this.casProducerIndex(l, l + 2L)) break;
        }
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, (long)var2_2);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E poll() {
        void var2_2;
        void var1_1;
        long mask;
        E[] buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            long pIndex = this.lvProducerIndex();
            if ((cIndex - pIndex) / 2L == 0L) {
                return null;
            }
            while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            E[] nextBuffer = this.nextBuffer(buffer, mask);
            return this.newBufferPoll(nextBuffer, cIndex);
        }
        UnsafeRefArrayAccess.soRefElement(var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 2L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E peek() {
        long mask;
        E[] buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            long pIndex = this.lvProducerIndex();
            if ((cIndex - pIndex) / 2L == 0L) {
                return null;
            }
            while ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null) {
            }
        }
        if (e == JUMP) {
            void var2_2;
            void var1_1;
            BaseMpscLinkedArrayQueue baseMpscLinkedArrayQueue = this;
            return baseMpscLinkedArrayQueue.newBufferPeek(baseMpscLinkedArrayQueue.nextBuffer((E[])var1_1, mask), (long)var2_2);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    private int offerSlowPath(long mask, long pIndex, long producerLimit) {
        void var3_2;
        void var1_1;
        long bufferCapacity;
        long cIndex = this.lvConsumerIndex();
        if (cIndex + (bufferCapacity = this.getCurrentBufferCapacity((long)var1_1)) > pIndex) {
            if (!this.casProducerLimit(producerLimit, cIndex + bufferCapacity)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(pIndex, cIndex) <= 0L) {
            return 2;
        }
        void v0 = var3_2;
        if (this.casProducerIndex((long)v0, (long)(v0 + 1L))) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    /*
     * WARNING - void declaration
     */
    private E[] nextBuffer(E[] buffer, long mask) {
        void var2_3;
        void var1_1;
        long offset = BaseMpscLinkedArrayQueue.nextArrayOffset(mask);
        Object[] nextBuffer = (Object[])UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        this.consumerBuffer = nextBuffer;
        this.consumerMask = LinkedArrayQueueUtil.length(nextBuffer) - 2 << 1;
        UnsafeRefArrayAccess.soRefElement(var1_1, offset, BUFFER_CONSUMED);
        return var2_3;
    }

    private static long nextArrayOffset(long mask) {
        return LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(mask + 2L, Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private E newBufferPoll(E[] nextBuffer, long cIndex) {
        void var2_2;
        void var1_1;
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, this.consumerMask);
        E n = UnsafeRefArrayAccess.lvRefElement(nextBuffer, offset);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soRefElement(var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 2L));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private E newBufferPeek(E[] nextBuffer, long cIndex) {
        void var1_1;
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, this.consumerMask);
        E n = UnsafeRefArrayAccess.lvRefElement(nextBuffer, offset);
        if (n == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return var1_1;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean relaxedOffer(E e) {
        void var1_1;
        return this.offer(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPoll() {
        void var2_2;
        void var1_1;
        long mask;
        E[] buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == null) {
            return null;
        }
        if (e == JUMP) {
            E[] nextBuffer = this.nextBuffer(buffer, mask);
            return this.newBufferPoll((E[])var1_1, cIndex);
        }
        UnsafeRefArrayAccess.soRefElement(var1_1, offset, null);
        this.soConsumerIndex((long)(var2_2 + 2L));
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E relaxedPeek() {
        long mask;
        E[] buffer = this.consumerBuffer;
        long cIndex = this.lpConsumerIndex();
        long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(cIndex, mask = this.consumerMask);
        Object e = UnsafeRefArrayAccess.lvRefElement(buffer, offset);
        if (e == JUMP) {
            void var2_2;
            void var1_1;
            BaseMpscLinkedArrayQueue baseMpscLinkedArrayQueue = this;
            return baseMpscLinkedArrayQueue.newBufferPeek(baseMpscLinkedArrayQueue.nextBuffer((E[])var1_1, mask), (long)var2_2);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        void var2_2;
        int filled;
        long result = 0L;
        int capacity = this.capacity();
        do {
            if ((filled = this.fill(s, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)result;
        } while ((result += (long)filled) <= (long)capacity);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        void var2_2;
        long batchIndex;
        E[] buffer;
        long mask;
        long pIndex;
        if (s == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        block5: while (true) {
            long producerLimit = this.lvProducerLimit();
            pIndex = this.lvProducerIndex();
            if ((pIndex & 1L) == 1L) continue;
            mask = this.producerMask;
            buffer = this.producerBuffer;
            batchIndex = Math.min(producerLimit, pIndex + 2L * (long)limit);
            if (pIndex >= producerLimit) {
                int n = this.offerSlowPath(mask, pIndex, producerLimit);
                switch (n) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(mask, buffer, pIndex, null, s);
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(pIndex, batchIndex)) break;
        }
        int claimedSlots = (int)((batchIndex - pIndex) / 2L);
        for (int i = 0; i < claimedSlots; ++i) {
            long offset = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex + 2L * (long)i, mask);
            UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.fill(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        void var1_1;
        return this.drain((MessagePassingQueue.Consumer<E>)var1_1, this.capacity());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        void var2_2;
        void var1_1;
        return MessagePassingQueueUtil.drain(this, var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        void var3_3;
        void var2_2;
        void var1_1;
        MessagePassingQueueUtil.drain(this, var1_1, (MessagePassingQueue.WaitStrategy)var2_2, (MessagePassingQueue.ExitCondition)var3_3);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakIterator(this.consumerBuffer, this.lvConsumerIndex(), this.lvProducerIndex());
    }

    /*
     * WARNING - void declaration
     */
    private void resize(long oldMask, E[] oldBuffer, long pIndex, E e, MessagePassingQueue.Supplier<E> s) {
        void var3_2;
        void var1_1;
        E[] newBuffer;
        assert (e != null && s == null || e == null || s != null);
        int newBufferLength = this.getNextBufferSize(oldBuffer);
        try {
            newBuffer = UnsafeRefArrayAccess.allocateRefArray(newBufferLength);
        }
        catch (OutOfMemoryError oom) {
            assert (this.lvProducerIndex() == pIndex + 1L);
            this.soProducerIndex(pIndex);
            throw oom;
        }
        this.producerBuffer = newBuffer;
        void newMask = oom - 2 << 1;
        this.producerMask = (long)newMask;
        long offsetInOld = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, oldMask);
        long offsetInNew = LinkedArrayQueueUtil.modifiedCalcCircularRefElementOffset(pIndex, (long)newMask);
        UnsafeRefArrayAccess.soRefElement(newBuffer, offsetInNew, e == null ? s.get() : e);
        UnsafeRefArrayAccess.soRefElement(oldBuffer, BaseMpscLinkedArrayQueue.nextArrayOffset((long)var1_1), newBuffer);
        long cIndex = this.lvConsumerIndex();
        long availableInQueue = this.availableInQueue(pIndex, cIndex);
        RangeUtil.checkPositive(availableInQueue, "availableInQueue");
        this.soProducerLimit(pIndex + Math.min((long)newMask, availableInQueue));
        this.soProducerIndex(pIndex + 2L);
        UnsafeRefArrayAccess.soRefElement(var3_2, offsetInOld, JUMP);
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);

    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private long nextIndex;
        private E nextElement;
        private E[] currentBuffer;
        private int mask;

        /*
         * WARNING - void declaration
         */
        WeakIterator(E[] currentBuffer, long cIndex, long pIndex) {
            void var1_1;
            void var2_2;
            this.pIndex = pIndex >> 1;
            this.nextIndex = var2_2 >> 1;
            this.setBuffer((E[])var1_1);
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E next() {
            void var1_1;
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setBuffer(E[] buffer) {
            void var1_1;
            this.currentBuffer = buffer;
            this.mask = LinkedArrayQueueUtil.length((Object[])var1_1) - 2;
        }

        /*
         * WARNING - void declaration
         */
        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                void var1_1;
                E e;
                long index;
                ++this.nextIndex;
                E e2 = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(index, this.mask));
                if (e2 == null) continue;
                if (e2 != JUMP) {
                    return e2;
                }
                int nextBufferIndex = this.mask + 1;
                E nextBuffer = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcRefElementOffset(nextBufferIndex));
                if (nextBuffer == BUFFER_CONSUMED || nextBuffer == null) {
                    return null;
                }
                this.setBuffer((Object[])e);
                e = UnsafeRefArrayAccess.lvRefElement(this.currentBuffer, UnsafeRefArrayAccess.calcCircularRefElementOffset((long)var1_1, this.mask));
                if (e == null) continue;
                return e;
            }
            return null;
        }
    }
}

