/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.FormattingTuple;
import java.util.HashSet;
import java.util.Set;

public final class MessageFormatter {
    private static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    /*
     * WARNING - void declaration
     */
    public static FormattingTuple format(String messagePattern, Object arg) {
        void var1_1;
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static FormattingTuple format(String messagePattern, Object argA, Object argB) {
        void var2_2;
        void var1_1;
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{var1_1, var2_2});
    }

    /*
     * WARNING - void declaration
     */
    public static FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        void var3_3;
        void var2_2;
        String string;
        Throwable throwable;
        if (argArray == null || argArray.length == 0) {
            return new FormattingTuple(messagePattern, null);
        }
        int lastArrIdx = argArray.length - 1;
        Object lastEntry = argArray[lastArrIdx];
        Throwable throwable2 = throwable = lastEntry instanceof Throwable ? (Throwable)lastEntry : null;
        if (messagePattern == null) {
            return new FormattingTuple(null, throwable);
        }
        int j = messagePattern.indexOf(DELIM_STR);
        if (j == -1) {
            return new FormattingTuple(messagePattern, throwable);
        }
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        int i = 0;
        int L = 0;
        do {
            boolean notEscaped;
            if (notEscaped = j == 0 || messagePattern.charAt(j - 1) != '\\') {
                sbuf.append(messagePattern, i, j);
            } else {
                sbuf.append(messagePattern, i, j - 1);
                notEscaped = j >= 2 && messagePattern.charAt(j - 2) == '\\';
            }
            i = j + 2;
            if (notEscaped) {
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], null);
                if (++L <= lastArrIdx) continue;
                break;
            }
            sbuf.append(DELIM_STR);
        } while ((j = messagePattern.indexOf(DELIM_STR, i)) != -1);
        sbuf.append(messagePattern, i, string.length());
        return new FormattingTuple(sbuf.toString(), (Throwable)(L <= var2_2 ? var3_3 : null));
    }

    /*
     * WARNING - void declaration
     */
    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Set<Object[]> seenSet) {
        StringBuilder stringBuilder;
        void var3_3;
        if (o == null) {
            sbuf.append("null");
            return;
        }
        Class<?> objClass = o.getClass();
        if (!objClass.isArray()) {
            if (Number.class.isAssignableFrom(objClass)) {
                if (objClass == Long.class) {
                    sbuf.append((Long)o);
                    return;
                }
                if (objClass == Integer.class || objClass == Short.class || objClass == Byte.class) {
                    sbuf.append(((Number)o).intValue());
                    return;
                }
                if (objClass == Double.class) {
                    sbuf.append((Double)o);
                    return;
                }
                if (objClass == Float.class) {
                    sbuf.append(((Float)o).floatValue());
                    return;
                }
                MessageFormatter.safeObjectAppend(sbuf, o);
                return;
            }
            MessageFormatter.safeObjectAppend(sbuf, o);
            return;
        }
        sbuf.append('[');
        if (objClass == boolean[].class) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (objClass == byte[].class) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o);
        } else if (objClass == char[].class) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o);
        } else if (objClass == short[].class) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o);
        } else if (objClass == int[].class) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o);
        } else if (objClass == long[].class) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o);
        } else if (objClass == float[].class) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o);
        } else if (var3_3 == double[].class) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o);
        } else {
            void var2_2;
            void var1_1;
            MessageFormatter.objectArrayAppend(sbuf, (Object[])var1_1, (Set<Object[]>)var2_2);
        }
        stringBuilder.append(']');
    }

    /*
     * WARNING - void declaration
     */
    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
            return;
        }
        catch (Throwable t) {
            StringBuilder stringBuilder;
            void var2_3;
            void var1_1;
            System.err.println("SLF4J: Failed toString() invocation on an object of type [" + var1_1.getClass().getName() + ']');
            var2_3.printStackTrace();
            stringBuilder.append("[FAILED toString()]");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Set<Object[]> seenSet) {
        StringBuilder stringBuilder;
        if (a.length == 0) {
            return;
        }
        if (seenSet == null) {
            seenSet = new HashSet<Object[]>(a.length);
        }
        if (seenSet.add(a)) {
            void var1_1;
            void var2_2;
            MessageFormatter.deeplyAppendParameter(sbuf, a[0], seenSet);
            for (int i = 1; i < a.length; ++i) {
                sbuf.append(", ");
                MessageFormatter.deeplyAppendParameter(sbuf, a[i], seenSet);
            }
            var2_2.remove(var1_1);
            return;
        }
        stringBuilder.append("...");
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        if (a.length == 0) {
            return;
        }
        sbuf.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            sbuf.append(", ");
            sbuf.append(a[i]);
        }
    }

    private MessageFormatter() {
    }
}

