/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.FormattingTuple;
import io.netty.util.internal.logging.MessageFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Log4JLogger
extends AbstractInternalLogger {
    private static final long serialVersionUID = 2851357342488183058L;
    final transient Logger logger;
    static final String FQCN = Log4JLogger.class.getName();
    final boolean traceCapable;

    /*
     * WARNING - void declaration
     */
    Log4JLogger(Logger logger) {
        super(logger.getName());
        void var1_1;
        this.logger = var1_1;
        this.traceCapable = this.isTraceCapable();
    }

    private boolean isTraceCapable() {
        try {
            this.logger.isTraceEnabled();
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.traceCapable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String msg) {
        void var1_1;
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object argA, Object argB) {
        if (this.isTraceEnabled()) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)var1_1, (Throwable)var2_2);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg) {
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object argA, Object argB) {
        if (this.logger.isDebugEnabled()) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logger.isDebugEnabled()) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)var1_1, (Throwable)var2_2);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg) {
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object argA, Object argB) {
        if (this.logger.isInfoEnabled()) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object ... argArray) {
        if (this.logger.isInfoEnabled()) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)var1_1, (Throwable)var2_2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg) {
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object argA, Object argB) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)var1_1, (Throwable)var2_2);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg) {
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object argA, Object argB) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)var1_1, (Throwable)var2_2);
    }
}

