/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.FormattingTuple;
import io.netty.util.internal.logging.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class JdkLogger
extends AbstractInternalLogger {
    private static final long serialVersionUID = -1767272577989225979L;
    final transient Logger logger;
    static final String SELF = JdkLogger.class.getName();
    static final String SUPER = AbstractInternalLogger.class.getName();

    /*
     * WARNING - void declaration
     */
    JdkLogger(Logger logger) {
        super(logger.getName());
        void var1_1;
        this.logger = var1_1;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String msg) {
        if (this.logger.isLoggable(Level.FINEST)) {
            void var1_1;
            this.log(SELF, Level.FINEST, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINEST)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.log(SELF, Level.FINEST, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object argA, Object argB) {
        if (this.logger.isLoggable(Level.FINEST)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.log(SELF, Level.FINEST, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object ... argArray) {
        if (this.logger.isLoggable(Level.FINEST)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.log(SELF, Level.FINEST, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINEST)) {
            void var2_2;
            void var1_1;
            this.log(SELF, Level.FINEST, (String)var1_1, (Throwable)var2_2);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg) {
        if (this.logger.isLoggable(Level.FINE)) {
            void var1_1;
            this.log(SELF, Level.FINE, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINE)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.log(SELF, Level.FINE, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object argA, Object argB) {
        if (this.logger.isLoggable(Level.FINE)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.log(SELF, Level.FINE, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object ... argArray) {
        if (this.logger.isLoggable(Level.FINE)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.log(SELF, Level.FINE, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINE)) {
            void var2_2;
            void var1_1;
            this.log(SELF, Level.FINE, (String)var1_1, (Throwable)var2_2);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg) {
        if (this.logger.isLoggable(Level.INFO)) {
            void var1_1;
            this.log(SELF, Level.INFO, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object arg) {
        if (this.logger.isLoggable(Level.INFO)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.log(SELF, Level.INFO, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object argA, Object argB) {
        if (this.logger.isLoggable(Level.INFO)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.log(SELF, Level.INFO, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object ... argArray) {
        if (this.logger.isLoggable(Level.INFO)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.log(SELF, Level.INFO, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.INFO)) {
            void var2_2;
            void var1_1;
            this.log(SELF, Level.INFO, (String)var1_1, (Throwable)var2_2);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            void var1_1;
            this.log(SELF, Level.WARNING, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.log(SELF, Level.WARNING, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object argA, Object argB) {
        if (this.logger.isLoggable(Level.WARNING)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.log(SELF, Level.WARNING, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object ... argArray) {
        if (this.logger.isLoggable(Level.WARNING)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.log(SELF, Level.WARNING, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.WARNING)) {
            void var2_2;
            void var1_1;
            this.log(SELF, Level.WARNING, (String)var1_1, (Throwable)var2_2);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            void var1_1;
            this.log(SELF, Level.SEVERE, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object arg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2);
            this.log(SELF, Level.SEVERE, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object argA, Object argB) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            void var1_1;
            void var3_3;
            void var2_2;
            FormattingTuple ft = MessageFormatter.format(format, var2_2, var3_3);
            this.log(SELF, Level.SEVERE, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object ... arguments) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            void var1_1;
            void var2_2;
            FormattingTuple ft = MessageFormatter.arrayFormat(format, (Object[])var2_2);
            this.log(SELF, Level.SEVERE, ft.getMessage(), var1_1.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            void var2_2;
            void var1_1;
            this.log(SELF, Level.SEVERE, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void log(String callerFQCN, Level level, String msg, Throwable t) {
        void var2_2;
        void var1_1;
        void var3_3;
        LogRecord record = new LogRecord(level, (String)var3_3);
        record.setLoggerName(this.name());
        record.setThrown(t);
        JdkLogger.fillCallerData((String)var1_1, record);
        this.logger.log((LogRecord)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(SUPER)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            void var3_4;
            String className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || var3_4.equals(SUPER)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            void var1_1;
            void var2_2;
            void ste = var2_2[found];
            record.setSourceClassName(ste.getClassName());
            var1_1.setSourceMethodName(ste.getMethodName());
        }
    }
}

