/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.JdkLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    /*
     * WARNING - void declaration
     */
    private static InternalLoggerFactory newDefaultFactory(String name) {
        String string;
        InternalLoggerFactory f = InternalLoggerFactory.useSlf4JLoggerFactory(name);
        if (f != null) {
            return f;
        }
        f = InternalLoggerFactory.useLog4J2LoggerFactory(name);
        if (f != null) {
            return f;
        }
        f = InternalLoggerFactory.useLog4JLoggerFactory(name);
        if (f != null) {
            void var1_1;
            return var1_1;
        }
        return InternalLoggerFactory.useJdkLoggerFactory(string);
    }

    /*
     * WARNING - void declaration
     */
    private static InternalLoggerFactory useSlf4JLoggerFactory(String name) {
        try {
            void var1_1;
            String string;
            InternalLoggerFactory f = Slf4JLoggerFactory.getInstanceWithNopCheck();
            f.newInstance(string).debug("Using SLF4J as the default logging framework");
            return var1_1;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static InternalLoggerFactory useLog4J2LoggerFactory(String name) {
        try {
            void var1_1;
            String string;
            InternalLoggerFactory f = Log4J2LoggerFactory.INSTANCE;
            f.newInstance(string).debug("Using Log4J2 as the default logging framework");
            return var1_1;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static InternalLoggerFactory useLog4JLoggerFactory(String name) {
        try {
            void var1_1;
            String string;
            InternalLoggerFactory f = Log4JLoggerFactory.INSTANCE;
            f.newInstance(string).debug("Using Log4J as the default logging framework");
            return var1_1;
        }
        catch (LinkageError linkageError) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static InternalLoggerFactory useJdkLoggerFactory(String name) {
        void var1_1;
        String string;
        InternalLoggerFactory f = JdkLoggerFactory.INSTANCE;
        f.newInstance(string).debug("Using java.util.logging as the default logging framework");
        return var1_1;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        InternalLoggerFactory.defaultFactory = ObjectUtil.checkNotNull(defaultFactory, "defaultFactory");
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name) {
        String string;
        return InternalLoggerFactory.getDefaultFactory().newInstance(string);
    }

    protected abstract InternalLogger newInstance(String var1);
}

