/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class AbstractInternalLogger
implements InternalLogger,
Serializable {
    private static final long serialVersionUID = -6382972526573193470L;
    static final String EXCEPTION_MESSAGE = "Unexpected exception:";
    private final String name;

    /*
     * WARNING - void declaration
     */
    protected AbstractInternalLogger(String name) {
        void var1_1;
        this.name = (String)ObjectUtil.checkNotNull(var1_1, "name");
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEnabled(InternalLogLevel level) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                return this.isTraceEnabled();
            }
            case 2: {
                return this.isDebugEnabled();
            }
            case 3: {
                return this.isInfoEnabled();
            }
            case 4: {
                return this.isWarnEnabled();
            }
            case 5: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Throwable t) {
        void var1_1;
        this.trace(EXCEPTION_MESSAGE, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Throwable t) {
        void var1_1;
        this.debug(EXCEPTION_MESSAGE, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Throwable t) {
        void var1_1;
        this.info(EXCEPTION_MESSAGE, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Throwable t) {
        void var1_1;
        this.warn(EXCEPTION_MESSAGE, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Throwable t) {
        void var1_1;
        this.error(EXCEPTION_MESSAGE, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(InternalLogLevel level, String msg, Throwable cause) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                this.trace(msg, cause);
                return;
            }
            case 2: {
                this.debug(msg, cause);
                return;
            }
            case 3: {
                this.info(msg, cause);
                return;
            }
            case 4: {
                this.warn(msg, cause);
                return;
            }
            case 5: {
                void var3_3;
                void var2_2;
                this.error((String)var2_2, (Throwable)var3_3);
                return;
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(InternalLogLevel level, Throwable cause) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                this.trace(cause);
                return;
            }
            case 2: {
                this.debug(cause);
                return;
            }
            case 3: {
                this.info(cause);
                return;
            }
            case 4: {
                this.warn(cause);
                return;
            }
            case 5: {
                void var2_2;
                this.error((Throwable)var2_2);
                return;
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(InternalLogLevel level, String msg) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                this.trace(msg);
                return;
            }
            case 2: {
                this.debug(msg);
                return;
            }
            case 3: {
                this.info(msg);
                return;
            }
            case 4: {
                this.warn(msg);
                return;
            }
            case 5: {
                void var2_2;
                this.error((String)var2_2);
                return;
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(InternalLogLevel level, String format, Object arg) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                this.trace(format, arg);
                return;
            }
            case 2: {
                this.debug(format, arg);
                return;
            }
            case 3: {
                this.info(format, arg);
                return;
            }
            case 4: {
                this.warn(format, arg);
                return;
            }
            case 5: {
                void var3_3;
                void var2_2;
                this.error((String)var2_2, (Object)var3_3);
                return;
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(InternalLogLevel level, String format, Object argA, Object argB) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                this.trace(format, argA, argB);
                return;
            }
            case 2: {
                this.debug(format, argA, argB);
                return;
            }
            case 3: {
                this.info(format, argA, argB);
                return;
            }
            case 4: {
                this.warn(format, argA, argB);
                return;
            }
            case 5: {
                void var3_3;
                void var2_2;
                this.error((String)var2_2, (Object)var3_3, argB);
                return;
            }
        }
        throw new Error();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void log(InternalLogLevel level, String format, Object ... arguments) {
        void var1_1;
        switch (1.$SwitchMap$io$netty$util$internal$logging$InternalLogLevel[var1_1.ordinal()]) {
            case 1: {
                this.trace(format, arguments);
                return;
            }
            case 2: {
                this.debug(format, arguments);
                return;
            }
            case 3: {
                this.info(format, arguments);
                return;
            }
            case 4: {
                this.warn(format, arguments);
                return;
            }
            case 5: {
                void var3_3;
                void var2_2;
                this.error((String)var2_2, (Object[])var3_3);
                return;
            }
        }
        throw new Error();
    }

    protected Object readResolve() throws ObjectStreamException {
        return InternalLoggerFactory.getInstance(this.name());
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

