/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeParameterMatcher {
    private static final TypeParameterMatcher NOOP = new TypeParameterMatcher(){

        @Override
        public final boolean match(Object msg) {
            return true;
        }
    };

    /*
     * WARNING - void declaration
     */
    public static TypeParameterMatcher get(Class<?> parameterType) {
        void var2_2;
        Map<Class<?>, TypeParameterMatcher> getCache = InternalThreadLocalMap.get().typeParameterMatcherGetCache();
        TypeParameterMatcher matcher = getCache.get(parameterType);
        if (matcher == null) {
            Class<?> clazz;
            void var1_1;
            matcher = parameterType == Object.class ? NOOP : new ReflectiveMatcher(parameterType);
            var1_1.put(clazz, matcher);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static TypeParameterMatcher find(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        void var3_3;
        TypeParameterMatcher matcher;
        Class<?> thisClass;
        Map<Class<?>, Map<String, TypeParameterMatcher>> findCache = InternalThreadLocalMap.get().typeParameterMatcherFindCache();
        Map<String, TypeParameterMatcher> map = findCache.get(thisClass = object.getClass());
        if (map == null) {
            map = new HashMap<String, TypeParameterMatcher>();
            findCache.put(thisClass, map);
        }
        if ((matcher = map.get(typeParamName)) == null) {
            void var2_2;
            void var1_1;
            Object object2;
            matcher = TypeParameterMatcher.get(TypeParameterMatcher.find0(object2, var1_1, typeParamName));
            map.put((String)var2_2, matcher);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> find0(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        void var2_2;
        Class<?> clazz;
        Class<?> thisClass;
        Class<?> currentClass = thisClass = object.getClass();
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParamName.equals(typeParams[i].getName())) continue;
                    typeParamIndex = i;
                    break;
                }
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + parametrizedSuperclass);
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                parametrizedSuperclass = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = parametrizedSuperclass[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class)actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    Class clazz2;
                    TypeVariable v = (TypeVariable)((Object)clazz2);
                    if (!(v.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    currentClass = thisClass;
                    clazz2 = (Class)v.getGenericDeclaration();
                    typeParamName = v.getName();
                    if (clazz2.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return TypeParameterMatcher.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return TypeParameterMatcher.fail(clazz, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> fail(Class<?> type, String typeParamName) {
        Class<?> clazz;
        void var1_1;
        throw new IllegalStateException("cannot determine the type of the type parameter '" + (String)var1_1 + "': " + clazz);
    }

    public abstract boolean match(Object var1);

    TypeParameterMatcher() {
    }

    private static final class ReflectiveMatcher
    extends TypeParameterMatcher {
        private final Class<?> type;

        /*
         * WARNING - void declaration
         */
        ReflectiveMatcher(Class<?> type) {
            void var1_1;
            this.type = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean match(Object msg) {
            void var1_1;
            return this.type.isInstance(var1_1);
        }
    }
}

