/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadLocalRandom
extends Random {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ThreadLocalRandom.class);
    private static final AtomicLong seedUniquifier = new AtomicLong();
    private static volatile long initialSeedUniquifier = SystemPropertyUtil.getLong("io.netty.initialSeedUniquifier", 0L);
    private static final Thread seedGeneratorThread;
    private static final BlockingQueue<Long> seedQueue;
    private static final long seedGeneratorStartTime;
    private static volatile long seedGeneratorEndTime;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long rnd;
    boolean initialized = true;
    private long pad0;
    private long pad1;
    private long pad2;
    private long pad3;
    private long pad4;
    private long pad5;
    private long pad6;
    private long pad7;
    private static final long serialVersionUID = -5851777807851030925L;

    public static void setInitialSeedUniquifier(long initialSeedUniquifier) {
        ThreadLocalRandom.initialSeedUniquifier = initialSeedUniquifier;
    }

    /*
     * WARNING - void declaration
     */
    public static long getInitialSeedUniquifier() {
        long initialSeedUniquifier = ThreadLocalRandom.initialSeedUniquifier;
        if (initialSeedUniquifier != 0L) {
            return initialSeedUniquifier;
        }
        Class<ThreadLocalRandom> clazz = ThreadLocalRandom.class;
        synchronized (ThreadLocalRandom.class) {
            void var0;
            boolean interrupted;
            block10: {
                long waitTime;
                initialSeedUniquifier = ThreadLocalRandom.initialSeedUniquifier;
                if (initialSeedUniquifier != 0L) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return initialSeedUniquifier;
                }
                long deadLine = seedGeneratorStartTime + TimeUnit.SECONDS.toNanos(3L);
                interrupted = false;
                do {
                    waitTime = deadLine - System.nanoTime();
                    try {
                        Long seed = waitTime <= 0L ? (Long)seedQueue.poll() : seedQueue.poll(waitTime, TimeUnit.NANOSECONDS);
                        if (seed == null) continue;
                        initialSeedUniquifier = seed;
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        logger.warn("Failed to generate a seed from SecureRandom due to an InterruptedException.");
                    }
                    break block10;
                } while (waitTime > 0L);
                seedGeneratorThread.interrupt();
                logger.warn("Failed to generate a seed from SecureRandom within {} seconds. Not enough entropy?", (Object)3L);
            }
            initialSeedUniquifier ^= 0x3255ECDC33BAE119L;
            ThreadLocalRandom.initialSeedUniquifier = initialSeedUniquifier ^= Long.reverse(System.nanoTime());
            if (interrupted) {
                Thread.currentThread().interrupt();
                seedGeneratorThread.interrupt();
            }
            if (seedGeneratorEndTime == 0L) {
                seedGeneratorEndTime = System.nanoTime();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (long)var0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static long newSeed() {
        void var0;
        long actualCurrent;
        long next;
        long current;
        while (!seedUniquifier.compareAndSet(current, next = (actualCurrent = (current = seedUniquifier.get()) != 0L ? current : ThreadLocalRandom.getInitialSeedUniquifier()) * 181783497276652981L)) {
        }
        if (var0 == 0L && logger.isDebugEnabled()) {
            if (seedGeneratorEndTime != 0L) {
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x (took %d ms)", actualCurrent, TimeUnit.NANOSECONDS.toMillis(seedGeneratorEndTime - seedGeneratorStartTime)));
            } else {
                void var2_1;
                logger.debug(String.format("-Dio.netty.initialSeedUniquifier: 0x%016x", (long)var2_1));
            }
        }
        return next ^ System.nanoTime();
    }

    private static long mix64(long z) {
        long l;
        long l2 = z;
        z = (l2 ^ l2 >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ l >>> 33;
    }

    ThreadLocalRandom() {
        super(ThreadLocalRandom.newSeed());
    }

    public static ThreadLocalRandom current() {
        return InternalThreadLocalMap.get().random();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setSeed(long seed) {
        void var1_1;
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        this.rnd = (var1_1 ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int next(int bits) {
        void var1_1;
        this.rnd = this.rnd * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.rnd >>> 48 - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int nextInt(int least, int bound) {
        void var1_1;
        void var2_2;
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return this.nextInt((int)(var2_2 - least)) + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long nextLong(long n) {
        void var1_1;
        void var3_2;
        ObjectUtil.checkPositive(n, "n");
        long offset = 0L;
        while (n >= Integer.MAX_VALUE) {
            long nextn;
            int bits = this.next(2);
            long half = n >>> 1;
            long l = nextn = (bits & 2) == 0 ? half : n - half;
            if ((bits & 1) == 0) {
                offset += n - nextn;
            }
            n = nextn;
        }
        return (long)(var3_2 + (long)this.nextInt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long nextLong(long least, long bound) {
        void var1_1;
        void var3_2;
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return this.nextLong((long)(var3_2 - least)) + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double nextDouble(double n) {
        void var1_1;
        ObjectUtil.checkPositive(n, "n");
        return this.nextDouble() * var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double nextDouble(double least, double bound) {
        void var1_1;
        void var3_2;
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return this.nextDouble() * (var3_2 - least) + var1_1;
    }

    static {
        if (initialSeedUniquifier == 0L) {
            boolean bl = SystemPropertyUtil.getBoolean("java.util.secureRandomSeed", false);
            if (bl) {
                seedQueue = new LinkedBlockingQueue<Long>();
                seedGeneratorStartTime = System.nanoTime();
                seedGeneratorThread = new Thread("initialSeedUniquifierGenerator"){
                    {
                        void var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void run() {
                        void var3_2;
                        SecureRandom secureRandom = new SecureRandom();
                        byte[] seed = secureRandom.generateSeed(8);
                        seedGeneratorEndTime = System.nanoTime();
                        long s = ((long)seed[0] & 0xFFL) << 56 | ((long)seed[1] & 0xFFL) << 48 | ((long)seed[2] & 0xFFL) << 40 | ((long)seed[3] & 0xFFL) << 32 | ((long)seed[4] & 0xFFL) << 24 | ((long)seed[5] & 0xFFL) << 16 | ((long)seed[6] & 0xFFL) << 8 | (long)secureRandom[7] & 0xFFL;
                        seedQueue.add((long)var3_2);
                    }
                };
                seedGeneratorThread.setDaemon(true);
                seedGeneratorThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void uncaughtException(Thread t, Throwable e) {
                        void var2_2;
                        void var1_1;
                        logger.debug("An exception has been raised by {}", (Object)var1_1.getName(), (Object)var2_2);
                    }
                });
                seedGeneratorThread.start();
            } else {
                initialSeedUniquifier = ThreadLocalRandom.mix64(System.currentTimeMillis()) ^ ThreadLocalRandom.mix64(System.nanoTime());
                seedGeneratorThread = null;
                seedQueue = null;
                seedGeneratorStartTime = 0L;
            }
        } else {
            seedGeneratorThread = null;
            seedQueue = null;
            seedGeneratorStartTime = 0L;
        }
    }
}

