/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SystemPropertyUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);

    public static boolean contains(String key) {
        return SystemPropertyUtil.get(key) != null;
    }

    public static String get(String key) {
        return SystemPropertyUtil.get(key, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String get(final String key, String def) {
        void var2_2;
        ObjectUtil.checkNonEmpty(key, "key");
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public final String run() {
                    return System.getProperty(key);
                }
            });
        }
        catch (SecurityException e) {
            void var3_3;
            String string;
            logger.warn("Unable to retrieve a system property '{}'; default values will be used.", (Object)string, (Object)var3_3);
        }
        if (value == null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getBoolean(String key, boolean def) {
        void var1_1;
        void var2_2;
        String string;
        String value = SystemPropertyUtil.get(key);
        if (value == null) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return def;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        logger.warn("Unable to parse the boolean system property '{}':{} - using the default value: {}", string, var2_2, def);
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getInt(String key, int def) {
        String value = SystemPropertyUtil.get(key);
        if (value == null) {
            return def;
        }
        value = value.trim();
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            void var1_1;
            void var2_2;
            String string;
            logger.warn("Unable to parse the integer system property '{}':{} - using the default value: {}", string, var2_2, def);
            return (int)var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static long getLong(String key, long def) {
        String value = SystemPropertyUtil.get(key);
        if (value == null) {
            return def;
        }
        value = value.trim();
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            void var1_1;
            void var3_2;
            String string;
            logger.warn("Unable to parse the long integer system property '{}':{} - using the default value: {}", string, var3_2, def);
            return (long)var1_1;
        }
    }

    private SystemPropertyUtil() {
    }
}

