/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final byte[] HEX2B;
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    private StringUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String value, char delim) {
        int pos = value.indexOf(delim);
        if (pos >= 0) {
            void var1_1;
            String string;
            return string.substring((int)(var1_1 + true));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String value, char delim) {
        int pos = value.indexOf(delim);
        if (pos >= 0) {
            void var1_1;
            String string;
            return string.substring(0, (int)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean commonSuffixOfLength(String s, String p, int len) {
        if (s != null && p != null && len >= 0) {
            void var2_2;
            void var1_1;
            String string;
            String string2 = string;
            void v1 = var1_1;
            if (string2.regionMatches(string2.length() - len, (String)v1, v1.length() - len, (int)var2_2)) {
                return true;
            }
        }
        return false;
    }

    public static String byteToHexStringPadded(int value) {
        int n;
        return BYTE2HEX_PAD[n & 0xFF];
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T byteToHexStringPadded(T buf, int value) {
        T t;
        try {
            void var1_1;
            buf.append(StringUtil.byteToHexStringPadded((int)var1_1));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            PlatformDependent.throwException(iOException);
        }
        return t;
    }

    public static String toHexStringPadded(byte[] src) {
        byte[] byArray;
        return StringUtil.toHexStringPadded(src, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String toHexStringPadded(byte[] src, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return StringUtil.toHexStringPadded(new StringBuilder(length << 1), byArray, (int)var1_1, (int)var2_2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src) {
        void var1_1;
        return StringUtil.toHexStringPadded(dst, src, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src, int offset, int length) {
        T t;
        void i;
        int end = offset + length;
        while (i < end) {
            StringUtil.byteToHexStringPadded(dst, src[i]);
            ++i;
        }
        return t;
    }

    public static String byteToHexString(int value) {
        int n;
        return BYTE2HEX_NOPAD[n & 0xFF];
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T byteToHexString(T buf, int value) {
        T t;
        try {
            void var1_1;
            buf.append(StringUtil.byteToHexString((int)var1_1));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            PlatformDependent.throwException(iOException);
        }
        return t;
    }

    public static String toHexString(byte[] src) {
        byte[] byArray;
        return StringUtil.toHexString(src, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String toHexString(byte[] src, int offset, int length) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        return StringUtil.toHexString(new StringBuilder(length << 1), byArray, (int)var1_1, (int)var2_2).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T toHexString(T dst, byte[] src) {
        void var1_1;
        return StringUtil.toHexString(dst, src, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Appendable> T toHexString(T dst, byte[] src, int offset, int length) {
        T t;
        void var3_3;
        void var2_2;
        void var1_1;
        void i;
        assert (length >= 0);
        if (length == 0) {
            return dst;
        }
        int end = offset + length;
        int endMinusOne = end - 1;
        while (i < endMinusOne && src[i] == 0) {
            ++i;
        }
        StringUtil.byteToHexString(dst, src[i++]);
        int remaining = end - i;
        StringUtil.toHexStringPadded(dst, (byte[])var1_1, (int)var2_2, (int)var3_3);
        return t;
    }

    public static int decodeHexNibble(char c) {
        char c2;
        return HEX2B[c2];
    }

    public static int decodeHexNibble(byte b) {
        byte by;
        return HEX2B[by];
    }

    /*
     * WARNING - void declaration
     */
    public static byte decodeHexByte(CharSequence s, int pos) {
        void var3_3;
        void var2_2;
        int hi = StringUtil.decodeHexNibble(s.charAt(pos));
        int lo = StringUtil.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            CharSequence charSequence;
            void var1_1;
            Object[] objectArray = new Object[3];
            int n = pos;
            objectArray[0] = s.subSequence(n, n + 2);
            objectArray[1] = (int)var1_1;
            objectArray[2] = charSequence;
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", objectArray));
        }
        return (byte)((var2_2 << 4) + var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decodeHexDump(CharSequence hexDump, int fromIndex, int length) {
        void var3_3;
        if (length < 0 || (length & 1) != 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (length == 0) {
            return EmptyArrays.EMPTY_BYTES;
        }
        byte[] bytes = new byte[length >>> 1];
        for (int i = 0; i < length; i += 2) {
            bytes[i >>> 1] = StringUtil.decodeHexByte(hexDump, fromIndex + i);
        }
        return var3_3;
    }

    public static byte[] decodeHexDump(CharSequence hexDump) {
        CharSequence charSequence;
        return StringUtil.decodeHexDump(hexDump, 0, charSequence.length());
    }

    public static String simpleClassName(Object o) {
        Object object;
        if (o == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public static String simpleClassName(Class<?> clazz) {
        String string;
        String className = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx >= 0) {
            void var1_1;
            return className.substring((int)(var1_1 + true));
        }
        return string;
    }

    public static CharSequence escapeCsv(CharSequence value) {
        return StringUtil.escapeCsv(value, false);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence escapeCsv(CharSequence value, boolean trimWhiteSpace) {
        int last;
        int start;
        int length = ObjectUtil.checkNotNull(value, "value").length();
        if (trimWhiteSpace) {
            start = StringUtil.indexOfFirstNonOwsChar(value, length);
            last = StringUtil.indexOfLastNonOwsChar(value, start, length);
        } else {
            start = 0;
            --last;
        }
        if (start > last) {
            return EMPTY_STRING;
        }
        int firstUnescapedSpecial = -1;
        boolean quoted = false;
        if (StringUtil.isDoubleQuote(value.charAt(start))) {
            quoted = StringUtil.isDoubleQuote(value.charAt(last)) && last > start;
            if (quoted) {
                ++start;
                --last;
            } else {
                firstUnescapedSpecial = start;
            }
        }
        if (firstUnescapedSpecial < 0) {
            int i;
            if (quoted) {
                for (i = start; i <= last; ++i) {
                    if (!StringUtil.isDoubleQuote(value.charAt(i))) continue;
                    if (i == last || !StringUtil.isDoubleQuote(value.charAt(i + 1))) {
                        firstUnescapedSpecial = i;
                        break;
                    }
                    ++i;
                }
            } else {
                for (i = start; i <= last; ++i) {
                    char c = value.charAt(i);
                    if (c == '\n' || c == '\r' || c == ',') {
                        firstUnescapedSpecial = i;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote(c)) continue;
                    if (i == last || !StringUtil.isDoubleQuote(value.charAt(i + 1))) {
                        firstUnescapedSpecial = i;
                        break;
                    }
                    ++i;
                }
            }
            if (firstUnescapedSpecial < 0) {
                if (quoted) {
                    return value.subSequence(start - 1, last + 2);
                }
                return value.subSequence(start, last + 1);
            }
        }
        StringBuilder result = new StringBuilder(last - start + 1 + 7);
        result.append('\"').append(value, start, firstUnescapedSpecial);
        for (void i = var3_3; i <= last; ++i) {
            void var1_1;
            char c = value.charAt((int)i);
            if (StringUtil.isDoubleQuote(c)) {
                result.append('\"');
                if (i < last && StringUtil.isDoubleQuote(value.charAt((int)(i + true)))) {
                    ++i;
                }
            }
            result.append((char)var1_1);
        }
        return result.append('\"');
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence unescapeCsv(CharSequence value) {
        void var1_2;
        int length = ObjectUtil.checkNotNull(value, "value").length();
        if (length == 0) {
            return value;
        }
        int last = length - 1;
        length = StringUtil.isDoubleQuote(value.charAt(0)) && StringUtil.isDoubleQuote(value.charAt(last)) && length != 1 ? 1 : 0;
        if (length == 0) {
            StringUtil.validateCsvFormat(value);
            return value;
        }
        StringBuilder unescaped = InternalThreadLocalMap.get().stringBuilder();
        for (int i = 1; i < last; ++i) {
            char current = value.charAt(i);
            if (current == '\"') {
                if (StringUtil.isDoubleQuote(value.charAt(i + 1)) && i + 1 != last) {
                    ++i;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value, i);
                }
            }
            unescaped.append(current);
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static List<CharSequence> unescapeCsvFields(CharSequence value) {
        void var1_1;
        void var2_2;
        void var3_3;
        ArrayList<CharSequence> unescaped = new ArrayList<CharSequence>(2);
        StringBuilder current = InternalThreadLocalMap.get().stringBuilder();
        boolean quoted = false;
        int last = value.length() - 1;
        block8: for (int i = 0; i <= last; ++i) {
            void var6_6;
            char c = value.charAt(i);
            if (quoted) {
                switch (c) {
                    case '\"': {
                        char next;
                        if (i == last) {
                            unescaped.add(current.toString());
                            return unescaped;
                        }
                        if ((next = value.charAt(++i)) == '\"') {
                            current.append('\"');
                            break;
                        }
                        if (next == ',') {
                            quoted = false;
                            unescaped.add(current.toString());
                            current.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(value, i - 1);
                    }
                    default: {
                        current.append((char)var6_6);
                        break;
                    }
                }
                continue;
            }
            switch (var6_6) {
                case 44: {
                    unescaped.add(current.toString());
                    current.setLength(0);
                    continue block8;
                }
                case 34: {
                    if (current.length() == 0) {
                        quoted = true;
                        continue block8;
                    }
                }
                case 10: 
                case 13: {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value, i);
                }
                default: {
                    current.append((char)var6_6);
                }
            }
        }
        if (var3_3 != false) {
            CharSequence charSequence;
            throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, last);
        }
        unescaped.add(var2_2.toString());
        return var1_1;
    }

    private static void validateCsvFormat(CharSequence value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            switch (value.charAt(i)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value, i);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence value, int index) {
        void var1_1;
        CharSequence charSequence;
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + (int)var1_1);
    }

    public static int length(String s) {
        String string;
        if (s == null) {
            return 0;
        }
        return string.length();
    }

    public static boolean isNullOrEmpty(String s) {
        String string;
        return s == null || string.isEmpty();
    }

    public static int indexOfNonWhiteSpace(CharSequence seq, int offset) {
        while (offset < seq.length()) {
            if (!Character.isWhitespace(seq.charAt(offset))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int indexOfWhiteSpace(CharSequence seq, int offset) {
        while (offset < seq.length()) {
            if (Character.isWhitespace(seq.charAt(offset))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static boolean isSurrogate(char c) {
        char c2;
        return c >= '\ud800' && c2 <= '\udfff';
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWith(CharSequence s, char c) {
        void var1_1;
        void var2_2;
        CharSequence charSequence;
        int len = s.length();
        return len > 0 && charSequence.charAt((int)(var2_2 - true)) == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence trimOws(CharSequence value) {
        void var3_3;
        void var2_2;
        CharSequence charSequence;
        void var1_1;
        int length = value.length();
        if (length == 0) {
            return value;
        }
        int start = StringUtil.indexOfFirstNonOwsChar(value, length);
        int end = StringUtil.indexOfLastNonOwsChar(value, start, length);
        if (start == 0 && end == var1_1 - true) {
            return value;
        }
        return charSequence.subSequence((int)var2_2, (int)(var3_3 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence join(CharSequence separator, Iterable<? extends CharSequence> elements) {
        void var2_2;
        ObjectUtil.checkNotNull(separator, "separator");
        ObjectUtil.checkNotNull(elements, "elements");
        Iterator<? extends CharSequence> iterator = elements.iterator();
        if (!iterator.hasNext()) {
            return EMPTY_STRING;
        }
        CharSequence firstElement = iterator.next();
        if (!iterator.hasNext()) {
            return firstElement;
        }
        StringBuilder builder = new StringBuilder(firstElement);
        do {
            builder.append(separator).append(iterator.next());
        } while (iterator.hasNext());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOfFirstNonOwsChar(CharSequence value, int length) {
        void var2_2;
        for (int i = 0; i < length && StringUtil.isOws(value.charAt(i)); ++i) {
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int indexOfLastNonOwsChar(CharSequence value, int start, int length) {
        void var2_2;
        for (int i = length - 1; i > start && StringUtil.isOws(value.charAt(i)); --i) {
        }
        return (int)var2_2;
    }

    private static boolean isOws(char c) {
        char c2;
        return c == ' ' || c2 == '\t';
    }

    /*
     * WARNING - void declaration
     */
    static {
        for (int i = 0; i < BYTE2HEX_PAD.length; ++i) {
            void var1_1;
            String str = Integer.toHexString(i);
            int n = i;
            StringUtil.BYTE2HEX_PAD[n] = n > 15 ? str : "0" + str;
            StringUtil.BYTE2HEX_NOPAD[i] = var1_1;
        }
        HEX2B = new byte[65536];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtil.HEX2B[48] = 0;
        StringUtil.HEX2B[49] = 1;
        StringUtil.HEX2B[50] = 2;
        StringUtil.HEX2B[51] = 3;
        StringUtil.HEX2B[52] = 4;
        StringUtil.HEX2B[53] = 5;
        StringUtil.HEX2B[54] = 6;
        StringUtil.HEX2B[55] = 7;
        StringUtil.HEX2B[56] = 8;
        StringUtil.HEX2B[57] = 9;
        StringUtil.HEX2B[65] = 10;
        StringUtil.HEX2B[66] = 11;
        StringUtil.HEX2B[67] = 12;
        StringUtil.HEX2B[68] = 13;
        StringUtil.HEX2B[69] = 14;
        StringUtil.HEX2B[70] = 15;
        StringUtil.HEX2B[97] = 10;
        StringUtil.HEX2B[98] = 11;
        StringUtil.HEX2B[99] = 12;
        StringUtil.HEX2B[100] = 13;
        StringUtil.HEX2B[101] = 14;
        StringUtil.HEX2B[102] = 15;
    }
}

