/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;

public final class SocketUtils {
    private static final Enumeration<Object> EMPTY = Collections.enumeration(Collections.emptyList());

    private SocketUtils() {
    }

    private static <T> Enumeration<T> empty() {
        return EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public static void connect(Socket socket, SocketAddress remoteAddress, int timeout) throws IOException {
        PrivilegedActionException privilegedActionException;
        try {
            void var2_2;
            void var1_1;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((Socket)((Object)privilegedActionException), (SocketAddress)var1_1, (int)var2_2){
                final /* synthetic */ Socket val$socket;
                final /* synthetic */ SocketAddress val$remoteAddress;
                final /* synthetic */ int val$timeout;
                {
                    this.val$socket = socket;
                    this.val$remoteAddress = socketAddress;
                    this.val$timeout = n;
                }

                @Override
                public final Void run() throws IOException {
                    this.val$socket.connect(this.val$remoteAddress, this.val$timeout);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (IOException)privilegedActionException2.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void bind(Socket socket, SocketAddress bindpoint) throws IOException {
        PrivilegedActionException privilegedActionException;
        try {
            void var1_1;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((Socket)((Object)privilegedActionException), (SocketAddress)var1_1){
                final /* synthetic */ Socket val$socket;
                final /* synthetic */ SocketAddress val$bindpoint;
                {
                    this.val$socket = socket;
                    this.val$bindpoint = socketAddress;
                }

                @Override
                public final Void run() throws IOException {
                    this.val$socket.bind(this.val$bindpoint);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (IOException)privilegedActionException2.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean connect(SocketChannel socketChannel, SocketAddress remoteAddress) throws IOException {
        PrivilegedActionException privilegedActionException;
        try {
            void var1_1;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>((SocketChannel)((Object)privilegedActionException), (SocketAddress)var1_1){
                final /* synthetic */ SocketChannel val$socketChannel;
                final /* synthetic */ SocketAddress val$remoteAddress;
                {
                    this.val$socketChannel = socketChannel;
                    this.val$remoteAddress = socketAddress;
                }

                @Override
                public final Boolean run() throws IOException {
                    return this.val$socketChannel.connect(this.val$remoteAddress);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (IOException)privilegedActionException2.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public static void bind(SocketChannel socketChannel, SocketAddress address) throws IOException {
        PrivilegedActionException privilegedActionException;
        try {
            void var1_1;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((SocketChannel)((Object)privilegedActionException), (SocketAddress)var1_1){
                final /* synthetic */ SocketChannel val$socketChannel;
                final /* synthetic */ SocketAddress val$address;
                {
                    this.val$socketChannel = socketChannel;
                    this.val$address = socketAddress;
                }

                @Override
                public final Void run() throws IOException {
                    this.val$socketChannel.bind(this.val$address);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (IOException)privilegedActionException2.getCause();
        }
    }

    public static SocketChannel accept(ServerSocketChannel serverSocketChannel) throws IOException {
        PrivilegedActionException privilegedActionException;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SocketChannel>((ServerSocketChannel)((Object)privilegedActionException)){
                final /* synthetic */ ServerSocketChannel val$serverSocketChannel;
                {
                    this.val$serverSocketChannel = serverSocketChannel;
                }

                @Override
                public final SocketChannel run() throws IOException {
                    return this.val$serverSocketChannel.accept();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (IOException)privilegedActionException2.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public static void bind(DatagramChannel networkChannel, SocketAddress address) throws IOException {
        PrivilegedActionException privilegedActionException;
        try {
            void var1_1;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>((DatagramChannel)((Object)privilegedActionException), (SocketAddress)var1_1){
                final /* synthetic */ DatagramChannel val$networkChannel;
                final /* synthetic */ SocketAddress val$address;
                {
                    this.val$networkChannel = datagramChannel;
                    this.val$address = socketAddress;
                }

                @Override
                public final Void run() throws IOException {
                    this.val$networkChannel.bind(this.val$address);
                    return null;
                }
            });
            return;
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (IOException)privilegedActionException2.getCause();
        }
    }

    public static SocketAddress localSocketAddress(ServerSocket socket) {
        ServerSocket serverSocket;
        return AccessController.doPrivileged(new PrivilegedAction<SocketAddress>(){

            @Override
            public final SocketAddress run() {
                return serverSocket.getLocalSocketAddress();
            }
        });
    }

    public static InetAddress addressByName(String hostname) throws UnknownHostException {
        PrivilegedActionException privilegedActionException;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>((String)((Object)privilegedActionException)){
                final /* synthetic */ String val$hostname;
                {
                    this.val$hostname = string;
                }

                @Override
                public final InetAddress run() throws UnknownHostException {
                    return InetAddress.getByName(this.val$hostname);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (UnknownHostException)privilegedActionException2.getCause();
        }
    }

    public static InetAddress[] allAddressesByName(String hostname) throws UnknownHostException {
        PrivilegedActionException privilegedActionException;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress[]>((String)((Object)privilegedActionException)){
                final /* synthetic */ String val$hostname;
                {
                    this.val$hostname = string;
                }

                @Override
                public final InetAddress[] run() throws UnknownHostException {
                    return InetAddress.getAllByName(this.val$hostname);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (UnknownHostException)privilegedActionException2.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InetSocketAddress socketAddress(String hostname, int port) {
        void var1_1;
        String string;
        return AccessController.doPrivileged(new PrivilegedAction<InetSocketAddress>((int)var1_1){
            final /* synthetic */ int val$port;
            {
                this.val$port = n;
            }

            @Override
            public final InetSocketAddress run() {
                return new InetSocketAddress(string, this.val$port);
            }
        });
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(final NetworkInterface intf) {
        Enumeration<InetAddress> enumeration;
        Enumeration<InetAddress> addresses = AccessController.doPrivileged(new PrivilegedAction<Enumeration<InetAddress>>(){

            @Override
            public final Enumeration<InetAddress> run() {
                return intf.getInetAddresses();
            }
        });
        if (addresses == null) {
            return SocketUtils.empty();
        }
        return enumeration;
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public static InetAddress loopbackAddress() {
        return AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final InetAddress run() {
                if (PlatformDependent.javaVersion() >= 7) {
                    return InetAddress.getLoopbackAddress();
                }
                try {
                    return InetAddress.getByName(null);
                }
                catch (UnknownHostException e) {
                    void var1_1;
                    throw new IllegalStateException((Throwable)var1_1);
                }
            }
        });
    }

    public static byte[] hardwareAddressFromNetworkInterface(NetworkInterface intf) throws SocketException {
        PrivilegedActionException privilegedActionException;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>((NetworkInterface)((Object)privilegedActionException)){
                final /* synthetic */ NetworkInterface val$intf;
                {
                    this.val$intf = networkInterface;
                }

                @Override
                public final byte[] run() throws SocketException {
                    return this.val$intf.getHardwareAddress();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException2) {
            privilegedActionException = privilegedActionException2;
            throw (SocketException)privilegedActionException2.getCause();
        }
    }
}

