/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

public final class SWARUtil {
    public static long compilePattern(byte byteToFind) {
        return ((long)byteToFind & 0xFFL) * 0x101010101010101L;
    }

    /*
     * WARNING - void declaration
     */
    public static long applyPattern(long word, long pattern) {
        void var2_1;
        long input = word ^ var2_1;
        long l = (input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
        return (l | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int getIndex(long word, boolean isBigEndian) {
        long l;
        int n = isBigEndian ? Long.numberOfLeadingZeros(word) : Long.numberOfTrailingZeros(l);
        return n >>> 3;
    }

    private static long applyUpperCasePattern(long word) {
        long l;
        long l2 = word & 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x2525252525252525L;
        l2 &= 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x1A1A1A1A1A1A1A1AL;
        l2 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        return l2 &= 0x8080808080808080L;
    }

    private static int applyUpperCasePattern(int word) {
        int n;
        int n2 = word & 0x7F7F7F7F;
        n2 += 0x25252525;
        n2 &= 0x7F7F7F7F;
        n2 += 0x1A1A1A1A;
        n2 &= ~n;
        return n2 &= 0x80808080;
    }

    private static long applyLowerCasePattern(long word) {
        long l;
        long l2 = word & 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x505050505050505L;
        l2 &= 0x7F7F7F7F7F7F7F7FL;
        l2 += 0x1A1A1A1A1A1A1A1AL;
        l2 &= l ^ 0xFFFFFFFFFFFFFFFFL;
        return l2 &= 0x8080808080808080L;
    }

    private static int applyLowerCasePattern(int word) {
        int n;
        int n2 = word & 0x7F7F7F7F;
        n2 += 0x5050505;
        n2 &= 0x7F7F7F7F;
        n2 += 0x1A1A1A1A;
        n2 &= ~n;
        return n2 &= 0x80808080;
    }

    public static boolean containsUpperCase(long word) {
        return SWARUtil.applyUpperCasePattern(word) != 0L;
    }

    public static boolean containsUpperCase(int word) {
        return SWARUtil.applyUpperCasePattern(word) != 0;
    }

    public static boolean containsLowerCase(long word) {
        return SWARUtil.applyLowerCasePattern(word) != 0L;
    }

    public static boolean containsLowerCase(int word) {
        return SWARUtil.applyLowerCasePattern(word) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static long toLowerCase(long word) {
        void var2_1;
        long l;
        long mask = SWARUtil.applyUpperCasePattern(word) >>> 2;
        return l | var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int toLowerCase(int word) {
        void var1_1;
        int n;
        int mask = SWARUtil.applyUpperCasePattern(word) >>> 2;
        return n | var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long toUpperCase(long word) {
        void var2_1;
        long l;
        long mask = SWARUtil.applyLowerCasePattern(word) >>> 2;
        return l & (var2_1 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    public static int toUpperCase(int word) {
        void var1_1;
        int n;
        int mask = SWARUtil.applyLowerCasePattern(word) >>> 2;
        return n & ~var1_1;
    }

    private SWARUtil() {
    }
}

