/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent0;
import java.lang.reflect.AccessibleObject;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Throwable trySetAccessible(AccessibleObject object, boolean checkAccessible) {
        Object object2;
        if (checkAccessible && !PlatformDependent0.isExplicitTryReflectionSetAccessible()) {
            return new UnsupportedOperationException("Reflective setAccessible(true) disabled");
        }
        try {
            ((AccessibleObject)object2).setAccessible(true);
            return null;
        }
        catch (SecurityException securityException) {
            object2 = securityException;
            return securityException;
        }
        catch (RuntimeException runtimeException) {
            object2 = runtimeException;
            return ReflectionUtil.handleInaccessibleObjectException(runtimeException);
        }
    }

    private static RuntimeException handleInaccessibleObjectException(RuntimeException e) {
        RuntimeException runtimeException;
        if ("java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
            return e;
        }
        throw runtimeException;
    }
}

