/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class ReferenceCountUpdater<T extends ReferenceCounted> {
    protected ReferenceCountUpdater() {
    }

    /*
     * WARNING - void declaration
     */
    public static long getUnsafeOffset(Class<? extends ReferenceCounted> clz, String fieldName) {
        try {
            if (PlatformDependent.hasUnsafe()) {
                void var1_1;
                Class<? extends ReferenceCounted> clazz;
                return PlatformDependent.objectFieldOffset(clazz.getDeclaredField((String)var1_1));
            }
        }
        catch (Throwable throwable) {}
        return -1L;
    }

    protected abstract AtomicIntegerFieldUpdater<T> updater();

    protected abstract long unsafeOffset();

    public final int initialValue() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public void setInitialValue(T instance) {
        void var2_2;
        void var1_1;
        long offset = this.unsafeOffset();
        if (offset == -1L) {
            this.updater().set(instance, this.initialValue());
            return;
        }
        PlatformDependent.safeConstructPutInt(var1_1, (long)var2_2, this.initialValue());
    }

    private static int realRefCnt(int rawCnt) {
        int n;
        if (rawCnt != 2 && rawCnt != 4 && (rawCnt & 1) != 0) {
            return 0;
        }
        return n >>> 1;
    }

    /*
     * WARNING - void declaration
     */
    private static int toLiveRealRefCnt(int rawCnt, int decrement) {
        void var1_1;
        if (rawCnt == 2 || rawCnt == 4 || (rawCnt & 1) == 0) {
            int n;
            return n >>> 1;
        }
        throw new IllegalReferenceCountException(0, (int)(-var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private int nonVolatileRawCnt(T instance) {
        void var1_1;
        long offset = this.unsafeOffset();
        if (offset != -1L) {
            void var2_2;
            return PlatformDependent.getInt(instance, (long)var2_2);
        }
        return this.updater().get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int refCnt(T instance) {
        void var1_1;
        return ReferenceCountUpdater.realRefCnt(this.updater().get(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isLiveNonVolatile(T instance) {
        void var1_2;
        void var2_3;
        long offset = this.unsafeOffset();
        int rawCnt = offset != -1L ? PlatformDependent.getInt(instance, (long)var2_3) : this.updater().get(instance);
        return rawCnt == 2 || rawCnt == 4 || rawCnt == 6 || rawCnt == 8 || (var1_2 & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRefCnt(T instance, int refCnt) {
        void var2_2;
        void var1_1;
        this.updater().set(var1_1, refCnt > 0 ? var2_2 << 1 : 1);
    }

    /*
     * WARNING - void declaration
     */
    public final void resetRefCnt(T instance) {
        void var1_1;
        this.updater().lazySet(var1_1, this.initialValue());
    }

    /*
     * WARNING - void declaration
     */
    public final T retain(T instance) {
        void var1_1;
        return this.retain0(var1_1, 1, 2);
    }

    /*
     * WARNING - void declaration
     */
    public final T retain(T instance, int increment) {
        void var3_3;
        void var2_2;
        void var1_1;
        int rawIncrement = ObjectUtil.checkPositive(increment, "increment") << 1;
        return this.retain0(var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private T retain0(T instance, int increment, int rawIncrement) {
        void var1_1;
        int oldRef = this.updater().getAndAdd(instance, rawIncrement);
        if (oldRef != 2 && oldRef != 4 && (oldRef & 1) != 0) {
            throw new IllegalReferenceCountException(0, increment);
        }
        if (oldRef <= 0 && oldRef + rawIncrement >= 0 || oldRef >= 0 && oldRef + rawIncrement < oldRef) {
            void var2_2;
            void var3_3;
            this.updater().getAndAdd(instance, (int)(-var3_3));
            throw new IllegalReferenceCountException(ReferenceCountUpdater.realRefCnt(oldRef), (int)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean release(T instance) {
        void var1_1;
        void var2_2;
        int rawCnt = this.nonVolatileRawCnt(instance);
        if (rawCnt == 2) {
            return this.tryFinalRelease0(instance, 2) || this.retryRelease0(instance, 1);
        }
        void v0 = var2_2;
        return this.nonFinalRelease0(var1_1, 1, (int)v0, ReferenceCountUpdater.toLiveRealRefCnt((int)v0, 1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean release(T instance, int decrement) {
        void var3_3;
        void var2_2;
        void var1_1;
        int rawCnt = this.nonVolatileRawCnt(instance);
        int realCnt = ReferenceCountUpdater.toLiveRealRefCnt(rawCnt, ObjectUtil.checkPositive(decrement, "decrement"));
        if (decrement == realCnt) {
            return this.tryFinalRelease0(instance, rawCnt) || this.retryRelease0(instance, decrement);
        }
        return this.nonFinalRelease0(var1_1, (int)var2_2, (int)var3_3, realCnt);
    }

    /*
     * WARNING - void declaration
     */
    private boolean tryFinalRelease0(T instance, int expectRawCnt) {
        void var2_2;
        void var1_1;
        return this.updater().compareAndSet(var1_1, (int)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean nonFinalRelease0(T instance, int decrement, int rawCnt, int realCnt) {
        void var2_2;
        void var1_1;
        if (decrement < realCnt) {
            void var3_3;
            void v0 = var3_3;
            if (this.updater().compareAndSet(instance, (int)v0, (int)(v0 - (decrement << 1)))) {
                return false;
            }
        }
        return this.retryRelease0(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean retryRelease0(T instance, int decrement) {
        while (true) {
            int rawCnt;
            int realCnt;
            if (decrement == (realCnt = ReferenceCountUpdater.toLiveRealRefCnt(rawCnt = this.updater().get(instance), decrement))) {
                if (this.tryFinalRelease0(instance, rawCnt)) {
                    return true;
                }
            } else if (decrement < realCnt) {
                void var3_3;
                void v0 = var3_3;
                if (this.updater().compareAndSet(instance, (int)v0, (int)(v0 - (decrement << 1)))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(realCnt, -decrement);
            }
            Thread.yield();
        }
    }
}

