/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final ObjectPool<RecyclableArrayList> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<RecyclableArrayList>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final RecyclableArrayList newObject(ObjectPool.Handle<RecyclableArrayList> handle) {
            void var1_1;
            return new RecyclableArrayList((ObjectPool.Handle)var1_1);
        }
    });
    private boolean insertSinceRecycled;
    private final ObjectPool.Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance() {
        return RecyclableArrayList.newInstance(8);
    }

    /*
     * WARNING - void declaration
     */
    public static RecyclableArrayList newInstance(int minCapacity) {
        void var1_1;
        int n;
        RecyclableArrayList ret = RECYCLER.get();
        ret.ensureCapacity(n);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle) {
        this((ObjectPool.Handle<RecyclableArrayList>)var1_1, 8);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private RecyclableArrayList(ObjectPool.Handle<RecyclableArrayList> handle, int initialCapacity) {
        super((int)var2_2);
        void var1_1;
        void var2_2;
        this.handle = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<?> c) {
        void var1_1;
        RecyclableArrayList.checkNullElements(c);
        if (super.addAll(var1_1)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<?> c) {
        void var2_2;
        void var1_1;
        RecyclableArrayList.checkNullElements(c);
        if (super.addAll((int)var1_1, var2_2)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> c) {
        List list;
        if (c instanceof RandomAccess && c instanceof List) {
            List list2 = (List)c;
            int size = list2.size();
            for (int i = 0; i < size; ++i) {
                if (list2.get(i) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
            return;
        }
        list = list.iterator();
        while (list.hasNext()) {
            Object e = list.next();
            if (e != null) continue;
            throw new IllegalArgumentException("c contains null values");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(Object element) {
        void var1_1;
        if (super.add(ObjectUtil.checkNotNull(var1_1, "element"))) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, Object element) {
        void var2_2;
        void var1_1;
        super.add((int)var1_1, ObjectUtil.checkNotNull(var2_2, "element"));
        this.insertSinceRecycled = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object set(int index, Object element) {
        void var1_2;
        void var2_3;
        void old = super.set(index, ObjectUtil.checkNotNull(var2_3, "element"));
        this.insertSinceRecycled = true;
        return var1_2;
    }

    public final boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public final boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }
}

