/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;

public final class PromiseNotificationUtil {
    private PromiseNotificationUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static void tryCancel(Promise<?> p, InternalLogger logger) {
        if (!p.cancel(false) && logger != null) {
            void var2_2;
            Promise<?> promise;
            void var1_1;
            Throwable err = p.cause();
            if (err == null) {
                logger.warn("Failed to cancel promise because it has succeeded already: {}", (Object)p);
                return;
            }
            var1_1.warn("Failed to cancel promise because it has failed already: {}, unnotified cause:", (Object)promise, (Object)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <V> void trySuccess(Promise<? super V> p, V result, InternalLogger logger) {
        if (!p.trySuccess(result) && logger != null) {
            void var1_1;
            Promise<? super V> promise;
            void var2_2;
            Throwable err = p.cause();
            if (err == null) {
                logger.warn("Failed to mark a promise as success because it has succeeded already: {}", (Object)p);
                return;
            }
            var2_2.warn("Failed to mark a promise as success because it has failed already: {}, unnotified cause:", (Object)promise, (Object)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void tryFailure(Promise<?> p, Throwable cause, InternalLogger logger) {
        if (!p.tryFailure(cause) && logger != null) {
            Throwable err = p.cause();
            if (err == null) {
                logger.warn("Failed to mark a promise as failure because it has succeeded already: {}", (Object)p, (Object)cause);
                return;
            }
            if (logger.isWarnEnabled()) {
                void var1_1;
                void var3_3;
                Promise<?> promise;
                void var2_2;
                var2_2.warn("Failed to mark a promise as failure because it has failed already: {}, unnotified cause: {}", promise, ThrowableUtil.stackTraceToString((Throwable)var3_3), var1_1);
            }
        }
    }
}

