/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

@SuppressJava6Requirement(reason="Unsafe access is guarded")
final class PlatformDependent0 {
    private static final InternalLogger logger;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_BASE_OFFSET;
    private static final long INT_ARRAY_INDEX_SCALE;
    private static final long LONG_ARRAY_BASE_OFFSET;
    private static final long LONG_ARRAY_INDEX_SCALE;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Method ALLOCATE_ARRAY_METHOD;
    private static final Method ALIGN_SLICE;
    private static final int JAVA_VERSION;
    private static final boolean IS_ANDROID;
    private static final boolean STORE_FENCE_AVAILABLE;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final Object INTERNAL_UNSAFE;
    private static final boolean RUNNING_IN_NATIVE_IMAGE;
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    static final Unsafe UNSAFE;
    static final int HASH_CODE_ASCII_SEED = -1028477387;
    static final int HASH_CODE_C1 = -862048943;
    static final int HASH_CODE_C2 = 461845907;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;
    private static final long BITS_MAX_DIRECT_MEMORY;

    private static boolean unsafeStaticFieldOffsetSupported() {
        return !RUNNING_IN_NATIVE_IMAGE;
    }

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    /*
     * WARNING - void declaration
     */
    private static Throwable explicitNoUnsafeCause0() {
        boolean noUnsafe = SystemPropertyUtil.getBoolean("io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)noUnsafe);
        String unsafeMemoryAccess = SystemPropertyUtil.get("sun.misc.unsafe.memory.access", "<unspecified>");
        if (!"allow".equals(unsafeMemoryAccess) && !"<unspecified>".equals(unsafeMemoryAccess)) {
            void var1_2;
            logger.debug("--sun-misc-unsafe-memory-access={}", (Object)var1_2);
            noUnsafe = true;
        }
        if (noUnsafe) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
        }
        String unsafePropName = SystemPropertyUtil.contains("io.netty.tryUnsafe") ? "io.netty.tryUnsafe" : "org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(unsafePropName, true)) {
            void var0_1;
            String msg = "sun.misc.Unsafe: unavailable (" + unsafePropName + ")";
            logger.debug(msg);
            return new UnsupportedOperationException((String)var0_1);
        }
        return null;
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static long bitsMaxDirectMemory() {
        return BITS_MAX_DIRECT_MEMORY;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable cause) {
        Throwable throwable;
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer buffer, int capacity) {
        void var1_1;
        ByteBuffer byteBuffer;
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), capacity), (int)var1_1);
    }

    static ByteBuffer allocateDirectNoCleaner(int capacity) {
        int n;
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(Math.max(1, capacity)), n);
    }

    static boolean hasAlignSliceMethod() {
        return ALIGN_SLICE != null;
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuffer alignSlice(ByteBuffer buffer, int alignment) {
        try {
            void var1_3;
            return (ByteBuffer)ALIGN_SLICE.invoke((Object)buffer, (int)var1_3);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            void var0_2;
            throw new Error((Throwable)var0_2);
        }
    }

    static boolean hasAllocateArrayMethod() {
        return ALLOCATE_ARRAY_METHOD != null;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] allocateUninitializedArray(int size) {
        try {
            return (byte[])ALLOCATE_ARRAY_METHOD.invoke(INTERNAL_UNSAFE, Byte.TYPE, size);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            void var0_2;
            throw new Error((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static ByteBuffer newDirectBuffer(long address, int capacity) {
        ObjectUtil.checkPositiveOrZero(capacity, "capacity");
        try {
            void var2_2;
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(address, (int)var2_2);
        }
        catch (Throwable throwable) {
            void var0_1;
            Throwable cause = throwable;
            if (throwable instanceof Error) {
                throw (Error)cause;
            }
            throw new Error((Throwable)var0_1);
        }
    }

    static long directBufferAddress(ByteBuffer buffer) {
        return PlatformDependent0.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    /*
     * WARNING - void declaration
     */
    static Object getObject(Object object, long fieldOffset) {
        void var1_1;
        Object object2;
        return UNSAFE.getObject(object2, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(Object object, long fieldOffset) {
        void var1_1;
        Object object2;
        return UNSAFE.getInt(object2, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void safeConstructPutInt(Object object, long fieldOffset, int value) {
        void var3_2;
        void var1_1;
        Object object2;
        if (STORE_FENCE_AVAILABLE) {
            UNSAFE.putInt(object, fieldOffset, value);
            UNSAFE.storeFence();
            return;
        }
        UNSAFE.putIntVolatile(object2, (long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private static long getLong(Object object, long fieldOffset) {
        void var1_1;
        Object object2;
        return UNSAFE.getLong(object2, (long)var1_1);
    }

    static long objectFieldOffset(Field field) {
        Field field2;
        return UNSAFE.objectFieldOffset(field2);
    }

    static byte getByte(long address) {
        long l;
        return UNSAFE.getByte(l);
    }

    static short getShort(long address) {
        long l;
        return UNSAFE.getShort(l);
    }

    static int getInt(long address) {
        long l;
        return UNSAFE.getInt(l);
    }

    static long getLong(long address) {
        long l;
        return UNSAFE.getLong(l);
    }

    /*
     * WARNING - void declaration
     */
    static byte getByte(byte[] data, int index) {
        void var1_1;
        byte[] byArray;
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static byte getByte(byte[] data, long index) {
        void var1_1;
        byte[] byArray;
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static short getShort(byte[] data, int index) {
        void var1_1;
        byte[] byArray;
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(byte[] data, int index) {
        void var1_1;
        byte[] byArray;
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static int getInt(int[] data, long index) {
        void var1_1;
        int[] nArray;
        return UNSAFE.getInt(nArray, INT_ARRAY_BASE_OFFSET + INT_ARRAY_INDEX_SCALE * var1_1);
    }

    static int getIntVolatile(long address) {
        long l;
        return UNSAFE.getIntVolatile(null, l);
    }

    /*
     * WARNING - void declaration
     */
    static void putIntOrdered(long adddress, int newValue) {
        void var2_1;
        long l;
        UNSAFE.putOrderedInt(null, l, (int)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(byte[] data, int index) {
        void var1_1;
        byte[] byArray;
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static long getLong(long[] data, long index) {
        void var1_1;
        long[] lArray;
        return UNSAFE.getLong(lArray, LONG_ARRAY_BASE_OFFSET + LONG_ARRAY_INDEX_SCALE * var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(long address, byte value) {
        void var2_1;
        long l;
        UNSAFE.putByte(l, (byte)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putShort(long address, short value) {
        void var2_1;
        long l;
        UNSAFE.putShort(l, (short)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putInt(long address, int value) {
        void var2_1;
        long l;
        UNSAFE.putInt(l, (int)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putLong(long address, long value) {
        void var2_1;
        long l;
        UNSAFE.putLong(l, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(byte[] data, int index, byte value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void putByte(Object data, long offset, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        UNSAFE.putByte(object, (long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static void putShort(byte[] data, int index, short value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1, (short)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void putInt(byte[] data, int index, int value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void putLong(byte[] data, int index, long value) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void putObject(Object o, long offset, Object x) {
        void var3_2;
        void var1_1;
        Object object;
        UNSAFE.putObject(object, (long)var1_1, var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static void copyMemory(long srcAddr, long dstAddr, long length) {
        void var2_2;
        long l;
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(srcAddr, dstAddr, length);
            return;
        }
        UNSAFE.copyMemory(l, (long)var2_2, length);
    }

    private static void copyMemoryWithSafePointPolling(long srcAddr, long dstAddr, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(srcAddr, dstAddr, size);
            length -= size;
            srcAddr += size;
            dstAddr += size;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        void var3_2;
        void var1_1;
        Object object;
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(src, srcOffset, dst, dstOffset, length);
            return;
        }
        UNSAFE.copyMemory(object, (long)var1_1, var3_2, dstOffset, length);
    }

    private static void copyMemoryWithSafePointPolling(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, size);
            length -= size;
            srcOffset += size;
            dstOffset += size;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void setMemory(long address, long bytes, byte value) {
        void var2_2;
        long l;
        UNSAFE.setMemory(l, (long)var2_2, value);
    }

    /*
     * WARNING - void declaration
     */
    static void setMemory(Object o, long offset, long bytes, byte value) {
        void var3_2;
        void var1_1;
        Object object;
        UNSAFE.setMemory(object, (long)var1_1, (long)var3_2, value);
    }

    /*
     * WARNING - void declaration
     */
    static boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
        void var2_2;
        byte[] byArray;
        long pos;
        void var1_1;
        void var3_3;
        int remainingBytes = length & 7;
        long baseOffset1 = BYTE_ARRAY_BASE_OFFSET + (long)startPos1;
        long diff = (long)(var3_3 - var1_1);
        if (length >= 8) {
            long end = baseOffset1 + (long)remainingBytes;
            for (long i = baseOffset1 - 8L + (long)length; i >= end; i -= 8L) {
                if (UNSAFE.getLong(bytes1, i) == UNSAFE.getLong(bytes2, i + diff)) continue;
                return false;
            }
        }
        if (remainingBytes >= 4 && UNSAFE.getInt(bytes1, pos = baseOffset1 + (long)(remainingBytes -= 4)) != UNSAFE.getInt(bytes2, pos + diff)) {
            return false;
        }
        long baseOffset2 = baseOffset1 + diff;
        if (remainingBytes >= 2) {
            return UNSAFE.getChar(bytes1, baseOffset1) == UNSAFE.getChar(bytes2, baseOffset2) && (remainingBytes == 2 || UNSAFE.getByte(bytes1, baseOffset1 + 2L) == UNSAFE.getByte(bytes2, baseOffset2 + 2L));
        }
        return remainingBytes == 0 || UNSAFE.getByte(byArray, baseOffset1) == UNSAFE.getByte(var2_2, baseOffset2);
    }

    /*
     * WARNING - void declaration
     */
    static int equalsConstantTime(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
        long pos;
        void var1_1;
        void var3_3;
        long result = 0L;
        long remainingBytes = length & 7;
        long baseOffset1 = BYTE_ARRAY_BASE_OFFSET + (long)startPos1;
        long end = baseOffset1 + remainingBytes;
        long diff = (long)(var3_3 - var1_1);
        for (long i = baseOffset1 - 8L + (long)length; i >= end; i -= 8L) {
            result |= UNSAFE.getLong(bytes1, i) ^ UNSAFE.getLong(bytes2, i + diff);
        }
        if (remainingBytes >= 4L) {
            result |= (long)(UNSAFE.getInt(bytes1, baseOffset1) ^ UNSAFE.getInt(bytes2, baseOffset1 + diff));
            remainingBytes -= 4L;
        }
        if (remainingBytes >= 2L) {
            pos = end - remainingBytes;
            result |= (long)(UNSAFE.getChar(bytes1, pos) ^ UNSAFE.getChar(bytes2, pos + diff));
            remainingBytes -= 2L;
        }
        if (remainingBytes == 1L) {
            void var2_2;
            byte[] byArray;
            pos = end - 1L;
            result |= (long)(UNSAFE.getByte(byArray, pos) ^ UNSAFE.getByte(var2_2, pos + diff));
        }
        return ConstantTimeUtils.equalsConstantTime(result, 0L);
    }

    /*
     * WARNING - void declaration
     */
    static boolean isZero(byte[] bytes, int startPos, int length) {
        void var1_1;
        byte[] byArray;
        if (length <= 0) {
            return true;
        }
        long baseOffset = BYTE_ARRAY_BASE_OFFSET + (long)startPos;
        int remainingBytes = length & 7;
        long end = baseOffset + (long)remainingBytes;
        for (long i = baseOffset - 8L + (long)var2_2; i >= end; i -= 8L) {
            if (UNSAFE.getLong(bytes, i) == 0L) continue;
            return false;
        }
        if (remainingBytes >= 4 && UNSAFE.getInt(bytes, baseOffset + (long)(remainingBytes -= 4)) != 0) {
            return false;
        }
        if (remainingBytes >= 2) {
            void var3_3;
            return UNSAFE.getChar(bytes, (long)var3_3) == '\u0000' && (remainingBytes == 2 || bytes[startPos + 2] == 0);
        }
        return byArray[var1_1] == 0;
    }

    /*
     * WARNING - void declaration
     */
    static int hashCodeAscii(byte[] bytes, int startPos, int length) {
        void var3_3;
        void var1_1;
        int hash = -1028477387;
        long baseOffset = BYTE_ARRAY_BASE_OFFSET + (long)startPos;
        int remainingBytes = length & 7;
        long end = baseOffset + (long)remainingBytes;
        for (long i = baseOffset - 8L + (long)var2_2; i >= end; i -= 8L) {
            hash = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(bytes, i), hash);
        }
        if (remainingBytes == 0) {
            return hash;
        }
        int hcConst = -862048943;
        if (remainingBytes != 2 & remainingBytes != 4 & remainingBytes != 6) {
            hash = hash * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(bytes, baseOffset));
            hcConst = 461845907;
            ++baseOffset;
        }
        if (remainingBytes != 1 & remainingBytes != 4 & remainingBytes != 5) {
            hash = hash * hcConst + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(bytes, baseOffset));
            hcConst = hcConst == -862048943 ? 461845907 : -862048943;
            baseOffset += 2L;
        }
        if (var1_1 >= 4) {
            byte[] byArray;
            return hash * hcConst + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, baseOffset));
        }
        return (int)var3_3;
    }

    static int hashCodeAsciiCompute(long value, int hash) {
        long l;
        return hash * -862048943 + PlatformDependent0.hashCodeAsciiSanitize((int)value) * 461845907 + (int)((l & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int value) {
        return value & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short value) {
        return value & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte value) {
        return value & 0x1F;
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        Class<?> clazz2;
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return clazz2.getClassLoader();
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public final ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long size) {
        long l;
        return UNSAFE.allocateMemory(l);
    }

    static void freeMemory(long address) {
        long l;
        UNSAFE.freeMemory(l);
    }

    /*
     * WARNING - void declaration
     */
    static long reallocateMemory(long address, long newSize) {
        void var2_1;
        long l;
        return UNSAFE.reallocateMemory(l, (long)var2_1);
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAndroid0() {
        void var0_1;
        String vmName = SystemPropertyUtil.get("java.vm.name");
        boolean isAndroid = "Dalvik".equals(vmName);
        if (isAndroid) {
            logger.debug("Platform: Android");
        }
        return (boolean)var0_1;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return SystemPropertyUtil.getBoolean("io.netty.tryReflectionSetAccessible", PlatformDependent0.javaVersion() < 9 || RUNNING_IN_NATIVE_IMAGE);
    }

    static boolean isExplicitTryReflectionSetAccessible() {
        return IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    /*
     * WARNING - void declaration
     */
    private static int javaVersion0() {
        void var0;
        int majorVersion = PlatformDependent0.isAndroid0() ? 6 : PlatformDependent0.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)majorVersion);
        return (int)var0;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        return PlatformDependent0.majorVersion(SystemPropertyUtil.get("java.specification.version", "1.6"));
    }

    /*
     * WARNING - void declaration
     */
    static int majorVersion(String javaSpecVersion) {
        void var1_1;
        String[] components = javaSpecVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            version[i] = Integer.parseInt(components[i]);
        }
        if (version[0] == 1) {
            assert (version[1] >= 6);
            return version[1];
        }
        return (int)var1_1[0];
    }

    private PlatformDependent0() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Unsafe unsafe;
        ByteBuffer direct;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        EXPLICIT_NO_UNSAFE_CAUSE = PlatformDependent0.explicitNoUnsafeCause0();
        JAVA_VERSION = PlatformDependent0.javaVersion0();
        IS_ANDROID = PlatformDependent0.isAndroid0();
        RUNNING_IN_NATIVE_IMAGE = SystemPropertyUtil.contains("org.graalvm.nativeimage.imagecode");
        IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = PlatformDependent0.explicitTryReflectionSetAccessible0();
        Field addressField = null;
        ReflectiveOperationException allocateArrayMethod = null;
        Object internalUnsafe = null;
        boolean storeFenceAvailable = false;
        Throwable unsafeUnavailabilityCause = EXPLICIT_NO_UNSAFE_CAUSE;
        if (unsafeUnavailabilityCause != null) {
            direct = null;
            addressField = null;
            unsafe = null;
            internalUnsafe = null;
        } else {
            long byteArrayIndexScale;
            Object maybeException;
            Unsafe finalUnsafe;
            direct = ByteBuffer.allocateDirect(1);
            Object maybeUnsafe = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Object run() {
                    try {
                        void var1_1;
                        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                        Throwable cause = ReflectionUtil.trySetAccessible(unsafeField, false);
                        if (cause != null) {
                            void var2_6;
                            return var2_6;
                        }
                        return var1_1.get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                        return noSuchFieldException;
                    }
                    catch (SecurityException securityException) {
                        SecurityException securityException2 = securityException;
                        return securityException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        NoClassDefFoundError noClassDefFoundError2 = noClassDefFoundError;
                        return noClassDefFoundError;
                    }
                }
            });
            if (maybeUnsafe instanceof Throwable) {
                unsafe = null;
                unsafeUnavailabilityCause = (Throwable)maybeUnsafe;
                if (logger.isTraceEnabled()) {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Throwable)maybeUnsafe);
                } else {
                    logger.debug("sun.misc.Unsafe.theUnsafe: unavailable: {}", (Object)((Throwable)maybeUnsafe).getMessage());
                }
            } else {
                unsafe = (Unsafe)maybeUnsafe;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                finalUnsafe = unsafe;
                maybeException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Object run() {
                        try {
                            Class<?> cls = finalUnsafe.getClass();
                            cls.getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                            if (PlatformDependent0.javaVersion() > 23) {
                                void var1_1;
                                cls.getDeclaredMethod("objectFieldOffset", Field.class);
                                cls.getDeclaredMethod("staticFieldOffset", Field.class);
                                cls.getDeclaredMethod("staticFieldBase", Field.class);
                                cls.getDeclaredMethod("arrayBaseOffset", Class.class);
                                cls.getDeclaredMethod("arrayIndexScale", Class.class);
                                cls.getDeclaredMethod("allocateMemory", Long.TYPE);
                                cls.getDeclaredMethod("reallocateMemory", Long.TYPE, Long.TYPE);
                                cls.getDeclaredMethod("freeMemory", Long.TYPE);
                                cls.getDeclaredMethod("setMemory", Long.TYPE, Long.TYPE, Byte.TYPE);
                                cls.getDeclaredMethod("setMemory", Object.class, Long.TYPE, Long.TYPE, Byte.TYPE);
                                cls.getDeclaredMethod("getBoolean", Object.class, Long.TYPE);
                                cls.getDeclaredMethod("getByte", Long.TYPE);
                                cls.getDeclaredMethod("getByte", Object.class, Long.TYPE);
                                cls.getDeclaredMethod("getInt", Long.TYPE);
                                cls.getDeclaredMethod("getInt", Object.class, Long.TYPE);
                                cls.getDeclaredMethod("getLong", Long.TYPE);
                                cls.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                                cls.getDeclaredMethod("putByte", Long.TYPE, Byte.TYPE);
                                cls.getDeclaredMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                                cls.getDeclaredMethod("putInt", Long.TYPE, Integer.TYPE);
                                cls.getDeclaredMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                                cls.getDeclaredMethod("putLong", Long.TYPE, Long.TYPE);
                                cls.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                                var1_1.getDeclaredMethod("addressSize", new Class[0]);
                            }
                            if (PlatformDependent0.javaVersion() >= 23) {
                                void var2_5;
                                long address = finalUnsafe.allocateMemory(8L);
                                finalUnsafe.putLong(address, 42L);
                                finalUnsafe.freeMemory((long)var2_5);
                            }
                            return null;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            UnsupportedOperationException unsupportedOperationException2 = unsupportedOperationException;
                            return unsupportedOperationException;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (maybeException == null) {
                    logger.debug("sun.misc.Unsafe base methods: all available");
                } else {
                    unsafe = null;
                    unsafeUnavailabilityCause = (Throwable)maybeException;
                    if (logger.isTraceEnabled()) {
                        logger.debug("sun.misc.Unsafe method unavailable:", unsafeUnavailabilityCause);
                    } else {
                        logger.debug("sun.misc.Unsafe method unavailable: {}", (Object)((Throwable)maybeException).getMessage());
                    }
                }
            }
            if (unsafe != null) {
                finalUnsafe = unsafe;
                maybeException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            finalUnsafe.getClass().getDeclaredMethod("storeFence", new Class[0]);
                            return null;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (maybeException == null) {
                    logger.debug("sun.misc.Unsafe.storeFence: available");
                    storeFenceAvailable = true;
                } else {
                    storeFenceAvailable = false;
                    if (logger.isTraceEnabled()) {
                        logger.debug("sun.misc.Unsafe.storeFence: unavailable", (Throwable)maybeException);
                    } else {
                        logger.debug("sun.misc.Unsafe.storeFence: unavailable: {}", (Object)((Throwable)maybeException).getMessage());
                    }
                }
            }
            if (unsafe != null) {
                finalUnsafe = unsafe;
                Object maybeAddressField = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Object run() {
                        try {
                            void var1_1;
                            void var2_4;
                            Field field = Buffer.class.getDeclaredField("address");
                            long offset = finalUnsafe.objectFieldOffset(field);
                            long l = finalUnsafe.getLong(direct, (long)var2_4);
                            if (l == 0L) {
                                return null;
                            }
                            return var1_1;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                            return noSuchFieldException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (maybeAddressField instanceof Field) {
                    addressField = (Field)maybeAddressField;
                    logger.debug("java.nio.Buffer.address: available");
                } else {
                    unsafeUnavailabilityCause = (Throwable)maybeAddressField;
                    if (logger.isTraceEnabled()) {
                        logger.debug("java.nio.Buffer.address: unavailable", (Throwable)maybeAddressField);
                    } else {
                        logger.debug("java.nio.Buffer.address: unavailable: {}", (Object)((Throwable)maybeAddressField).getMessage());
                    }
                    unsafe = null;
                }
            }
            if (unsafe != null && (byteArrayIndexScale = (long)unsafe.arrayIndexScale(byte[].class)) != 1L) {
                logger.debug("unsafe.arrayIndexScale is {} (expected: 1). Not using unsafe.", (Object)byteArrayIndexScale);
                unsafeUnavailabilityCause = new UnsupportedOperationException("Unexpected unsafe.arrayIndexScale");
                unsafe = null;
            }
        }
        UNSAFE_UNAVAILABILITY_CAUSE = unsafeUnavailabilityCause;
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_BASE_OFFSET = -1L;
            LONG_ARRAY_INDEX_SCALE = -1L;
            INT_ARRAY_BASE_OFFSET = -1L;
            INT_ARRAY_INDEX_SCALE = -1L;
            UNALIGNED = false;
            BITS_MAX_DIRECT_MEMORY = -1L;
            DIRECT_BUFFER_CONSTRUCTOR = null;
            ALLOCATE_ARRAY_METHOD = null;
            STORE_FENCE_AVAILABLE = false;
        } else {
            void var2_1;
            boolean unaligned22;
            Constructor directBufferConstructor;
            long address = -1L;
            try {
                Object maybeDirectBufferConstructor = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Object run() {
                        try {
                            void var1_1;
                            Constructor<?> constructor = PlatformDependent0.javaVersion() >= 21 ? direct.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE) : direct.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                            Throwable cause = ReflectionUtil.trySetAccessible(constructor, true);
                            if (cause != null) {
                                void var2_4;
                                return var2_4;
                            }
                            return var1_1;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (maybeDirectBufferConstructor instanceof Constructor) {
                    address = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)maybeDirectBufferConstructor).newInstance(address, 1);
                        directBufferConstructor = (Constructor)maybeDirectBufferConstructor;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (InstantiationException instantiationException) {
                        directBufferConstructor = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        directBufferConstructor = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        directBufferConstructor = null;
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.debug("direct buffer constructor: unavailable", (Throwable)maybeDirectBufferConstructor);
                    } else {
                        logger.debug("direct buffer constructor: unavailable: {}", (Object)((Throwable)maybeDirectBufferConstructor).getMessage());
                    }
                    directBufferConstructor = null;
                }
            }
            finally {
                if (address != -1L) {
                    UNSAFE.freeMemory(address);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = directBufferConstructor;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset(addressField);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            INT_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            INT_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
            LONG_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            LONG_ARRAY_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);
            final AtomicLong maybeMaxMemory = new AtomicLong(-1L);
            Object maybeUnaligned = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Object run() {
                    try {
                        void var3_8;
                        void var1_1;
                        Method unalignedMethod;
                        Throwable cause;
                        Class<?> bitsClass = Class.forName("java.nio.Bits", false, PlatformDependent0.getSystemClassLoader());
                        int version = PlatformDependent0.javaVersion();
                        if (PlatformDependent0.unsafeStaticFieldOffsetSupported() && version >= 9) {
                            void var2_7;
                            Object object;
                            long offset;
                            String fieldName = version >= 11 ? "MAX_MEMORY" : "maxMemory";
                            try {
                                Field maxMemoryField = bitsClass.getDeclaredField(fieldName);
                                if (maxMemoryField.getType() == Long.TYPE) {
                                    offset = UNSAFE.staticFieldOffset(maxMemoryField);
                                    object = UNSAFE.staticFieldBase(maxMemoryField);
                                    maybeMaxMemory.lazySet(UNSAFE.getLong(object, offset));
                                }
                            }
                            catch (Throwable throwable) {}
                            object = var2_7 >= 11 ? "UNALIGNED" : "unaligned";
                            try {
                                Field unalignedField = bitsClass.getDeclaredField((String)object);
                                if (unalignedField.getType() == Boolean.TYPE) {
                                    offset = UNSAFE.staticFieldOffset(unalignedField);
                                    object = UNSAFE.staticFieldBase(unalignedField);
                                    return UNSAFE.getBoolean(object, offset);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {}
                        }
                        if ((cause = ReflectionUtil.trySetAccessible(unalignedMethod = var1_1.getDeclaredMethod("unaligned", new Class[0]), true)) != null) {
                            return cause;
                        }
                        return var3_8.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                        return noSuchMethodException;
                    }
                    catch (SecurityException securityException) {
                        SecurityException securityException2 = securityException;
                        return securityException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalAccessException illegalAccessException2 = illegalAccessException;
                        return illegalAccessException;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        return classNotFoundException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        InvocationTargetException invocationTargetException2 = invocationTargetException;
                        return invocationTargetException;
                    }
                }
            });
            if (maybeUnaligned instanceof Boolean) {
                unaligned22 = (Boolean)maybeUnaligned;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)unaligned22);
            } else {
                String unaligned22 = SystemPropertyUtil.get("os.arch", "");
                unaligned22 = unaligned22.matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                Throwable t = (Throwable)maybeUnaligned;
                if (logger.isTraceEnabled()) {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}", (Object)unaligned22, (Object)t);
                } else {
                    logger.debug("java.nio.Bits.unaligned: unavailable, {}, {}", (Object)unaligned22, (Object)t.getMessage());
                }
            }
            UNALIGNED = unaligned22;
            long l = BITS_MAX_DIRECT_MEMORY = maybeMaxMemory.get() >= 0L ? maybeMaxMemory.get() : -1L;
            if (PlatformDependent0.javaVersion() >= 9) {
                Object finalInternalUnsafe;
                Object maybeException = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public final Object run() {
                        try {
                            GenericDeclaration genericDeclaration = PlatformDependent0.getClassLoader(PlatformDependent0.class).loadClass("jdk.internal.misc.Unsafe");
                            genericDeclaration = genericDeclaration.getDeclaredMethod("getUnsafe", new Class[0]);
                            return ((Method)genericDeclaration).invoke(null, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            return throwable;
                        }
                    }
                });
                if (!(maybeException instanceof Throwable) && (maybeException = AccessController.doPrivileged(new PrivilegedAction<Object>(finalInternalUnsafe = (internalUnsafe = maybeException)){
                    final /* synthetic */ Object val$finalInternalUnsafe;
                    {
                        this.val$finalInternalUnsafe = object;
                    }

                    @Override
                    public final Object run() {
                        try {
                            return this.val$finalInternalUnsafe.getClass().getDeclaredMethod("allocateUninitializedArray", Class.class, Integer.TYPE);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                            return noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                })) instanceof Method) {
                    ReflectiveOperationException reflectiveOperationException;
                    try {
                        void var3_4;
                        Method m = (Method)maybeException;
                        byte[] bytes = (byte[])m.invoke(finalInternalUnsafe, Byte.TYPE, 8);
                        assert (((void)var3_4).length == 8);
                        allocateArrayMethod = reflectiveOperationException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        reflectiveOperationException = illegalAccessException;
                        maybeException = illegalAccessException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        reflectiveOperationException = invocationTargetException;
                        maybeException = invocationTargetException;
                    }
                }
                if (maybeException instanceof Throwable) {
                    if (logger.isTraceEnabled()) {
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable", (Throwable)maybeException);
                    } else {
                        void var0_8;
                        logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable: {}", (Object)((Throwable)var0_8).getMessage());
                    }
                } else {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): available");
                }
            } else {
                logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable prior to Java9");
            }
            ALLOCATE_ARRAY_METHOD = var2_1;
            STORE_FENCE_AVAILABLE = storeFenceAvailable;
        }
        ALIGN_SLICE = PlatformDependent0.javaVersion() > 9 ? (Method)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public final Object run() {
                try {
                    return ByteBuffer.class.getDeclaredMethod("alignedSlice", Integer.TYPE);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }) : null;
        INTERNAL_UNSAFE = internalUnsafe;
        logger.debug("java.nio.DirectByteBuffer.<init>(long, {int,long}): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
    }
}

