/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.Collection;
import java.util.Map;

public final class ObjectUtil {
    private static final float FLOAT_ZERO = 0.0f;
    private static final double DOUBLE_ZERO = 0.0;
    private static final long LONG_ZERO = 0L;
    private static final int INT_ZERO = 0;

    private ObjectUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNull(T arg, String text) {
        T t;
        if (arg == null) {
            void var1_1;
            throw new NullPointerException((String)var1_1);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] deepCheckNotNull(String text, T ... varargs) {
        void var1_1;
        if (varargs == null) {
            throw new NullPointerException(text);
        }
        T[] TArray = varargs;
        int n = varargs.length;
        for (int i = 0; i < n; ++i) {
            T t = TArray[i];
            if (t != null) continue;
            throw new NullPointerException(text);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNullWithIAE(T arg, String paramName) throws IllegalArgumentException {
        T t;
        if (arg == null) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be null");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T checkNotNullArrayParam(T value, int index, String name) throws IllegalArgumentException {
        T t;
        if (value == null) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException("Array index " + (int)var1_1 + " of parameter '" + (String)var2_2 + "' must not be null");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkPositive(int i, String name) {
        int n;
        if (i <= 0) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " : " + i + " (expected: > 0)");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static long checkPositive(long l, String name) {
        long l2;
        if (l <= 0L) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " : " + l + " (expected: > 0)");
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public static double checkPositive(double d, String name) {
        double d2;
        if (d <= 0.0) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " : " + d + " (expected: > 0)");
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public static float checkPositive(float f, String name) {
        float f2;
        if (f <= 0.0f) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " : " + f + " (expected: > 0)");
        }
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkPositiveOrZero(int i, String name) {
        int n;
        if (i < 0) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " : " + i + " (expected: >= 0)");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static long checkPositiveOrZero(long l, String name) {
        long l2;
        if (l < 0L) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " : " + l + " (expected: >= 0)");
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public static double checkPositiveOrZero(double d, String name) {
        double d2;
        if (d < 0.0) {
            void var2_1;
            throw new IllegalArgumentException((String)var2_1 + " : " + d + " (expected: >= 0)");
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public static float checkPositiveOrZero(float f, String name) {
        float f2;
        if (f < 0.0f) {
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " : " + f + " (expected: >= 0)");
        }
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkInRange(int i, int start, int end, String name) {
        int n;
        if (i < start || i > end) {
            void var2_2;
            void var1_1;
            void var3_3;
            throw new IllegalArgumentException((String)var3_3 + ": " + i + " (expected: " + (int)var1_1 + "-" + (int)var2_2 + ")");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static long checkInRange(long l, long start, long end, String name) {
        long l2;
        if (l < start || l > end) {
            void var2_1;
            throw new IllegalArgumentException(name + ": " + l + " (expected: " + (long)var2_1 + "-" + end + ")");
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] checkNonEmpty(T[] array, String name) {
        T[] TArray;
        if (ObjectUtil.checkNotNull(array, name).length == 0) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] checkNonEmpty(byte[] array, String name) {
        byte[] byArray;
        if (ObjectUtil.checkNotNull(array, name).length == 0) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] checkNonEmpty(char[] array, String name) {
        char[] cArray;
        if (ObjectUtil.checkNotNull(array, name).length == 0) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name) {
        T t;
        if (ObjectUtil.checkNotNull(collection, name).isEmpty()) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static String checkNonEmpty(String value, String name) {
        String string;
        if (ObjectUtil.checkNotNull(value, name).isEmpty()) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V, T extends Map<K, V>> T checkNonEmpty(T value, String name) {
        T t;
        if (ObjectUtil.checkNotNull(value, name).isEmpty()) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static CharSequence checkNonEmpty(CharSequence value, String name) {
        CharSequence charSequence;
        if (ObjectUtil.checkNotNull(value, name).length() == 0) {
            void var1_1;
            throw new IllegalArgumentException("Param '" + (String)var1_1 + "' must not be empty");
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    public static String checkNonEmptyAfterTrim(String value, String name) {
        void var1_1;
        String string = ObjectUtil.checkNotNull(value, name).trim();
        return ObjectUtil.checkNonEmpty(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int intValue(Integer wrapper, int defaultValue) {
        void var1_1;
        if (wrapper != null) {
            Integer n;
            return n;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long longValue(Long wrapper, long defaultValue) {
        void var1_1;
        if (wrapper != null) {
            Long l;
            return l;
        }
        return (long)var1_1;
    }
}

