/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ConcurrentSet;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObjectCleaner {
    private static final int REFERENCE_QUEUE_POLL_TIMEOUT_MS = Math.max(500, SystemPropertyUtil.getInt("io.netty.util.internal.ObjectCleaner.refQueuePollTimeout", 10000));
    static final String CLEANER_THREAD_NAME = ObjectCleaner.class.getSimpleName() + "Thread";
    private static final Set<AutomaticCleanerReference> LIVE_SET = new ConcurrentSet<AutomaticCleanerReference>();
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private static final AtomicBoolean CLEANER_RUNNING = new AtomicBoolean(false);
    private static final Runnable CLEANER_TASK = new Runnable(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void var1_1;
            boolean interrupted = false;
            while (true) {
                if (!LIVE_SET.isEmpty()) {
                    void var2_2;
                    AutomaticCleanerReference reference;
                    try {
                        reference = (AutomaticCleanerReference)REFERENCE_QUEUE.remove(REFERENCE_QUEUE_POLL_TIMEOUT_MS);
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        continue;
                    }
                    if (reference == null) continue;
                    try {
                        reference.cleanup();
                    }
                    catch (Throwable throwable) {}
                    LIVE_SET.remove(var2_2);
                    continue;
                }
                CLEANER_RUNNING.set(false);
                if (LIVE_SET.isEmpty() || !CLEANER_RUNNING.compareAndSet(false, true)) break;
            }
            if (var1_1 != false) {
                Thread.currentThread().interrupt();
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    public static void register(Object object, Runnable cleanupTask) {
        void var1_1;
        Object reference = new AutomaticCleanerReference(object, (Runnable)ObjectUtil.checkNotNull(var1_1, "cleanupTask"));
        LIVE_SET.add((AutomaticCleanerReference)reference);
        if (CLEANER_RUNNING.compareAndSet(false, true)) {
            Object object2;
            Object cleanupThread = new FastThreadLocalThread(CLEANER_TASK);
            ((Thread)cleanupThread).setPriority(1);
            AccessController.doPrivileged(new PrivilegedAction<Void>((Thread)cleanupThread){
                final /* synthetic */ Thread val$cleanupThread;
                {
                    this.val$cleanupThread = thread;
                }

                @Override
                public final Void run() {
                    this.val$cleanupThread.setContextClassLoader(null);
                    return null;
                }
            });
            ((Thread)cleanupThread).setName(CLEANER_THREAD_NAME);
            ((Thread)cleanupThread).setDaemon(true);
            ((Thread)object2).start();
        }
    }

    public static int getLiveSetCount() {
        return LIVE_SET.size();
    }

    private ObjectCleaner() {
    }

    private static final class AutomaticCleanerReference
    extends WeakReference<Object> {
        private final Runnable cleanupTask;

        /*
         * WARNING - void declaration
         */
        AutomaticCleanerReference(Object referent, Runnable cleanupTask) {
            super(var1_1, REFERENCE_QUEUE);
            void var2_2;
            void var1_1;
            this.cleanupTask = var2_2;
        }

        final void cleanup() {
            this.cleanupTask.run();
        }

        @Override
        public final Thread get() {
            return null;
        }

        @Override
        public final void clear() {
            LIVE_SET.remove(this);
            super.clear();
        }
    }
}

