/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.NativeLibraryUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;
    private static final boolean TRY_TO_PATCH_SHADED_ID;
    private static final boolean DETECT_NATIVE_LIBRARY_DUPLICATES;
    private static final byte[] UNIQUE_ID_BYTES;

    /*
     * WARNING - void declaration
     */
    public static void loadFirstAvailable(ClassLoader loader, String ... names) {
        void var2_2;
        void var1_1;
        ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
        String[] stringArray = names;
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            String name = stringArray[i];
            try {
                NativeLibraryLoader.load(name, loader);
                logger.debug("Loaded library with name '{}'", (Object)name);
                return;
            }
            catch (Throwable t) {
                suppressed.add(t);
                continue;
            }
        }
        IllegalArgumentException iae = new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString((Object[])var1_1));
        ThrowableUtil.addSuppressedAndClear(iae, (List<Throwable>)var2_2);
        throw stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private static String calculateMangledPackagePrefix() {
        void var1_1;
        void var0;
        String expected;
        String maybeShaded = NativeLibraryLoader.class.getName();
        if (!maybeShaded.endsWith(expected = "io!netty!util!internal!NativeLibraryLoader".replace('!', '.'))) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", expected, maybeShaded));
        }
        return maybeShaded.substring(0, var0.length() - var1_1.length()).replace("_", "_1").replace('.', '_');
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String originalName, ClassLoader loader) {
        String mangledPackagePrefix = NativeLibraryLoader.calculateMangledPackagePrefix();
        String name = mangledPackagePrefix + originalName;
        ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
        try {
            NativeLibraryLoader.loadLibrary(loader, name, false);
            return;
        }
        catch (Throwable ex) {
            suppressed.add(ex);
            String libname = System.mapLibraryName(name);
            String path = NATIVE_RESOURCE_HOME + libname;
            InputStream in = null;
            FileOutputStream out = null;
            File tmpFile = null;
            URL url = NativeLibraryLoader.getResource(path, loader);
            try {
                void var1_2;
                void var2_3;
                int length;
                if (url == null) {
                    String fileName;
                    if (!PlatformDependent.isOsx()) {
                        FileNotFoundException fnf = new FileNotFoundException(fileName);
                        ThrowableUtil.addSuppressedAndClear(fnf, suppressed);
                        throw fnf;
                    }
                    fileName = path.endsWith(".jnilib") ? "META-INF/native/lib" + name + ".dynlib" : "META-INF/native/lib" + name + ".jnilib";
                    url = NativeLibraryLoader.getResource(fileName, loader);
                    if (url == null) {
                        FileNotFoundException fnf = new FileNotFoundException(fileName);
                        ThrowableUtil.addSuppressedAndClear(fnf, suppressed);
                        throw fnf;
                    }
                }
                int index = libname.lastIndexOf(46);
                String prefix = libname.substring(0, index);
                String suffix = libname.substring(index);
                tmpFile = PlatformDependent.createTempFile(prefix, suffix, WORKDIR);
                in = url.openStream();
                out = new FileOutputStream(tmpFile);
                byte[] buffer = new byte[8192];
                while ((length = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
                out.flush();
                if (NativeLibraryLoader.shouldShadedLibraryIdBePatched((String)var2_3)) {
                    String string;
                    NativeLibraryLoader.tryPatchShadedLibraryIdAndSign(tmpFile, string);
                }
                NativeLibraryLoader.closeQuietly(out);
                out = null;
                NativeLibraryLoader.loadLibrary((ClassLoader)var1_2, tmpFile.getPath(), true);
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    try {
                        if (tmpFile != null && tmpFile.isFile() && tmpFile.canRead() && !NoexecVolumeDetector.canExecuteExecutable(tmpFile)) {
                            logger.info("{} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -D{}=[path] to set native working directory separately.", (Object)tmpFile.getPath(), (Object)"io.netty.native.workdir");
                        }
                    }
                    catch (Throwable t) {
                        suppressed.add(t);
                        logger.debug("Error checking if {} is on a file store mounted with noexec", (Object)tmpFile, (Object)t);
                    }
                    ThrowableUtil.addSuppressedAndClear(e, suppressed);
                    throw e;
                    catch (Exception e2) {
                        void var3_4;
                        UnsatisfiedLinkError ule = new UnsatisfiedLinkError("could not load a native library: " + (String)var3_4);
                        ule.initCause(e2);
                        ThrowableUtil.addSuppressedAndClear(ule, suppressed);
                        throw ule;
                    }
                }
                catch (Throwable throwable) {
                    NativeLibraryLoader.closeQuietly(in);
                    NativeLibraryLoader.closeQuietly(out);
                    if (!(tmpFile == null || DELETE_NATIVE_LIB_AFTER_LOADING && tmpFile.delete())) {
                        tmpFile.deleteOnExit();
                    }
                    throw throwable;
                }
            }
            NativeLibraryLoader.closeQuietly(in);
            NativeLibraryLoader.closeQuietly(null);
            if (!(tmpFile == null || DELETE_NATIVE_LIB_AFTER_LOADING && tmpFile.delete())) {
                tmpFile.deleteOnExit();
                return;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static URL getResource(String path, ClassLoader loader) {
        void var1_1;
        String string;
        Enumeration<URL> urls;
        try {
            urls = loader == null ? ClassLoader.getSystemResources(path) : ((ClassLoader)((Object)urls)).getResources(path);
        }
        catch (IOException iox) {
            throw new RuntimeException("An error occurred while getting the resources for " + path, iox);
        }
        ArrayList<URL> urlsList = Collections.list(urls);
        int size = urlsList.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return (URL)urlsList.get(0);
            }
        }
        if (DETECT_NATIVE_LIBRARY_DUPLICATES) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                URL url = (URL)urlsList.get(0);
                byte[] digest = NativeLibraryLoader.digest(md, url);
                boolean allSame = true;
                if (digest != null) {
                    for (int i = 1; i < size; ++i) {
                        byte[] digest2 = NativeLibraryLoader.digest(md, (URL)urlsList.get(i));
                        if (digest2 != null && Arrays.equals(digest, digest2)) continue;
                        allSame = false;
                        break;
                    }
                } else {
                    allSame = false;
                }
                if (allSame) {
                    return url;
                }
            }
            catch (NoSuchAlgorithmException e) {
                void var3_5;
                logger.debug("Don't support SHA-256, can't check if resources have same content.", (Throwable)var3_5);
            }
            throw new IllegalStateException("Multiple resources found for '" + path + "' with different content: " + urlsList);
        }
        logger.warn("Multiple resources found for '" + string + "' with different content: " + urlsList + ". Please fix your dependency graph.");
        return (URL)var1_1.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] digest(MessageDigest digest, URL url) {
        Object object;
        InputStream in = null;
        try {
            int i;
            in = url.openStream();
            byte[] bytes = new byte[8192];
            while ((i = in.read(bytes)) != -1) {
                void var3_5;
                digest.update(bytes, 0, (int)var3_5);
            }
            object = ((MessageDigest)object).digest();
        }
        catch (IOException e) {
            try {
                void var1_3;
                logger.debug("Can't read resource.", (Throwable)var1_3);
            }
            catch (Throwable throwable) {
                void var2_4;
                NativeLibraryLoader.closeQuietly((Closeable)var2_4);
                throw throwable;
            }
            NativeLibraryLoader.closeQuietly(in);
            return null;
        }
        NativeLibraryLoader.closeQuietly(in);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static void tryPatchShadedLibraryIdAndSign(File libraryFile, String originalName) {
        File file;
        void var1_1;
        if (!new File("/Library/Developer/CommandLineTools").exists()) {
            logger.debug("Can't patch shaded library id as CommandLineTools are not installed. Consider installing CommandLineTools with 'xcode-select --install'");
            return;
        }
        String newId = new String(NativeLibraryLoader.generateUniqueId(originalName.length()), CharsetUtil.UTF_8);
        if (!NativeLibraryLoader.tryExec("install_name_tool -id " + (String)var1_1 + " " + libraryFile.getAbsolutePath())) {
            return;
        }
        NativeLibraryLoader.tryExec("codesign -s - " + file.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean tryExec(String cmd) {
        try {
            int exitValue = Runtime.getRuntime().exec(cmd).waitFor();
            if (exitValue != 0) {
                logger.debug("Execution of '{}' failed: {}", (Object)cmd, (Object)exitValue);
                return false;
            }
            logger.debug("Execution of '{}' succeed: {}", (Object)cmd, (Object)exitValue);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            logger.info("Execution of '{}' failed.", (Object)cmd, (Object)e);
        }
        catch (SecurityException e) {
            void var1_3;
            String string;
            logger.error("Execution of '{}' failed.", (Object)string, (Object)var1_3);
        }
        return false;
    }

    private static boolean shouldShadedLibraryIdBePatched(String packagePrefix) {
        String string;
        return TRY_TO_PATCH_SHADED_ID && PlatformDependent.isOsx() && !string.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] generateUniqueId(int length) {
        void var0_1;
        byte[] idBytes = new byte[length];
        for (int i = 0; i < idBytes.length; ++i) {
            idBytes[i] = UNIQUE_ID_BYTES[PlatformDependent.threadLocalRandom().nextInt(UNIQUE_ID_BYTES.length)];
        }
        return var0_1;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadLibrary(ClassLoader loader, String name, boolean absolute) {
        Throwable suppressed = null;
        try {
            try {
                loader = NativeLibraryLoader.tryToLoadClass(loader, NativeLibraryUtil.class);
                NativeLibraryLoader.loadLibraryByHelper(loader, name, absolute);
                logger.debug("Successfully loaded the library {}", (Object)name);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    void var2_4;
                    block9: {
                        loader = unsatisfiedLinkError;
                        suppressed = unsatisfiedLinkError;
                        break block9;
                        catch (Exception exception) {
                            loader = exception;
                            suppressed = exception;
                        }
                    }
                    NativeLibraryUtil.loadLibrary(name, (boolean)var2_4);
                    logger.debug("Successfully loaded the library {}", (Object)name);
                    return;
                }
                catch (UnsatisfiedLinkError ule) {
                    void var0_2;
                    if (suppressed != null) {
                        void var3_5;
                        ThrowableUtil.addSuppressed((Throwable)ule, (Throwable)var3_5);
                    }
                    throw var0_2;
                }
            }
        }
        catch (NoSuchMethodError nsme) {
            void var1_3;
            if (suppressed != null) {
                ThrowableUtil.addSuppressed((Throwable)nsme, suppressed);
            }
            NativeLibraryLoader.rethrowWithMoreDetailsIfPossible((String)var1_3, nsme);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Guarded by version check")
    private static void rethrowWithMoreDetailsIfPossible(String name, NoSuchMethodError error) {
        void var1_1;
        if (PlatformDependent.javaVersion() >= 7) {
            String string;
            throw new LinkageError("Possible multiple incompatible native libraries on the classpath for '" + string + "'?", error);
        }
        throw var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void loadLibraryByHelper(final Class<?> helper, final String name, boolean absolute) throws UnsatisfiedLinkError {
        void var2_2;
        Throwable ret = AccessController.doPrivileged(new PrivilegedAction<Object>((boolean)var2_2){
            final /* synthetic */ boolean val$absolute;
            {
                this.val$absolute = bl;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Object run() {
                try {
                    void var1_1;
                    Method method = helper.getMethod("loadLibrary", String.class, Boolean.TYPE);
                    method.setAccessible(true);
                    return var1_1.invoke(null, name, this.val$absolute);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    return exception;
                }
            }
        });
        if (ret instanceof Throwable) {
            void var1_1;
            Throwable throwable;
            Throwable t = ret;
            assert (!(t instanceof UnsatisfiedLinkError)) : t + " should be a wrapper throwable";
            Throwable cause = t.getCause();
            if (cause instanceof UnsatisfiedLinkError) {
                throw (UnsatisfiedLinkError)cause;
            }
            UnsatisfiedLinkError ule = new UnsatisfiedLinkError(t.getMessage());
            ule.initCause(throwable);
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> tryToLoadClass(ClassLoader loader, Class<?> helper) throws ClassNotFoundException {
        try {
            return Class.forName(helper.getName(), false, loader);
        }
        catch (ClassNotFoundException e1) {
            if (loader == null) {
                throw e1;
            }
            try {
                void var1_1;
                ClassLoader classLoader;
                byte[] classBinary = NativeLibraryLoader.classToByteArray(helper);
                return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>((Class)var1_1, classBinary){
                    final /* synthetic */ Class val$helper;
                    final /* synthetic */ byte[] val$classBinary;
                    {
                        this.val$helper = clazz;
                        this.val$classBinary = byArray;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Class<?> run() {
                        try {
                            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                            defineClass.setAccessible(true);
                            return (Class)defineClass.invoke((Object)classLoader, this.val$helper.getName(), this.val$classBinary, 0, this.val$classBinary.length);
                        }
                        catch (Exception e) {
                            void var1_2;
                            throw new IllegalStateException("Define class failed!", (Throwable)var1_2);
                        }
                    }
                });
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException e2 = classNotFoundException;
                ThrowableUtil.addSuppressed((Throwable)classNotFoundException, e1);
                throw e2;
            }
            catch (RuntimeException runtimeException) {
                RuntimeException e2 = runtimeException;
                ThrowableUtil.addSuppressed((Throwable)runtimeException, e1);
                throw e2;
            }
            catch (Error error) {
                void var3_6;
                void var2_2;
                Error e2 = error;
                ThrowableUtil.addSuppressed((Throwable)error, (Throwable)var2_2);
                throw var3_6;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] classToByteArray(Class<?> clazz) throws ClassNotFoundException {
        byte[] r22;
        URL classUrl;
        String fileName = clazz.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            fileName = fileName.substring(lastDot + 1);
        }
        if ((classUrl = clazz.getResource(fileName + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        InputStream in = null;
        try {
            int r22;
            in = classUrl.openStream();
            while ((r22 = in.read(buf)) != -1) {
                out.write(buf, 0, r22);
            }
            r22 = out.toByteArray();
        }
        catch (IOException ex) {
            try {
                void var1_5;
                Class<?> clazz2;
                throw new ClassNotFoundException(clazz2.getName(), (Throwable)var1_5);
            }
            catch (Throwable throwable) {
                void var3_8;
                NativeLibraryLoader.closeQuietly(in);
                NativeLibraryLoader.closeQuietly((Closeable)var3_8);
                throw throwable;
            }
        }
        NativeLibraryLoader.closeQuietly(in);
        NativeLibraryLoader.closeQuietly(out);
        return r22;
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                Closeable closeable;
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private NativeLibraryLoader() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        UNIQUE_ID_BYTES = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(CharsetUtil.US_ASCII);
        String workdir = SystemPropertyUtil.get("io.netty.native.workdir");
        if (workdir != null) {
            void var0;
            File f = new File(workdir);
            f.mkdirs();
            try {
                f = f.getAbsoluteFile();
            }
            catch (Exception exception) {}
            WORKDIR = var0;
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR);
        } else {
            WORKDIR = PlatformDependent.tmpdir();
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = SystemPropertyUtil.getBoolean("io.netty.native.deleteLibAfterLoading", true);
        logger.debug("-Dio.netty.native.deleteLibAfterLoading: {}", (Object)DELETE_NATIVE_LIB_AFTER_LOADING);
        TRY_TO_PATCH_SHADED_ID = SystemPropertyUtil.getBoolean("io.netty.native.tryPatchShadedId", true);
        logger.debug("-Dio.netty.native.tryPatchShadedId: {}", (Object)TRY_TO_PATCH_SHADED_ID);
        DETECT_NATIVE_LIBRARY_DUPLICATES = SystemPropertyUtil.getBoolean("io.netty.native.detectNativeLibraryDuplicates", true);
        logger.debug("-Dio.netty.native.detectNativeLibraryDuplicates: {}", (Object)DETECT_NATIVE_LIBRARY_DUPLICATES);
    }

    private static final class NoexecVolumeDetector {
        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private static boolean canExecuteExecutable(File file) throws IOException {
            File file2;
            void var1_1;
            void var2_2;
            EnumSet<PosixFilePermission> executePermissions;
            if (PlatformDependent.javaVersion() < 7) {
                return true;
            }
            if (file.canExecute()) {
                return true;
            }
            Set<PosixFilePermission> existingFilePermissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            if (existingFilePermissions.containsAll(executePermissions = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE))) {
                return false;
            }
            EnumSet<PosixFilePermission> newPermissions = EnumSet.copyOf(existingFilePermissions);
            newPermissions.addAll((Collection<PosixFilePermission>)var2_2);
            Files.setPosixFilePermissions(file.toPath(), (Set<PosixFilePermission>)var1_1);
            return file2.canExecute();
        }

        private NoexecVolumeDetector() {
        }
    }
}

